/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReplyEntry
extends Entry {
    public static final String NO_EXCEPTION = "no-exception";
    public static final String CREATE_EXCEPTION = "create-exception";
    public static final String ACCESS_EXCEPTION = "access-exception";
    public static final String OTHER_EXCEPTION = "other-exception";
    private String replyType;
    private String replyMsg;

    public ReplyEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("reply")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals(NO_EXCEPTION)) {
                this.replyType = NO_EXCEPTION;
                this.replyMsg = null;
                continue;
            }
            if (node.getNodeName().equals(CREATE_EXCEPTION)) {
                this.replyType = CREATE_EXCEPTION;
                this.replyMsg = this.getText(node);
                continue;
            }
            if (node.getNodeName().equals(ACCESS_EXCEPTION)) {
                this.replyType = ACCESS_EXCEPTION;
                this.replyMsg = this.getText(node);
                continue;
            }
            if (!node.getNodeName().equals(OTHER_EXCEPTION)) continue;
            this.replyType = OTHER_EXCEPTION;
            this.replyMsg = this.getText(node);
        }
    }

    public String getReplyType() {
        return this.replyType;
    }

    public String getReplyMsg() {
        return this.replyMsg;
    }

    public String toString() {
        String result = "<reply>\n";
        result = this.replyMsg == null ? result + "</" + this.replyType + ">" : result + "<" + this.replyType + ">" + this.replyMsg + "\n</" + this.replyType + ">\n";
        result = result + "</reply>\n";
        return result;
    }
}

