/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.utils;

import com.sun.ts.lib.harness.EETest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class ToolRunner {
    private String commandLine;
    private String stdout;
    private String stderr;
    private Process process;

    public ToolRunner(String commandLine) {
        this.commandLine = commandLine;
    }

    public int execute() throws EETest.Fault {
        if (this.process != null) {
            throw new IllegalStateException("Tool has already been executed.");
        }
        try {
            this.process = Runtime.getRuntime().exec(this.commandLine);
        }
        catch (IOException e) {
            throw new EETest.Fault("Unable to execute '" + this.commandLine + "'.", e);
        }
        StreamReader ir = new StreamReader(this.process.getInputStream());
        ir.start();
        StreamReader er = new StreamReader(this.process.getErrorStream());
        er.start();
        try {
            this.process.waitFor();
            ir.join();
            er.join();
        }
        catch (InterruptedException e) {
            throw new EETest.Fault("Execution interrupted.", e);
        }
        this.stdout = ir.getOutput();
        this.stderr = er.getOutput();
        return this.process.exitValue();
    }

    public String getStdOut() {
        return this.stdout;
    }

    public String getStdErr() {
        return this.stderr;
    }

    private class StreamReader
    extends Thread {
        private InputStream is;
        private String output;

        public StreamReader(InputStream is) {
            this.is = is;
        }

        @Override
        public void run() {
            StringBuffer buffer = new StringBuffer();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.is));
                do {
                    if ((line = reader.readLine()) == null) continue;
                    buffer.append(line);
                    buffer.append('\n');
                } while (line != null);
                reader.close();
            }
            catch (IOException e) {
                buffer.append(e.getMessage());
            }
            this.output = buffer.toString();
        }

        public String getOutput() {
            return this.output;
        }
    }
}

