/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.cascadeall.manyXone;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.cascadeall.manyXone.A;
import com.sun.ts.tests.jpa.core.entitytest.cascadeall.manyXone.B;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMX1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMX1Test1");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A aRef = new A("1", "bean1", 1);
            B b1 = new B("1", "b1", 1, aRef);
            this.getEntityManager().persist((Object)b1);
            B b2 = new B("2", "b2", 1, aRef);
            this.getEntityManager().persist((Object)b2);
            B b3 = new B("3", "b3", 1, aRef);
            this.getEntityManager().persist((Object)b3);
            B b4 = new B("4", "b4", 1, aRef);
            this.getEntityManager().persist((Object)b4);
            this.getEntityManager().flush();
            A newA1 = b1.getA1Info();
            A newA2 = b2.getA1Info();
            A newA3 = b3.getA1Info();
            A newA4 = b4.getA1Info();
            if (newA1 != null && newA2 != null && newA3 != null && newA4 != null) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Wrong results received");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMX1Test2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMX1Test2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A aRef = new A("2", "bean2", 2);
            B b1 = new B("2", "b2", 2, aRef);
            this.getEntityManager().persist((Object)b1);
            this.getEntityManager().flush();
            A newA1 = b1.getA1Info();
            if (newA1 != null) {
                try {
                    TestUtil.logTrace((String)"Remove b1 ");
                    this.getEntityManager().remove((Object)newA1);
                    this.getEntityManager().remove((Object)b1);
                    this.getEntityManager().flush();
                    TestUtil.logTrace((String)"Persist a removed entity ");
                    B newB = this.findB("2");
                    if (null == newB) {
                        this.getEntityManager().persist((Object)b1);
                        this.getEntityManager().flush();
                        pass = this.getEntityManager().contains((Object)b1) && b1.getA1() != null;
                    } else {
                        TestUtil.logTrace((String)"entity B not removed");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)"Unexpected exception trying to persist a removed entity", (Throwable)ee);
                }
            } else {
                TestUtil.logTrace((String)"Instance is not already persisted. Test Fails.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMX1Test3() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMX1Test3");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A aRef = new A("4", "bean4", 4);
            this.getEntityManager().persist((Object)aRef);
            B b1 = new B("1", "b1", 4);
            this.getEntityManager().persist((Object)b1);
            B b2 = new B("2", "b2", 4);
            this.getEntityManager().persist((Object)b2);
            B b3 = new B("3", "b3", 4);
            this.getEntityManager().persist((Object)b3);
            B b4 = new B("4", "b4", 4);
            this.getEntityManager().persist((Object)b4);
            b1.setA1(aRef);
            b2.setA1(aRef);
            b3.setA1(aRef);
            b4.setA1(aRef);
            this.getEntityManager().flush();
            A newA1 = b1.getA1Info();
            A newA2 = b2.getA1Info();
            A newA3 = b3.getA1Info();
            A newA4 = b4.getA1Info();
            if (newA1 != null && this.getEntityManager().contains((Object)newA1) && newA2 != null && this.getEntityManager().contains((Object)newA2) && newA3 != null && this.getEntityManager().contains((Object)newA3) && newA4 != null && this.getEntityManager().contains((Object)newA4)) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            TestUtil.logErr((String)("Unexpected exception caught: " + e));
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMX1Test4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMX1Test4");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A aRef = new A("5", "bean5", 5);
            B b1 = new B("1", "b1", 5, aRef);
            this.getEntityManager().persist((Object)b1);
            B b2 = new B("2", "b2", 5, aRef);
            this.getEntityManager().persist((Object)b2);
            B b3 = new B("3", "b3", 5, aRef);
            this.getEntityManager().persist((Object)b3);
            B b4 = new B("4", "b4", 5, aRef);
            this.getEntityManager().persist((Object)b4);
            pass = this.getInstanceStatus(aRef);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test4 failed");
        }
    }

    public void cascadeAllMX1Test5() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A aRef = new A("6", "bean6", 6);
            B b1 = new B("1", "b1", 6, aRef);
            B b2 = new B("2", "b2", 6, aRef);
            B b3 = new B("3", "b3", 6, aRef);
            B b4 = new B("4", "b4", 6, aRef);
            pass = !this.getInstanceStatus(aRef) && !this.getInstanceStatus(b1) && !this.getInstanceStatus(b2) && !this.getInstanceStatus(b3) && !this.getInstanceStatus(b4);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test5 failed");
        }
    }

    public void cascadeAllMX1Test6() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("7", "b7", 7);
            B bRef = new B("7", "bean7", 7, a1);
            pass = !this.getEntityManager().contains((Object)bRef) && !this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMX1Test7() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("8", "a8", 8);
            B bRef = new B("8", "bean8", 8);
            this.getEntityManager().persist((Object)bRef);
            if (this.getEntityManager().contains((Object)bRef)) {
                B bRef1 = this.findB("8");
                bRef1.setA1(a1);
                this.getEntityManager().persist((Object)bRef1);
                pass = this.getEntityManager().contains((Object)a1);
                TestUtil.logTrace((String)"try to find A");
                A a2 = this.findA("8");
                if (null != a2) {
                    TestUtil.logTrace((String)"b2 is not null");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test7 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMX1Test8() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("9", "A9", 9);
            B bRef = new B("9", "bean9", 9);
            this.getEntityManager().persist((Object)bRef);
            if (null == bRef.getA1()) {
                bRef.setA1(a1);
                this.getEntityManager().flush();
            }
            if (null != a1 && this.getEntityManager().contains((Object)a1)) {
                A result = bRef.getA1Info();
                pass = true;
            } else {
                TestUtil.logErr((String)"Entity not managed - test fails.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMX1Test9() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"New instances");
            this.getEntityTransaction().begin();
            A a1 = new A("10", "a10", 10);
            B bRef = new B("10", "bean10", 10, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityManager().flush();
            pass = this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test9 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMX1Test10() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            A a1 = new A("11", "a11", 11);
            B bRef = new B("11", "bean11", 11, a1);
            this.getEntityManager().persist((Object)bRef);
            this.getEntityTransaction().commit();
            this.getEntityTransaction().begin();
            B b2 = this.findB("11");
            A newA = b2.getA1();
            newA.setAName("newA");
            this.getEntityManager().flush();
            if (b2.isA() && newA.getAName().equals("newA")) {
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMX1Test10 failed");
        }
    }

    private A findA(String id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        TestUtil.logTrace((String)"Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_MX1_UNI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

