/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxr.api.javax_xml_registry.RegistryService;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxr.common.JAXRCommonClient;
import java.util.Properties;
import javax.xml.registry.BulkResponse;
import javax.xml.registry.BusinessLifeCycleManager;
import javax.xml.registry.BusinessQueryManager;
import javax.xml.registry.CapabilityProfile;
import javax.xml.registry.DeclarativeQueryManager;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.UnsupportedCapabilityException;

public class JAXRClient
extends JAXRCommonClient {
    public static void main(String[] args) {
        JAXRClient theTests = new JAXRClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            super.setup(args, p);
            this.debug.clear();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("in cleanup");
            if (this.conn != null) {
                this.logTrace("Cleanup is closing the connection");
                this.conn.close();
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Cleanup error: " + e.toString()));
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.debug != null) {
                TestUtil.logTrace((String)this.debug.toString());
            }
        }
    }

    public void registryService_getCapabilityProfile() throws EETest.Fault {
        String testName = "registryService_getCapabilityProfile";
        boolean pass = true;
        String usage = "Testing get/set UsageDescription";
        try {
            CapabilityProfile cp = this.rs.getCapabilityProfile();
            if (!(cp instanceof CapabilityProfile)) {
                throw new EETest.Fault(testName + " RegistryService failed to return a CapabilityProfile");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void registryService_getBusinessLifeCycleManager() throws EETest.Fault {
        String testName = "registryService_getBusinessLifeCycleManager";
        boolean pass = true;
        String usage = "Testing get/set UsageDescription";
        try {
            BusinessLifeCycleManager blm = this.rs.getBusinessLifeCycleManager();
            if (!(blm instanceof BusinessLifeCycleManager)) {
                throw new EETest.Fault(testName + " RegistryService failed to return a BusinessLifeCycleManager ");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void registryService_getBusinessQueryManager() throws EETest.Fault {
        String testName = "registryService_getBusinessQueryManager";
        boolean pass = true;
        try {
            BusinessQueryManager bqm = this.rs.getBusinessQueryManager();
            if (!(bqm instanceof BusinessQueryManager)) {
                throw new EETest.Fault(testName + " RegistryService failed to return a BusinessQueryManager");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault(testName + "failed ");
        }
    }

    public void registryService_getDeclarativeQueryManager() throws EETest.Fault {
        String testName = "registryService_getDeclarativeQueryManager ";
        try {
            this.debug.add("Provider capablility level is :" + this.capabilityLevel + "\n");
            this.debug.add("getDeclarativeQueryManager is a level 1 method \n");
            this.debug.add("UnsupportedCapabilityException exception should be thrown for level 0 providers \n");
            DeclarativeQueryManager dqm = this.rs.getDeclarativeQueryManager();
            if (this.capabilityLevel == 0) {
                throw new EETest.Fault(testName + " failed - should have thrown  UnsupportedCapabilityException");
            }
            if (!(dqm instanceof DeclarativeQueryManager)) {
                throw new EETest.Fault(testName + " RegistryService failed to return a DeclarativeQueryManager");
            }
        }
        catch (UnsupportedCapabilityException uce) {
            this.debug.add("UnsupportedCapabilityException was thrown \n");
            if (this.capabilityLevel != 0) {
                throw new EETest.Fault(testName + " failed ", uce);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " FAIled - unexpected exception ");
        }
    }

    public void registryService_getBulkResponseInvalid() throws EETest.Fault {
        String testName = "registryService_getBulkResponseInvalid";
        String emptyString = "";
        try {
            this.debug.add("Pass an invalid requestid to getBulkResonse\n");
            this.debug.add("InvalidRequestException should be thrown \n");
            BulkResponse br = this.rs.getBulkResponse(emptyString);
            throw new EETest.Fault(testName + " failed - should have thrown  InvalidRequestException ");
        }
        catch (InvalidRequestException ir) {
            TestUtil.printStackTrace((Throwable)ir);
            this.debug.add("InvalidRequestException was thrown as expected");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault(testName + " failed - unexpected exception ");
        }
    }
}

