/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.samples.javamail.ee.transport;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.javamail.ee.common.MailTestUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class send_Test
extends ServiceEETest
implements Serializable {
    private String transport_protocol = null;
    private Session session;
    private String mailTo = null;

    public static void main(String[] args) {
        send_Test theTests = new send_Test();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            String protocol = TestUtil.getProperty((String)"javamail.protocol");
            String host = TestUtil.getProperty((String)"javamail.server");
            String user = TestUtil.getProperty((String)"javamail.username");
            String password = TestUtil.getProperty((String)"javamail.password");
            String mailbox = TestUtil.getProperty((String)"javamail.mailbox");
            String port = TestUtil.getProperty((String)"smtp.port");
            this.mailTo = TestUtil.getProperty((String)"mailuser1");
            if (this.mailTo.length() == 0) {
                throw new EETest.Fault("Invalid mailuser1 - the mail to property");
            }
            this.transport_protocol = TestUtil.getProperty((String)"transport_protocol");
            if (this.transport_protocol.length() == 0) {
                throw new EETest.Fault("Invalid transport_protocol");
            }
            MailTestUtil mailTestUtil = new MailTestUtil();
            this.session = mailTestUtil.createSession(host, port, user, password);
        }
        catch (Exception e) {
            this.logErr("Exception : " + e.getMessage());
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testSend() throws EETest.Fault {
        String msgText = "Testing Transport.send(Message msg).\nPASS.";
        try {
            MimeMessage msg = new MimeMessage(this.session);
            if (msg == null) {
                throw new EETest.Fault("WARNING: Failed to create a message object!");
            }
            InternetAddress addr = new InternetAddress(this.mailTo);
            InternetAddress[] addrs = new InternetAddress[]{addr};
            msg.setFrom((Address)addr);
            msg.setRecipients(Message.RecipientType.TO, (Address[])addrs);
            msg.setSubject("testSend()" + new Date());
            msg.setContent((Object)msgText, "text/plain");
            TestUtil.logTrace((String)"UNIT TEST 1: send(Message)");
            Transport.send((Message)msg);
            TestUtil.logTrace((String)"UNIT TEST 1: passed\n");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Call to testSend() Failed!", e);
        }
    }

    public void testconnect1() throws EETest.Fault {
        String msgText = "Testing connect().\nPASS.";
        try {
            Transport transport = this.session.getTransport(this.transport_protocol);
            if (transport == null) {
                throw new EETest.Fault("WARNING: Failed to create a transport object!");
            }
            MimeMessage msg = new MimeMessage(this.session);
            InternetAddress addr = new InternetAddress(this.mailTo);
            InternetAddress[] addrs = new InternetAddress[]{addr};
            msg.setFrom((Address)addr);
            msg.setRecipients(Message.RecipientType.TO, (Address[])addrs);
            msg.setSubject("testconnect1" + new Date());
            msg.setContent((Object)msgText, "text/plain");
            transport.connect();
            transport.sendMessage((Message)msg, (Address[])addrs);
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Call to testConnect1() Failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"Cleanup ;");
        }
        catch (Exception e) {
            this.logErr("An error occurred in cleanup!", e);
        }
    }
}

