/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefAndAddressingCombinedTest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefAndAddressingCombinedTest.Echo;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefAndAddressingCombinedTest.EchoService;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefAndAddressingCombinedTest.EjbClientIF;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.ejb.EJB;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.soap.Addressing;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    private String SERVLET = "/WSEjbWSRefAndAddressingCombinedTestClnt_web/ServletTest";
    @Addressing
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestdefaultechoport", type=Echo.class, value=EchoService.class)
    static Echo defaultEchoPort = null;
    @Addressing(enabled=true)
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestenabledechoport", type=Echo.class, value=EchoService.class)
    static Echo enabledEchoPort = null;
    @Addressing(enabled=true, required=true)
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestrequiredechoport", type=Echo.class, value=EchoService.class)
    static Echo requiredEchoPort = null;
    @Addressing(enabled=false)
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestdisabledechoport", type=Echo.class, value=EchoService.class)
    static Echo disabledEchoPort = null;
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestservice")
    static EchoService service = null;
    @EJB(name="ejb/WSEjbWSRefAndAddressingCombinedTestClntBean")
    static EjbClientIF ejbclient;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)("AppClient DEBUG: ejbclient=" + ejbclient));
            TestUtil.logMsg((String)("AppClient DEBUG: service=" + (Object)((Object)service)));
            TestUtil.logMsg((String)("AppClient DEBUG: defaultEchoPort=" + defaultEchoPort));
            TestUtil.logMsg((String)("AppClient DEBUG: enabledEchoPort=" + enabledEchoPort));
            TestUtil.logMsg((String)("AppClient DEBUG: requiredEchoPort=" + requiredEchoPort));
            TestUtil.logMsg((String)("AppClient DEBUG: disabledEchoPort=" + disabledEchoPort));
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (service == null || ejbclient == null || defaultEchoPort == null || enabledEchoPort == null || requiredEchoPort == null || disabledEchoPort == null) {
            throw new EETest.Fault("setup failed: injection failure");
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        ejbclient.init(p);
        TestUtil.logMsg((String)"setup ok");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }

    public void VerifyAddrHeadersExistForRequiredEchoPort() throws EETest.Fault {
        Object testName;
        boolean pass = true;
        TestUtil.logMsg((String)"VerifyAddrHeadersExistForRequiredEchoPort");
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test appclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"AppClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersExistForRequiredEchoPort");
            testName = new Holder((Object)"VerifyAddrHeadersExistForRequiredEchoPort");
            String result = requiredEchoPort.echo("Echo from AppClient on requiredEchoPort", (Holder<String>)testName);
            TestUtil.logMsg((String)"Addressing Headers Exist (Expected)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)"Test servletclient invocation .....");
            TestUtil.logMsg((String)"-----------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + this.url));
            this.props.setProperty("TEST", "VerifyAddrHeadersExistForRequiredEchoPort");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
            } else {
                TestUtil.logMsg((String)"Addressing Headers Exist (Expected)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test ejbclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            testName = "VerifyAddrHeadersExistForRequiredEchoPort";
            boolean passEjb = ejbclient.echo("Echo from EjbClient on requiredEchoPort", (String)testName);
            if (!passEjb) {
                TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Addressing Headers Exist (Expected)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Addressing Headers DO NOT Exist (Unexpected)");
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("VerifyAddrHeadersExistForRequiredEchoPort failed");
        }
    }

    public void VerifyAddrHeadersDoNotExistForDisabledEchoPort() throws EETest.Fault {
        Object testName;
        boolean pass = true;
        TestUtil.logMsg((String)"VerifyAddrHeadersDoNotExistForDisabledEchoPort");
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test appclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"AppClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST NOT be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersDoNotExistForDisabledEchoPort");
            testName = new Holder((Object)"VerifyAddrHeadersDoNotExistForDisabledEchoPort");
            String result = disabledEchoPort.echo("Echo from AppClient on disabledEchoPort", (Holder<String>)testName);
            TestUtil.logMsg((String)"Addressing Headers DO NOT Exist (Expected)");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Addressing Headers Exist (Unexpected)");
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)"Test servletclient invocation .....");
            TestUtil.logMsg((String)"-----------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + this.url));
            this.props.setProperty("TEST", "VerifyAddrHeadersDoNotExistForDisabledEchoPort");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                pass = false;
                TestUtil.logErr((String)"Addressing Headers Exist (Unexpected)");
            } else {
                TestUtil.logMsg((String)"Addressing Headers DO NOT Exist (Expected)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Addressing Headers Exist (Unexpected)");
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test ejbclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            testName = "VerifyAddrHeadersDoNotExistForDisabledEchoPort";
            boolean passEjb = ejbclient.echo("Echo from EjbClient on disabledEchoPort", (String)testName);
            if (!passEjb) {
                TestUtil.logErr((String)"Addressing Headers Exist (Unexpected)");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Addressing Headers DO NOT Exist (Expected)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Addressing Headers Exist (Unexpected)");
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("VerifyAddrHeadersDoNotExistForDisabledEchoPort failed");
        }
    }

    public void VerifyAddrHeadersMayExistForEnabledEchoPort() throws EETest.Fault {
        Object testName;
        boolean pass = true;
        TestUtil.logMsg((String)"VerifyAddrHeadersMayExistForEnabledEchoPort");
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test appclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"AppClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MAY be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersMayExistForEnabledEchoPort");
            testName = new Holder((Object)"VerifyAddrHeadersMayExistForEnabledEchoPort");
            String string = enabledEchoPort.echo("Echo from AppClient on enabledEchoPort", (Holder<String>)testName);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected exception: " + e.getMessage()));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-----------------------------------");
            TestUtil.logMsg((String)"Test servletclient invocation .....");
            TestUtil.logMsg((String)"-----------------------------------");
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, this.SERVLET);
            TestUtil.logMsg((String)("Servlet URL: " + this.url));
            this.props.setProperty("TEST", "VerifyAddrHeadersMayExistForEnabledEchoPort");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("fail")) {
                TestUtil.logErr((String)"Unexpected failure occurred");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected exception: " + e.getMessage()));
            pass = false;
        }
        try {
            TestUtil.logMsg((String)"-------------------------------");
            TestUtil.logMsg((String)"Test ejbclient invocation .....");
            TestUtil.logMsg((String)"-------------------------------");
            testName = "VerifyAddrHeadersMayExistForEnabledEchoPort";
            boolean passEjb = ejbclient.echo("Echo from EjbClient on enabledEchoPort", (String)testName);
            if (!passEjb) {
                TestUtil.logErr((String)"Unexpected failure occurred");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected exception: " + e.getMessage()));
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("VerifyAddrHeadersMayExistForEnabledEchoPort failed");
        }
    }
}

