/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.sharedclients;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;

public abstract class Client {
    private static final String DEFAULT_SCHEME = "http";
    private String webServerHost;
    private int webServerPort;
    private int mode;
    private TSURL ctsURL;

    public Client(String webServerHost, int webServerPort, int mode) throws EETest.Fault {
        this.webServerHost = webServerHost;
        this.webServerPort = webServerPort;
        this.mode = mode;
        this.ctsURL = new TSURL();
    }

    protected String getWebServerHost() {
        return this.webServerHost;
    }

    protected int getWebServerPort() {
        return this.webServerPort;
    }

    protected String getScheme() {
        return DEFAULT_SCHEME;
    }

    protected TSURL getCTSURL() {
        return this.ctsURL;
    }

    protected String getEndpointURLString() throws EETest.Fault {
        String file = null;
        try {
            file = JAXRPC_Util.getURLFromProp(this.getEndpointURLProperty());
        }
        catch (Exception e) {
            throw new EETest.Fault("Unable to obtain endpoint URL string", e);
        }
        String url = null;
        if (file != null) {
            url = this.ctsURL.getURLString(this.getScheme(), this.getWebServerHost(), this.getWebServerPort(), file);
            TestUtil.logMsg((String)("endpoint url=" + url));
        }
        return url;
    }

    protected String getWSDLURLString() throws EETest.Fault {
        String file = null;
        try {
            file = JAXRPC_Util.getURLFromProp(this.getWSDLURLProperty());
        }
        catch (Exception e) {
            throw new EETest.Fault("Unable to obtain wsdl URL string", e);
        }
        String url = null;
        if (file != null) {
            url = this.ctsURL.getURLString(this.getScheme(), this.getWebServerHost(), this.getWebServerPort(), file);
            TestUtil.logMsg((String)("wsdl url=" + url));
        }
        return url;
    }

    protected abstract String getEndpointURLProperty();

    protected abstract String getWSDLURLProperty();
}

