/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitycontexttest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSLoginContext;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOFactory;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitycontexttest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.bmp.entitycontexttest.TestBeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testName = "EntityContextTest";
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String testProps = "entitycontexttest.properties";
    private static final String testDir = System.getProperty("user.dir");
    private Properties props = null;
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private TSNamingContext nctx = null;
    private static final String user = "user";
    private static final String password = "password";
    private String user_value;
    private String password_value;
    private String role1_value = "Employee";
    private String role2_value = "Manager";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        this.user_value = this.props.getProperty(user);
        this.password_value = this.props.getProperty(password);
        this.logMsg("user_value=" + this.user_value);
        this.logMsg("password_value=" + this.password_value);
        this.logMsg("role1_value=" + this.role1_value);
        this.logMsg("role2_value=" + this.role2_value);
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Obtain login context and login as: " + this.user_value);
            TSLoginContext lc = new TSLoginContext();
            lc.login(this.user_value, this.password_value);
            this.logTrace("Client: Initializing BMP table...");
            DAOFactory.getInstance().getCoffeeDAO().cleanup();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            pass = this.beanRef.getEJBObjectTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            pass = this.beanRef.getEJBHomeTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void test3() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            pass = this.beanRef.getEnvironmentTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            pass = this.beanRef.getCallerPrincipalTest(this.user_value);
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            pass = this.beanRef.isCallerInRoleTest(this.role1_value);
        }
        catch (Exception e) {
            throw new EETest.Fault("test5 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    public void test5b() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            pass = this.beanRef.isCallerInRoleTest(this.role2_value);
        }
        catch (Exception e) {
            throw new EETest.Fault("test5b failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (pass) {
            throw new EETest.Fault("test5b failed");
        }
    }

    public void test6() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            pass = this.beanRef.setRollbackOnlyTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("test6 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test6 failed");
        }
    }

    public void test7() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            pass = this.beanRef.getRollbackOnlyTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("test7 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test7 failed");
        }
    }

    public void test8() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            this.logMsg("EntityBeans cannot obtain UserTransaction interface");
            pass = this.beanRef.getUserTransactionTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("test8 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test8 failed");
        }
    }

    public void test9() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            this.logMsg("Entity BMP bean can obtain primary key");
            pass = this.beanRef.getPrimaryKeyTest(new Integer(1));
        }
        catch (Exception e) {
            throw new EETest.Fault("test9 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test9 failed");
        }
    }

    public void test10() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(this.props, 1, "coffee-1", 1.0f);
            this.logMsg("Entity BMP Bean can obtain Timer Service");
            pass = this.beanRef.getTimerServiceTest();
        }
        catch (Exception e) {
            throw new EETest.Fault("test10 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test10 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

