/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.javamail.ee.fetchprofile;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.javamail.ee.common.MailTestUtil;
import java.io.Serializable;
import java.util.Properties;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Store;

public class fetchprofile_Test
extends ServiceEETest
implements Serializable {
    private transient FetchProfile fp = null;
    private int errors = 0;
    private Folder folder;
    private Message[] msgs;
    private Store store;
    private transient Status status;
    private String rootPath;
    private transient Session session;

    public static void main(String[] args) {
        fetchprofile_Test theTests = new fetchprofile_Test();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            String protocol = TestUtil.getProperty((String)"javamail.protocol");
            String host = TestUtil.getProperty((String)"javamail.server");
            String user = TestUtil.getProperty((String)"javamail.username");
            String password = TestUtil.getProperty((String)"javamail.password");
            String mailbox = TestUtil.getProperty((String)"javamail.mailbox");
            this.rootPath = TestUtil.getProperty((String)"javamail.root.path");
            String smtpPortStr = TestUtil.getProperty((String)"smtp.port");
            int smtpPort = Integer.parseInt(smtpPortStr);
            TestUtil.logTrace((String)("SMTP Port = " + smtpPort));
            String imapPortStr = TestUtil.getProperty((String)"imap.port");
            int imapPort = Integer.parseInt(imapPortStr);
            TestUtil.logTrace((String)("IMAP Port = " + imapPort));
            MailTestUtil mailTestUtil = new MailTestUtil();
            this.store = mailTestUtil.connect2host(protocol, host, imapPort, user, password);
            Folder root = this.getRootFolder(this.store);
            this.folder = root.getFolder(mailbox);
            if (this.folder == null) {
                throw new EETest.Fault("Invalid folder object!");
            }
            this.folder.open(1);
            this.fp = new FetchProfile();
            if (this.fp == null) {
                throw new EETest.Fault("Failed to create an empty FetchProfile object!");
            }
            this.msgs = this.folder.getMessages();
        }
        catch (Exception e) {
            this.logErr("Exception : " + e.getMessage());
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void test1() throws EETest.Fault {
        try {
            TestUtil.logTrace((String)"UNIT TEST 1:  FetchProfile()");
            FetchProfile fp = new FetchProfile();
            if (fp != null) {
                TestUtil.logTrace((String)"UNIT TEST 1: passed\n");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test1 Failed");
        }
    }

    public void test2() throws EETest.Fault {
        TestUtil.logTrace((String)"\nTesting class FetchProfile: add(FetchProfile.Item | String)\n");
        try {
            TestUtil.logTrace((String)"UNIT TEST 1: add(FetchProfile.Item.ENVELOPE)");
            this.fp.add(FetchProfile.Item.ENVELOPE);
            if (this.fp.contains(FetchProfile.Item.ENVELOPE)) {
                TestUtil.logTrace((String)"UNIT TEST 1: passed.\n");
            } else {
                TestUtil.logTrace((String)"UNIT TEST 1: FAILED.\n");
                ++this.errors;
            }
            TestUtil.logTrace((String)"UNIT TEST 2: add(FetchProfile.Item.FLAGS)");
            this.fp.add(FetchProfile.Item.FLAGS);
            if (this.fp.contains(FetchProfile.Item.FLAGS)) {
                TestUtil.logTrace((String)"UNIT TEST 2: passed.\n");
            } else {
                TestUtil.logTrace((String)"UNIT TEST 2: FAILED.\n");
                ++this.errors;
            }
            TestUtil.logTrace((String)"UNIT TEST 3: add(FetchProfile.Item.CONTENT_INFO)");
            this.fp.add(FetchProfile.Item.CONTENT_INFO);
            if (this.fp.contains(FetchProfile.Item.CONTENT_INFO)) {
                TestUtil.logTrace((String)"UNIT TEST 3: passed.\n");
            } else {
                TestUtil.logTrace((String)"UNIT TEST 3: FAILED.\n");
                ++this.errors;
            }
            TestUtil.logTrace((String)"UNIT TEST 4: add(Subject)");
            this.fp.add("Subject");
            if (this.fp.contains("Subject")) {
                TestUtil.logTrace((String)"UNIT TEST 4: passed.\n");
            } else {
                TestUtil.logTrace((String)"UNIT TEST 4: FAILED.\n");
                ++this.errors;
            }
            TestUtil.logTrace((String)"UNIT TEST 5: add(From)");
            this.fp.add("From");
            if (this.fp.contains("From")) {
                TestUtil.logTrace((String)"UNIT TEST 5: passed.\n");
            } else {
                TestUtil.logTrace((String)"UNIT TEST 5: FAILED.\n");
                ++this.errors;
            }
            TestUtil.logTrace((String)"UNIT TEST 6: add(X-mailer)");
            this.fp.add("X-mailer");
            if (this.fp.contains("X-mailer")) {
                TestUtil.logTrace((String)"UNIT TEST 6: passed.\n");
            } else {
                TestUtil.logTrace((String)"UNIT TEST 6: FAILED.\n");
                ++this.errors;
            }
            this.folder.fetch(this.msgs, this.fp);
            this.folder.close(false);
            this.store.close();
            this.checkStatus();
            if (this.errors > 0) {
                throw new EETest.Fault("test2 Failed: No of unit test failed = " + this.errors);
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("test2 Failed");
        }
    }

    public void getItems_test() throws EETest.Fault {
        try {
            FetchProfile fp = new FetchProfile();
            fp.add(FetchProfile.Item.ENVELOPE);
            fp.add(FetchProfile.Item.FLAGS);
            fp.add(FetchProfile.Item.CONTENT_INFO);
            fp.add(FetchProfile.Item.SIZE);
            TestUtil.logMsg((String)"UNIT TEST 1: getItems()");
            FetchProfile.Item[] items = fp.getItems();
            boolean foundEnv = false;
            boolean foundFlags = false;
            boolean foundCont = false;
            boolean foundSize = false;
            for (int j = 0; j < items.length; ++j) {
                if (items[j] == FetchProfile.Item.ENVELOPE) {
                    foundEnv = true;
                    continue;
                }
                if (items[j] == FetchProfile.Item.FLAGS) {
                    foundFlags = true;
                    continue;
                }
                if (items[j] == FetchProfile.Item.CONTENT_INFO) {
                    foundCont = true;
                    continue;
                }
                if (items[j] != FetchProfile.Item.SIZE) continue;
                foundSize = true;
            }
            if (foundEnv && foundFlags && foundCont && foundSize) {
                TestUtil.logMsg((String)"UNIT TEST 1: passed.\n");
            } else {
                TestUtil.logMsg((String)"UNIT TEST 1: FAILED.\n");
                ++this.errors;
            }
            this.checkStatus();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception " + e.getMessage());
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("getItems_test Failed");
        }
    }

    public void checkStatus() {
        this.status = this.errors == 0 ? Status.passed((String)"OKAY") : Status.failed((String)"");
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.logMsg("Cleanup ;");
        }
        catch (Exception e) {
            this.logErr("An error occurred in cleanup!", e);
        }
    }

    public Folder getRootFolder(Store store) {
        Folder folder = null;
        try {
            folder = this.rootPath.equals("") ? store.getDefaultFolder() : store.getFolder(this.rootPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return folder;
    }
}

