/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.topicMsgProperties;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.ConnectionMetaData;
import javax.jms.Message;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;
import javax.jms.TextMessage;

public class TopicPropertyTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.topicMsgProperties.TopicPropertyTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    public static void main(String[] args) {
        TopicPropertyTests theTests = new TopicPropertyTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            TestUtil.logMsg((String)"Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must be null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' in ts.jte must be null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                TestUtil.logMsg((String)"Cleanup: Closing TopicConnection");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"An error occurred while cleaning: ", (Throwable)e);
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void msgPropertiesTopicTest() throws EETest.Fault {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Enumeration propertyNames = null;
        Object jmsxDefined = null;
        int numPropertyNames = 18;
        String testMessageBody = "Testing...";
        try {
            short aShort;
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            messageSent.setByteProperty("TESTBYTE", bValue);
            messageSent.setShortProperty("TESTSHORT", nShort);
            messageSent.setIntProperty("TESTINT", nInt);
            messageSent.setFloatProperty("TESTFLOAT", nFloat);
            messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            messageSent.setStringProperty("TESTSTRING", "test");
            messageSent.setLongProperty("TESTLONG", nLong);
            messageSent.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
            messageSent.setObjectProperty("OBJTESTBYTE", (Object)bValue);
            messageSent.setObjectProperty("OBJTESTSHORT", (Object)nShort);
            messageSent.setObjectProperty("OBJTESTINT", (Object)nInt);
            messageSent.setObjectProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            messageSent.setObjectProperty("OBJTESTDOUBLE", (Object)nDouble);
            messageSent.setObjectProperty("OBJTESTSTRING", (Object)"test");
            messageSent.setObjectProperty("OBJTESTLONG", (Object)nLong);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesTopicTest");
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            try {
                messageSent.setObjectProperty("OBJTESTLONG", new Object());
                TestUtil.logMsg((String)"Error: expected MessageFormatException from invalid ");
                TestUtil.logMsg((String)"call to setObjectProperty did not occur!");
                pass = false;
            }
            catch (MessageFormatException fe) {
                TestUtil.logTrace((String)"Pass: ");
                TestUtil.logTrace((String)"      MessageFormatException as expected from invalid setObjectProperty call");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"from call to setObjectProperty!");
                pass = false;
            }
            try {
                messageReceived.setBooleanProperty("TESTBOOLEAN", bool);
                TestUtil.logMsg((String)"Error: exception should have occurred for setBooleanProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                TestUtil.logTrace((String)"Pass: exception as expected for setBooleanProperty ");
            }
            try {
                messageReceived.setByteProperty("TESTBYTE", bValue);
                TestUtil.logMsg((String)"Error: exception should have occurred for setByteProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                TestUtil.logTrace((String)"Pass: exception as expected for setByteProperty ");
            }
            try {
                messageReceived.setShortProperty("TESTSHORT", nShort);
                pass = false;
                TestUtil.logMsg((String)"Error: exception should have occurred for setShortProperty");
            }
            catch (MessageNotWriteableException aBool) {
                TestUtil.logTrace((String)"Pass: exception as expected for setShortProperty ");
            }
            try {
                messageReceived.setIntProperty("TESTINT", nInt);
                TestUtil.logMsg((String)"Error: exception should have occurred for setIntProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                TestUtil.logTrace((String)"Pass: exception as expected for setIntProperty ");
            }
            try {
                messageReceived.setFloatProperty("TESTFLOAT", nFloat);
                TestUtil.logMsg((String)"Error: exception should have occurred for setFloatProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                TestUtil.logTrace((String)"Pass: exception as expected for setFloatProperty ");
            }
            try {
                messageReceived.setDoubleProperty("TESTDOUBLE", nDouble);
                TestUtil.logMsg((String)"Error: exception should have occurred for setDoubleProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                TestUtil.logTrace((String)"Pass: exception as expected for setDoubleProperty ");
            }
            try {
                messageReceived.setStringProperty("TESTSTRING", testString);
                TestUtil.logMsg((String)"Error: exception should have occurred for setStringProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                TestUtil.logTrace((String)"Pass: exception as expected for setStringProperty ");
            }
            try {
                messageReceived.setLongProperty("TESTLONG", nLong);
                TestUtil.logMsg((String)"Error: exception should have occurred for setLongProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                TestUtil.logTrace((String)"Pass: exception as expected for setLongProperty ");
            }
            try {
                messageReceived.setObjectProperty("OBJTESTBOOLEAN", (Object)bool);
                TestUtil.logMsg((String)"Error: exception should have occurred for setObjectProperty");
                pass = false;
            }
            catch (MessageNotWriteableException aBool) {
                TestUtil.logTrace((String)"Pass: exception as expected for setObjectProperty ");
            }
            int i = 0;
            propertyNames = messageReceived.getPropertyNames();
            do {
                String tmp = (String)propertyNames.nextElement();
                TestUtil.logTrace((String)("+++++++   Property Name is: " + tmp));
                if (tmp.indexOf("JMS") != 0) {
                    ++i;
                    continue;
                }
                if (!tmp.equals("JMSXDeliveryCount")) continue;
                ++i;
            } while (propertyNames.hasMoreElements());
            if (i == numPropertyNames) {
                TestUtil.logTrace((String)("Pass: # of properties is " + numPropertyNames + " as expected"));
            } else {
                TestUtil.logMsg((String)("Error: expected " + numPropertyNames + " property names, but got " + i));
                pass = false;
            }
            if (messageReceived.getBooleanProperty("TESTBOOLEAN") == bool) {
                TestUtil.logTrace((String)"Pass: getBooleanProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTBYTE") == bValue) {
                TestUtil.logTrace((String)"Pass: getByteProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTLONG") == nLong) {
                TestUtil.logTrace((String)"Pass: getLongProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (messageReceived.getStringProperty("TESTSTRING").equals(testString)) {
                TestUtil.logTrace((String)"Pass: getStringProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTDOUBLE") == nDouble) {
                TestUtil.logTrace((String)"Pass: getDoubleProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTFLOAT") == nFloat) {
                TestUtil.logTrace((String)"Pass: getFloatProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTINT") == nInt) {
                TestUtil.logTrace((String)"Pass: getIntProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSHORT") == nShort) {
                TestUtil.logTrace((String)"Pass: getShortProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned from getShortProperty");
                pass = false;
            }
            try {
                boolean b = messageReceived.getBooleanProperty("TESTDUMMY");
                if (b) {
                    TestUtil.logMsg((String)"Error: should havereceived false for getBooleanProperty");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Unexpected Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                byte value = messageReceived.getByteProperty("TESTDUMMY");
                TestUtil.logMsg((String)"Error: NumberFormatException should have occurred for getByteProperty");
                pass = false;
            }
            catch (NumberFormatException e) {
                TestUtil.logTrace((String)"Pass: NumberFormatException as expected ");
            }
            try {
                short value = messageReceived.getShortProperty("TESTDUMMY");
                TestUtil.logMsg((String)"Error: NumberFormatException should have occurred for getShortProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                TestUtil.logTrace((String)"Pass: NumberFormatException as expected ");
            }
            try {
                int value = messageReceived.getIntProperty("TESTDUMMY");
                TestUtil.logMsg((String)"Error: NumberFormatException should have occurred for getIntProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                TestUtil.logTrace((String)"Pass:NumberFormatException as expected ");
            }
            try {
                long value = messageReceived.getLongProperty("TESTDUMMY");
                TestUtil.logMsg((String)"Error: NumberFormatException should have occurred for getLongProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                TestUtil.logTrace((String)"Pass: NumberFormatException as expected ");
            }
            try {
                float value = messageReceived.getFloatProperty("TESTDUMMY");
                TestUtil.logMsg((String)"Error: NullPointerException should have occurred for getFloatProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                TestUtil.logTrace((String)"Pass: NullPointerException as expected ");
            }
            try {
                double value = messageReceived.getDoubleProperty("TESTDUMMY");
                TestUtil.logMsg((String)"Error: NullPointerException should have occurred for getDoubleProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                TestUtil.logTrace((String)"Pass: NullPointerException as expected ");
            }
            String value = messageReceived.getStringProperty("TESTDUMMY");
            if (value == null) {
                TestUtil.logTrace((String)"Pass: getStringProperty returned correct value");
            } else {
                TestUtil.logMsg((String)"Error: expected a null return from getStringProperty for invalid property");
                pass = false;
            }
            Boolean aBool = (Boolean)messageReceived.getObjectProperty("TESTDUMMY");
            if (aBool == null) {
                TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Boolean");
            } else {
                TestUtil.logMsg((String)"Error: expected a null return from getObjectProperty for invalid property");
                pass = false;
            }
            Boolean boolValue = (Boolean)messageReceived.getObjectProperty("OBJTESTBOOLEAN");
            if (boolValue == bool) {
                TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Boolean");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned for Boolean");
                pass = false;
            }
            Byte byteValue = (Byte)messageReceived.getObjectProperty("OBJTESTBYTE");
            if (byteValue == bValue) {
                TestUtil.logTrace((String)"Pass: getObjectProperty returned correct Byte value");
            } else {
                TestUtil.logMsg((String)"Error: incorrect value returned from Byte");
                pass = false;
            }
            Long lValue = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
            if (lValue == nLong) {
                TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Long");
            } else {
                TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value returned for Long");
                pass = false;
            }
            if (messageReceived.getObjectProperty("OBJTESTSTRING").equals(testString)) {
                TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for String");
            } else {
                TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for String");
                pass = false;
            }
            Double dValue = (Double)messageReceived.getObjectProperty("OBJTESTDOUBLE");
            if (dValue == nDouble) {
                TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Double");
            } else {
                TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for Double");
                pass = false;
            }
            Float fValue = (Float)messageReceived.getObjectProperty("OBJTESTFLOAT");
            if (fValue.floatValue() == nFloat) {
                TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Float");
            } else {
                TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for Float");
                pass = false;
            }
            Integer iValue = (Integer)messageReceived.getObjectProperty("OBJTESTINT");
            if (iValue == nInt) {
                TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Integer");
            } else {
                TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for Integer");
                pass = false;
            }
            Short sValue = (Short)messageReceived.getObjectProperty("OBJTESTSHORT");
            if (sValue == nShort) {
                TestUtil.logTrace((String)"Pass: getObjectProperty returned correct value for Short");
            } else {
                TestUtil.logMsg((String)"Error: getObjectProperty returned incorrect value for Short");
                pass = false;
            }
            messageReceived.clearProperties();
            Long aLong = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
            if (aLong == null) {
                TestUtil.logTrace((String)"Pass: property was cleared");
            } else {
                TestUtil.logMsg((String)"Error: getObjectProperty should have returned null for cleared property");
                pass = false;
            }
            try {
                aShort = messageReceived.getShortProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: NumberFormatException should have occurred for getShortProperty");
                TestUtil.logMsg((String)"Properties have been cleared!");
                pass = false;
            }
            catch (NumberFormatException np) {
                TestUtil.logTrace((String)"Pass: NumberFormatException as expected ");
            }
            aLong = (Long)messageReceived.getObjectProperty("OBJTESTLONG");
            if (aLong == null) {
                TestUtil.logTrace((String)"Pass: property was cleared");
            } else {
                TestUtil.logMsg((String)"Error: getObjectProperty should have returned null for cleared property");
                pass = false;
            }
            try {
                aShort = messageReceived.getShortProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: NumberFormatException should have occurred for getShortProperty");
                TestUtil.logMsg((String)"Properties have been cleared!");
                pass = false;
            }
            catch (NumberFormatException np) {
                TestUtil.logTrace((String)"Pass: NumberFormatException as expected ");
            }
            TestUtil.logMsg((String)("Message body is : " + messageReceived.getText()));
            if (messageReceived.getText().equals(testMessageBody)) {
                TestUtil.logTrace((String)"Pass: able to read message body after clearProperties");
            } else {
                TestUtil.logMsg((String)"Error: unable to read message body after clearProperties");
                pass = false;
            }
            try {
                ConnectionMetaData data = this.tool.getDefaultTopicConnection().getMetaData();
                Enumeration cmd = data.getJMSXPropertyNames();
                if (cmd == null) {
                    TestUtil.logMsg((String)"Error: no JMSX property names were returned!");
                    TestUtil.logMsg((String)"expected JMSXGroupID, JMSXGroupSeq, JMSXDeliveryCount at a miniumum");
                    pass = false;
                } else {
                    int iCount = 0;
                    do {
                        String propName = (String)cmd.nextElement();
                        TestUtil.logTrace((String)propName);
                        if (!propName.equals("JMSXGroupID") && !propName.equals("JMSXGroupSeq") && !propName.equals("JMSXDeliveryCount")) continue;
                        ++iCount;
                    } while (cmd.hasMoreElements());
                    if (iCount > 1) {
                        TestUtil.logTrace((String)"Pass:");
                    } else {
                        TestUtil.logMsg((String)"Error: Expected property names not returned");
                        pass = false;
                    }
                }
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)ee);
                TestUtil.logErr((String)"attempting to read JMSX property names.");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during property tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgPropertiesTopicTest");
        }
    }

    public void msgPropertiesConversionTopicTest() throws EETest.Fault {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        String testMessageBody = "Testing...";
        boolean ntest = false;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setBooleanProperty("TESTBOOLEAN", bool);
            messageSent.setByteProperty("TESTBYTE", bValue);
            messageSent.setShortProperty("TESTSHORT", nShort);
            messageSent.setIntProperty("TESTINT", nInt);
            messageSent.setFloatProperty("TESTFLOAT", nFloat);
            messageSent.setDoubleProperty("TESTDOUBLE", nDouble);
            messageSent.setStringProperty("TESTSTRING", "test");
            messageSent.setLongProperty("TESTLONG", nLong);
            messageSent.setStringProperty("TESTSTRINGTRUE", "true");
            messageSent.setStringProperty("TESTSTRINGFALSE", "false");
            messageSent.setStringProperty("TESTSTRING1", "1");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesConversionTopicTest");
            TestUtil.logTrace((String)"Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            String myBool = messageReceived.getStringProperty("TESTBOOLEAN");
            if (Boolean.valueOf(myBool) == bool) {
                TestUtil.logTrace((String)"Pass: conversion from boolean to string - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from boolean to string failed");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- boolean to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- boolean to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException --boolean to int ");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- boolean to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- boolean to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBOOLEAN");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: boolean to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                TestUtil.logMsg((String)ee.getMessage());
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- boolean to double");
                pass = false;
            }
            String myByte = messageReceived.getStringProperty("TESTBYTE");
            if (Byte.valueOf(myByte) == bValue) {
                TestUtil.logTrace((String)"Pass: conversion from byte to string - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from byte to string failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTBYTE") == bValue) {
                TestUtil.logTrace((String)"Pass: conversion from byte to short - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from byte to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTBYTE") == bValue) {
                TestUtil.logTrace((String)"Pass: conversion from byte to int - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from byte to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTBYTE") == (long)bValue) {
                TestUtil.logTrace((String)"Pass: conversion from byte to long - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from byte to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTBYTE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: byte to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- byte to boolean");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTBYTE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: byte to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException --byte to float ");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTBYTE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: byte to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- byte to double");
                pass = false;
            }
            String myshort = messageReceived.getStringProperty("TESTSHORT");
            if (Short.valueOf(myshort) == nShort) {
                TestUtil.logTrace((String)"Pass: conversion from short to string - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from short to string failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSHORT") == nShort) {
                TestUtil.logTrace((String)"Pass: conversion from short to int - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from short to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSHORT") == (long)nShort) {
                TestUtil.logTrace((String)"Pass: conversion from short to long - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from short to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: short to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- short to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: short to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- short to byte");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: short to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- short to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTSHORT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: short to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- short to double");
                pass = false;
            }
            if (Integer.valueOf(messageReceived.getStringProperty("TESTINT")) == nInt) {
                TestUtil.logTrace((String)"Pass: conversion from int to string - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from int to string failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTINT") == (long)nInt) {
                TestUtil.logTrace((String)"Pass: conversion from int to long - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from int to long failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- int to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException --  int to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected -- int to short ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException ");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- int to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTINT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: int to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- int to double");
                pass = false;
            }
            if (Long.valueOf(messageReceived.getStringProperty("TESTLONG")) == nLong) {
                TestUtil.logTrace((String)"Pass: conversion from long to string - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from long to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- long to boolean");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- long to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- long to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- long to int");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- long to float");
                pass = false;
            }
            try {
                messageReceived.getDoubleProperty("TESTLONG");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: long to double ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected Exception -- long to double");
                pass = false;
            }
            if (Float.valueOf(messageReceived.getStringProperty("TESTFLOAT")).floatValue() == nFloat) {
                TestUtil.logTrace((String)"Pass: conversion from float to string - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from float to string failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTFLOAT") == (double)nFloat) {
                TestUtil.logTrace((String)"Pass: conversion from long to double - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from long to double failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- float to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- float to byte");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException - float to short ");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException --- float to int");
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTFLOAT");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: float to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException --  float to long");
                pass = false;
            }
            if (Double.valueOf(messageReceived.getStringProperty("TESTDOUBLE")) == nDouble) {
                TestUtil.logTrace((String)"Pass: conversion from double to string - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from double to string failed");
                pass = false;
            }
            try {
                messageReceived.getBooleanProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to boolean ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- double to boolean ");
                pass = false;
            }
            try {
                messageReceived.getByteProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to byte ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- double to byte ");
                pass = false;
            }
            try {
                messageReceived.getShortProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to short ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- double to short");
                pass = false;
            }
            try {
                messageReceived.getIntProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to int ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException --- double to int ");
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                pass = false;
            }
            try {
                messageReceived.getLongProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to long ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- double to long");
                pass = false;
            }
            try {
                messageReceived.getFloatProperty("TESTDOUBLE");
                TestUtil.logMsg((String)"Error: MessageFormatException should have occurred for type conversion error");
                TestUtil.logMsg((String)"unsupported conversion: double to float ");
                pass = false;
            }
            catch (MessageFormatException me) {
                TestUtil.logTrace((String)"Pass: MessageFormatException as expected ");
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected error ", (Throwable)ee);
                TestUtil.logErr((String)"Error: did not catch expected MessageFormatException -- double to float");
                pass = false;
            }
            if (messageReceived.getBooleanProperty("TESTSTRINGTRUE")) {
                TestUtil.logTrace((String)"Pass: conversion from string to boolean - expect true - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from string to boolean - expect true  - failed");
                pass = false;
            }
            if (!messageReceived.getBooleanProperty("TESTSTRINGFALSE")) {
                TestUtil.logTrace((String)"Pass: conversion from string to boolean expect false - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from string to boolean expect false - failed");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTSTRING1") == 1) {
                TestUtil.logTrace((String)"Pass: conversion from string to byte - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from string to byte failed");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSTRING1") == 1) {
                TestUtil.logTrace((String)"Pass: conversion from string to short - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from string to short failed");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTSTRING1") == 1) {
                TestUtil.logTrace((String)"Pass: conversion from string to int - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from string to int failed");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTSTRING1") == 1L) {
                TestUtil.logTrace((String)"Pass: conversion from string to long - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from string to long failed");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTSTRING1") == 1.0f) {
                TestUtil.logTrace((String)"Pass: conversion from string to float - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from string to float failed");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTSTRING1") == 1.0) {
                TestUtil.logTrace((String)"Pass: conversion from string to double - ok");
            } else {
                TestUtil.logErr((String)"Error: conversion from string to double failed");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during property conversion tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgPropertiesConversionTopicTest");
        }
    }

    public void msgJMSXPropertiesTopicTest() throws EETest.Fault {
        boolean pass = true;
        String testMessageBody = "Testing msgJMSXProperties";
        int seq = 123450;
        String id = "TestmsgJMSXProperties";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            TestUtil.logTrace((String)"Creating 1 message");
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setStringProperty("JMSXGroupID", id);
            messageSent.setIntProperty("JMSXGroupSeq", seq);
            this.tool.getDefaultProducer().send((Message)messageSent);
            TestUtil.logTrace((String)"Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            try {
                ConnectionMetaData data = this.tool.getDefaultConnection().getMetaData();
                Enumeration cmd = data.getJMSXPropertyNames();
                if (cmd == null) {
                    this.logErr("Error: no JMSX property names were returned!");
                    pass = false;
                } else {
                    int iCount = 0;
                    do {
                        String propName = (String)cmd.nextElement();
                        TestUtil.logTrace((String)propName);
                        if (!propName.equals("JMSXGroupID") && !propName.equals("JMSXGroupSeq")) continue;
                        ++iCount;
                    } while (cmd.hasMoreElements());
                    if (iCount > 1) {
                        TestUtil.logTrace((String)"Pass:");
                    } else {
                        TestUtil.logMsg((String)"Error: Expected property names not returned");
                        pass = false;
                    }
                }
            }
            catch (Exception ee) {
                TestUtil.logErr((String)"Error: unexpected exception: ", (Throwable)ee);
                TestUtil.logErr((String)"attempting to read JMSX property names.");
                pass = false;
            }
            if (messageReceived.getIntProperty("JMSXGroupSeq") != seq) {
                pass = false;
                this.logErr("Error: incorrect JMSXGroupSeq value returned");
            }
            if (!messageReceived.getStringProperty("JMSXGroupID").equals(id)) {
                pass = false;
                this.logErr("Error: incorrect JMSXGroupID value returned");
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during property tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("msgJMSXPropertiesTopicTest");
        }
    }
}

