/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.ADVC;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.BDVC;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.Bean;
import com.sun.ts.tests.ejb.ee.pm.oneXone.bi.btob.BeanHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String bean = "java:comp/env/ejb/Bean";
    private Bean bRef = null;
    private BeanHome bHome = null;
    private TSNamingContext nctx = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/Bean");
            this.bHome = (BeanHome)this.nctx.lookup(bean, BeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void btob_1x1_bi_test0() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create Entity Bean");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b1 = new BDVC("1", "b1", 1);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b1, 0);
            this.bRef.init(this.props);
            if (this.bRef.test0()) {
                TestUtil.logMsg((String)"relationship fields are null - expected");
            } else {
                TestUtil.logErr((String)"relationship fields are nonnull - unexpected");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1x1_bi_test0 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1x1_bi_test0 failed");
        }
    }

    public void btob_1x1_bi_test1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create Entity Bean");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b1 = new BDVC("1", "b1", 1);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b1, 1);
            this.bRef.init(this.props);
            if (this.bRef.test1()) {
                TestUtil.logMsg((String)"relationship fields are null - expected");
            } else {
                TestUtil.logErr((String)"relationship fields are nonnull - unexpected");
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1x1_bi_test1 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1x1_bi_test1 failed");
        }
    }

    public void btob_1x1_bi_test2() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create Entity Bean");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b1 = new BDVC("1", "b1", 1);
            ADVC a2 = new ADVC("2", "a2", 2);
            BDVC b2 = new BDVC("2", "b2", 2);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b1, a2, b2);
            this.bRef.init(this.props);
            pass = this.bRef.test2();
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1x1_bi_test2 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1x1_bi_test2 failed");
        }
    }

    public void btob_1x1_bi_test3() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create Entity Bean");
            ADVC a1 = new ADVC("1", "a1", 1);
            BDVC b1 = new BDVC("1", "b1", 1);
            this.bRef = this.bHome.create("1", "bean1", 1, a1, b1, 2);
            this.bRef.init(this.props);
            BDVC b = this.bRef.getBInfoFromA();
            String bId = b.getId();
            String bName = b.getName();
            ADVC a = this.bRef.getAInfoFromB();
            String aId = a.getId();
            String aName = a.getName();
            this.logMsg("bId=" + bId + ", bName=" + bName + ", aId=" + aId + ", aName=" + aName);
            if (!(bId.equals("1") && bName.equals("b1") && aId.equals("1") && aName.equals("a1"))) {
                pass = false;
                this.logErr("DataMismatch error");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("btob_1x1_bi_test3 failed", e);
        }
        finally {
            try {
                if (this.bRef != null) {
                    this.bRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("btob_1x1_bi_test3 failed");
        }
    }
}

