/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.assembly.util.shared.resref.single;

import com.sun.ts.lib.util.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

class ByteArrayDataSource
implements DataSource {
    private byte[] data;
    private String type;

    ByteArrayDataSource(InputStream is, String type) {
        this.type = type;
        try {
            int ch;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            this.data = os.toByteArray();
        }
        catch (IOException ioex) {
            TestUtil.printStackTrace((Throwable)ioex);
        }
    }

    ByteArrayDataSource(byte[] data, String type) {
        this.data = data;
        this.type = type;
    }

    ByteArrayDataSource(String data, String type) {
        try {
            this.data = data.getBytes("iso-8859-1");
        }
        catch (UnsupportedEncodingException uex) {
            TestUtil.printStackTrace((Throwable)uex);
        }
        this.type = type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.data == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("cannot do this");
    }

    public String getContentType() {
        return this.type;
    }

    public String getName() {
        return "dummy";
    }
}

