/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;

public class JobOperatorTests
extends ServiceEETest {
    private static final Logger logger = Logger.getLogger(JobOperatorTests.class.getName());
    private static JobOperatorBridge jobOp;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void cleanup() {
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public static void tearDown() throws EETest.Fault {
    }

    private void begin(String str) {
        TestUtil.logMsg((String)("Begin test method: " + str));
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }

    public void testJobOperatorStart() throws EETest.Fault {
        String METHOD = "testJobOperatorStart";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_1step.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_1step");
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorRestart() throws EETest.Fault {
        String METHOD = "testJobOperatorRestart";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.next.writepoints=10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper exec = null;
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult for execution id: " + lastExecutionId + ""));
            exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus()));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus()));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + exec.getInstanceId()));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorRestartAlreadyCompleteException() throws EETest.Fault {
        String METHOD = "testJobOperatorRestartAlreadyCompleteException";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.next.writepoints=10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long firstExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper exec = null;
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + firstExecutionId + ""));
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult for execution id: " + firstExecutionId + ""));
            exec = jobOp.restartJobAndWaitForResult(firstExecutionId, jobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus()));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus()));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + exec.getInstanceId()));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
            long secondExecutionId = exec.getExecutionId();
            TestUtil.logMsg((String)("execution #2 Job execution id=" + secondExecutionId));
            TestUtil.logMsg((String)("Now invoke restart again, expecting JobExecutionAlreadyCompleteException, for execution id: " + secondExecutionId + ""));
            boolean seenException = false;
            try {
                jobOp.restartJobAndWaitForResult(secondExecutionId, jobParams);
            }
            catch (JobExecutionAlreadyCompleteException e) {
                TestUtil.logMsg((String)"Caught JobExecutionAlreadyCompleteException as expected");
                seenException = true;
            }
            AssertionUtils.assertWithMessage("Caught JobExecutionAlreadyCompleteException for bad restart #2", seenException);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorAbandonJobDuringARestart() throws EETest.Fault {
        String METHOD = "testJobOperatorRestartAlreadyCompleteException";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "5000";
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            TestUtil.logMsg((String)"execution.number=1");
            String sleepTime = System.getProperty("JobOperatorTests.testJobOperatorTestAbandonActiveRestart.sleep", DEFAULT_SLEEP_TIME);
            jobParams.put("sleep.time", sleepTime);
            TestUtil.logMsg((String)("sleep.time=" + sleepTime + ""));
            TestUtil.logMsg((String)"Locate job XML file: abandonActiveRestart.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("abandonActiveRestart", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long firstExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper exec = null;
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + firstExecutionId + ""));
            jobParams = new Properties();
            jobParams.put("execution.number", "2");
            TestUtil.logMsg((String)"execution.number=2");
            sleepTime = System.getProperty("JobOperatorTests.testJobOperatorTestAbandonActiveRestart.sleep", DEFAULT_SLEEP_TIME);
            jobParams.put("sleep.time", sleepTime);
            TestUtil.logMsg((String)("sleep.time=" + sleepTime + ""));
            TestUtil.logMsg((String)("Invoke restartJobWithoutWaitingForResult for execution id: " + firstExecutionId + ""));
            exec = jobOp.restartJobWithoutWaitingForResult(firstExecutionId, jobParams);
            long secondExecutionId = exec.getExecutionId();
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult for execution id: " + firstExecutionId + ""));
            boolean seen = false;
            try {
                jobOp.abandonJobExecution(secondExecutionId);
            }
            catch (JobExecutionIsRunningException jobRunningEx) {
                TestUtil.logMsg((String)"Caught JobExecutionIsRunningException as expected");
                seen = true;
            }
            AssertionUtils.assertWithMessage("Caught JobExecutionIsRunningException for abandon attempt during restart", seen);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorRestartJobAlreadyAbandoned() throws EETest.Fault {
        String METHOD = "testJobOperatorRestartAlreadyCompleteException";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "1";
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            TestUtil.logMsg((String)"execution.number=1");
            String sleepTime = System.getProperty("JobOperatorTests.testJobOperatorTestRestartAlreadAbandonedJob.sleep", DEFAULT_SLEEP_TIME);
            jobParams.put("sleep.time", sleepTime);
            TestUtil.logMsg((String)("sleep.time=" + sleepTime + ""));
            TestUtil.logMsg((String)"Locate job XML file: abandonActiveRestart.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("abandonActiveRestart", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long firstExecutionId = execution1.getExecutionId();
            jobOp.abandonJobExecution(firstExecutionId);
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + firstExecutionId + ""));
            jobParams = new Properties();
            jobParams.put("execution.number", "2");
            TestUtil.logMsg((String)"execution.number=2");
            TestUtil.logMsg((String)("Invoke restartJobWithoutWaitingForResult for execution id: " + firstExecutionId + ""));
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult for execution id: " + firstExecutionId + ""));
            boolean seen = false;
            try {
                jobOp.restartJobWithoutWaitingForResult(firstExecutionId, jobParams);
            }
            catch (JobRestartException jobRestartEx) {
                TestUtil.logMsg((String)"Caught JobRestartException as expected");
                seen = true;
            }
            AssertionUtils.assertWithMessage("Caught JobRestartException for abandon attempt during restart", seen);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testInvokeJobWithUserStop() throws EETest.Fault {
        String METHOD = "testInvokeJobWithUserStop";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "1000";
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_longrunning.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParameters = new Properties();
            TestUtil.logMsg((String)"run.indefinitely=true");
            jobParameters.setProperty("run.indefinitely", "true");
            TestUtil.logMsg((String)"Invoking startJobWithoutWaitingForResult for Execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobWithoutWaitingForResult("job_batchlet_longrunning", jobParameters);
            int sleepTime = Integer.parseInt(System.getProperty("JobOperatorTests.testInvokeJobWithUserStop.sleep", "1000"));
            TestUtil.logMsg((String)("Thread.sleep(" + sleepTime + ")"));
            Thread.sleep(sleepTime);
            TestUtil.logMsg((String)"Invoking stopJobAndWaitForResult for Execution #1");
            jobOp.stopJobAndWaitForResult(jobExec);
            JobExecution jobExec2 = jobOp.getJobExecution(jobExec.getExecutionId());
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec2.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.STOPPED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorGetStepExecutions() throws EETest.Fault {
        String METHOD = "testJobOperatorGetStepExecutions";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_1step.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_1step");
            TestUtil.logMsg((String)("Obtaining StepExecutions for execution id: " + jobExec.getExecutionId() + ""));
            List<StepExecution> stepExecutions = jobOp.getStepExecutions(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(1, stepExecutions.size());
            for (StepExecution step : stepExecutions) {
                this.showStepState(step);
                TestUtil.logMsg((String)("Step status=" + step.getBatchStatus()));
                AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, step.getBatchStatus());
            }
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + jobExec.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOpGetJobNames() throws EETest.Fault {
        String METHOD = "testJobOpGetJobNames";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String jobName = "job_unique_get_job_names";
        try {
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            List<String> jobNames = jobOp.getJobNames();
            jobOp.startJobWithoutWaitingForResult("job_unique_get_job_names");
            if (jobNames.contains(jobName)) {
                TestUtil.logMsg((String)("JobOperator.getJobNames() already includes " + jobName + ", test is not so useful"));
            } else {
                TestUtil.logMsg((String)("JobOperator.getJobNames() does not include " + jobName + " yet."));
            }
            jobNames = jobOp.getJobNames();
            AssertionUtils.assertWithMessage("Now JobOperator.getJobNames() definitely includes " + jobName, jobNames.contains(jobName));
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testAbandoned() throws EETest.Fault {
        String METHOD = "testAbandoned";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_batchlet_4steps.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper jobExec = jobOp.startJobAndWaitForResult("job_batchlet_4steps");
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExec.getBatchStatus());
            jobOp.abandonJobExecution(jobExec.getExecutionId());
            JobExecution jobExec2 = jobOp.getJobExecution(jobExec.getExecutionId());
            AssertionUtils.assertObjEquals(BatchStatus.ABANDONED, jobExec2.getBatchStatus());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOpgetJobInstanceCount() throws EETest.Fault {
        String METHOD = "testJobOpgetJobInstanceCount";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            int countTrackerBEFORE = 0;
            try {
                countTrackerBEFORE = jobOp.getJobInstanceCount("chunksize5commitinterval5");
            }
            catch (NoSuchJobException noSuchJobException) {
                // empty catch block
            }
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.faile=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            int countTrackerAFTER = jobOp.getJobInstanceCount("chunksize5commitinterval5");
            AssertionUtils.assertWithMessage("job count for job1 increased by 1", 1, countTrackerAFTER - countTrackerBEFORE);
            List<String> jobNames = jobOp.getJobNames();
            for (String jobname : jobNames) {
                TestUtil.logMsg((String)(jobname + " instance count : " + jobOp.getJobInstanceCount(jobname) + " - "));
            }
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOpgetJobInstanceCountException() throws EETest.Fault {
        String METHOD = "testJobOpgetJobInstanceCountException";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            int countTrackerBEFORE = 0;
            try {
                countTrackerBEFORE = jobOp.getJobInstanceCount("ChunkStopOnEndOn");
            }
            catch (NoSuchJobException noSuchJobException) {
                // empty catch block
            }
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.faile=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            boolean seenException = false;
            try {
                int n = jobOp.getJobInstanceCount("NoSuchJob");
            }
            catch (NoSuchJobException noJobEx) {
                TestUtil.logMsg((String)"Confirmed we caught NoSuchJobException");
                seenException = true;
            }
            AssertionUtils.assertWithMessage("Saw NoSuchJobException for job 'NoSuchJob'", seenException);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOpgetJobInstances() throws EETest.Fault {
        String METHOD = " testJobOpgetJobInstances";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        int submitTimes = 10;
        try {
            int countTrackerBEFORE = 0;
            int countTrackerAFTER = 0;
            try {
                countTrackerBEFORE = jobOp.getJobInstanceCount("chunksize5commitinterval5");
                TestUtil.logMsg((String)("Before test ran the JobInstance count for chunksize5commitinterval5 was " + countTrackerBEFORE));
            }
            catch (NoSuchJobException e) {
                TestUtil.logMsg((String)"Not an error, but just the first time executing this job ");
            }
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.faile=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            for (int i = 0; i < submitTimes; ++i) {
                jobOp.startJobWithoutWaitingForResult("chunksize5commitinterval5", jobParams);
            }
            List<JobInstance> jobInstances = null;
            try {
                jobInstances = jobOp.getJobInstances("chunksize5commitinterval5", 0, 10);
                countTrackerAFTER = jobOp.getJobInstanceCount("chunksize5commitinterval5");
                AssertionUtils.assertWithMessage("Check that we see: " + submitTimes + " new submissions", submitTimes, countTrackerAFTER - countTrackerBEFORE);
            }
            catch (NoSuchJobException noJobEx) {
                TestUtil.logMsg((String)"Failing test, caught NoSuchJobException");
                throw noJobEx;
            }
            TestUtil.logMsg((String)("Size of Job Instances list = " + jobInstances.size() + ""));
            AssertionUtils.assertWithMessage("Testing that a list of Job Instances were obtained", 10, jobInstances.size());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOpgetJobInstancesException() throws EETest.Fault {
        String METHOD = "testJobOpgetJobInstancesException";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.faile=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Locate job XML file: /chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            List<JobInstance> jobIds = null;
            boolean seenException = false;
            try {
                jobIds = jobOp.getJobInstances("NoSuchJob", 0, 12);
            }
            catch (NoSuchJobException noJobEx) {
                seenException = true;
                TestUtil.logMsg((String)"Confirmed we caught NoSuchJobException");
            }
            AssertionUtils.assertWithMessage("Saw NoSuchJobException for job 'NoSuchJob'", seenException);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorGetParameters() throws EETest.Fault {
        String METHOD = "testJobOperatorGetParameters";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties originalJobParams = new Properties();
            Properties restartJobParams = null;
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.next.writepoints=10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            originalJobParams.put("execution.number", "1");
            originalJobParams.put("readrecord.fail", "12");
            originalJobParams.put("app.arraysize", "30");
            originalJobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            originalJobParams.put("app.next.writepoints", "10,15,20,25,30");
            originalJobParams.put("app.commitinterval", "5");
            String N1 = "extra.parm.name1";
            String V1 = "extra.parm.value1";
            String N2 = "extra.parm.name2";
            String V2 = "extra.parm.value2";
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", originalJobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper execution2 = null;
            TestUtil.logMsg((String)("Got Job instance id: " + jobInstanceId + ""));
            TestUtil.logMsg((String)("Got Job execution id: " + lastExecutionId + ""));
            TestUtil.logMsg((String)"Invoke clone original job execution parameters");
            restartJobParams = (Properties)originalJobParams.clone();
            TestUtil.logMsg((String)"Put some extra parms in the restart execution");
            restartJobParams.put(N1, V1);
            restartJobParams.put(N2, V2);
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult for execution id: " + lastExecutionId + ""));
            execution2 = jobOp.restartJobAndWaitForResult(lastExecutionId, restartJobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus()));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus()));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + execution2.getInstanceId()));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", execution2.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, execution2.getInstanceId());
            Properties jobParamsFromJobOperator = jobOp.getParameters(execution1.getExecutionId());
            Properties jobParamsFromJobExecution = execution1.getJobParameters();
            AssertionUtils.assertWithMessage("Comparing original job params with jobOperator.getParameters", originalJobParams, jobParamsFromJobOperator);
            TestUtil.logMsg((String)"JobOperator.getParameters() matches for original execution ");
            AssertionUtils.assertWithMessage("Comparing original job params with jobExecution.getParameters", originalJobParams, jobParamsFromJobExecution);
            TestUtil.logMsg((String)"JobExecution.getParameters() matches for original execution ");
            Properties restartJobParamsFromJobOperator = jobOp.getParameters(execution2.getExecutionId());
            Properties restartJobParamsFromJobExecution = execution2.getJobParameters();
            AssertionUtils.assertWithMessage("Comparing restart job params with jobOperator.getParameters", restartJobParams, restartJobParamsFromJobOperator);
            TestUtil.logMsg((String)"JobOperator.getParameters() matches for restart execution ");
            AssertionUtils.assertWithMessage("Comparing restart job params with jobExecution.getParameters", restartJobParams, restartJobParamsFromJobExecution);
            TestUtil.logMsg((String)"JobExecution.getParameters() matches for restart execution ");
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorGetJobInstances() throws EETest.Fault {
        String METHOD = "testJobOperatorGetJobInstances";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=31");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "COMPLETED", execution1.getExitStatus());
            TestUtil.logMsg((String)"Create job parameters for execution #2:");
            jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=2");
            TestUtil.logMsg((String)"readrecord.fail=31");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "31");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #2");
            TCKJobExecutionWrapper execution2 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", execution2.getExitStatus());
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #3");
            TCKJobExecutionWrapper execution3 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #3 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #3 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #3", BatchStatus.COMPLETED, execution3.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #3", "COMPLETED", execution3.getExitStatus());
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #4");
            TCKJobExecutionWrapper execution4 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #4 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #4 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #4", BatchStatus.COMPLETED, execution4.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #4", "COMPLETED", execution4.getExitStatus());
            List<JobInstance> jobInstances012 = jobOp.getJobInstances("chunksize5commitinterval5", 0, 3);
            List<JobInstance> jobInstances123 = jobOp.getJobInstances("chunksize5commitinterval5", 1, 3);
            for (int i = 0; i < 3; ++i) {
                logger.fine("AJM: instance id012[" + i + "] = " + jobInstances012.get(i).getInstanceId());
                logger.fine("AJM: instance id123[" + i + "] = " + jobInstances123.get(i).getInstanceId());
            }
            AssertionUtils.assertWithMessage("job instances should not be equal", jobInstances012.get(0).getInstanceId() != jobInstances123.get(0).getInstanceId());
            AssertionUtils.assertWithMessage("job instances should be equal", jobInstances012.get(1).getInstanceId() == jobInstances123.get(0).getInstanceId());
            AssertionUtils.assertWithMessage("job instances should be equal", jobInstances012.get(2).getInstanceId() == jobInstances123.get(1).getInstanceId());
            AssertionUtils.assertWithMessage("job instances should not be equal", jobInstances012.get(2).getInstanceId() != jobInstances123.get(2).getInstanceId());
            TestUtil.logMsg((String)("Size of jobInstancesList = " + jobInstances012.size() + ""));
            TestUtil.logMsg((String)("Testing retrieval of the JobInstances list, size = " + jobInstances012.size() + ""));
            AssertionUtils.assertWithMessage("Testing retrieval of the JobInstances list", jobInstances012.size() > 0);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorGetRunningJobExecutions() throws EETest.Fault {
        String METHOD = "testJobOperatorGetRunningJobExecutions";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_SLEEP_TIME = "1000";
        String DEFAULT_APP_TIME_INTERVAL = "10000";
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            String timeinterval = System.getProperty("JobOperatorTests.testJobOperatorGetRunningJobExecutions.app.timeinterval", "10000");
            jobParams.put("app.timeinterval", timeinterval);
            TestUtil.logMsg((String)"Invoke startJobWithoutWaitingForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobWithoutWaitingForResult("job_batchlet_step_listener", jobParams);
            Properties newJobParameters = new Properties();
            newJobParameters.put("app.timeinterval", timeinterval);
            TestUtil.logMsg((String)"Invoke startJobWithoutWaitingForResult");
            TCKJobExecutionWrapper exec = jobOp.startJobWithoutWaitingForResult("job_batchlet_step_listener", newJobParameters);
            int sleepTime = Integer.parseInt(System.getProperty("ExecutionTests.testJobOperatorGetRunningJobExecutions.sleep", "1000"));
            TestUtil.logMsg((String)("Thread.sleep(" + sleepTime + ")"));
            Thread.sleep(sleepTime);
            List<Long> jobExecutions = jobOp.getRunningExecutions("job_batchlet_step_listener");
            AssertionUtils.assertWithMessage("Found job instances in the RUNNING state", jobExecutions.size() > 0);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorGetRunningJobInstancesException() throws EETest.Fault {
        String METHOD = "testJobOperatorGetRunningJobInstancesException";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String DEFAULT_APP_TIME_INTERVAL = "10000";
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            String timeinterval = System.getProperty("JobOperatorTests.testJobOperatorGetRunningJobInstancesException.app.timeinterval", "10000");
            jobParams.put("app.timeinterval", timeinterval);
            TestUtil.logMsg((String)"Invoke startJobWithoutWaitingForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobWithoutWaitingForResult("job_batchlet_step_listener", jobParams);
            Properties restartJobParameters = new Properties();
            restartJobParameters.put("app.timeinterval", timeinterval);
            TestUtil.logMsg((String)"Invoke startJobWithoutWaitingForResult");
            TCKJobExecutionWrapper exec = jobOp.startJobWithoutWaitingForResult("job_batchlet_step_listener", restartJobParameters);
            boolean seenException = false;
            try {
                TestUtil.logMsg((String)"Check for an instance of a non-existent job");
                jobOp.getRunningExecutions("JOBNAMEDOESNOTEXIST");
            }
            catch (NoSuchJobException e) {
                TestUtil.logMsg((String)"Confirmed that exception caught is an instanceof NoSuchJobException");
                seenException = true;
            }
            AssertionUtils.assertWithMessage("Saw NoSuchJobException for job 'JOBNAMEDOESNOTEXIST'", seenException);
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorGetJobExecution() throws EETest.Fault {
        String METHOD = "testJobOperatorGetJobExecution";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"execution.number=1");
            TestUtil.logMsg((String)"readrecord.fail=12");
            TestUtil.logMsg((String)"app.arraysize=30");
            TestUtil.logMsg((String)"app.writepoints=0,5,10,15,20,25,30");
            TestUtil.logMsg((String)"app.next.writepoints=10,15,20,25,30");
            TestUtil.logMsg((String)"app.commitinterval=5");
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("chunksize5commitinterval5", jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long jobInstanceId = execution1.getInstanceId();
            long lastExecutionId = execution1.getExecutionId();
            TCKJobExecutionWrapper exec = null;
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult for execution id: " + lastExecutionId + ""));
            exec = jobOp.restartJobAndWaitForResult(lastExecutionId, jobParams);
            lastExecutionId = exec.getExecutionId();
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + exec.getBatchStatus()));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + exec.getExitStatus()));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + exec.getInstanceId()));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, exec.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", exec.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", jobInstanceId, exec.getInstanceId());
            TestUtil.logMsg((String)"Testing retrieval of a JobExecution obj");
            JobExecution jobEx = jobOp.getJobExecution(lastExecutionId);
            TestUtil.logMsg((String)("Status retreived from JobExecution obj: " + jobEx.getBatchStatus() + ""));
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    public void testJobOperatorGetJobExecutions() throws EETest.Fault {
        String METHOD = "testJobOperatorGetJobExecutions";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        String jobName = "chunksize5commitinterval5";
        try {
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            jobParams.put("execution.number", "1");
            jobParams.put("readrecord.fail", "12");
            jobParams.put("app.arraysize", "30");
            jobParams.put("app.writepoints", "0,5,10,15,20,25,30");
            jobParams.put("app.next.writepoints", "10,15,20,25,30");
            jobParams.put("app.commitinterval", "5");
            TestUtil.logMsg((String)"Locate job XML file: chunksize5commitinterval5.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult(jobName, jobParams);
            TestUtil.logMsg((String)("execution #1 JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("execution #1 JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing execution #1", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #1", "FAILED", execution1.getExitStatus());
            long execution1ID = execution1.getExecutionId();
            TCKJobExecutionWrapper execution2 = null;
            TestUtil.logMsg((String)("Invoke restartJobAndWaitForResult for execution id: " + execution1ID + ""));
            execution2 = jobOp.restartJobAndWaitForResult(execution1ID, jobParams);
            TestUtil.logMsg((String)("execution #2 JobExecution getBatchStatus()=" + execution2.getBatchStatus()));
            TestUtil.logMsg((String)("execution #2 JobExecution getExitStatus()=" + execution2.getExitStatus()));
            TestUtil.logMsg((String)("execution #2 Job instance id=" + execution2.getInstanceId()));
            AssertionUtils.assertWithMessage("Testing execution #2", BatchStatus.COMPLETED, execution2.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing execution #2", "COMPLETED", execution2.getExitStatus());
            AssertionUtils.assertWithMessage("Testing execution #1 and execution #2 use the same instanceId", execution1.getInstanceId(), execution2.getInstanceId());
            long execution2ID = execution2.getExecutionId();
            JobInstance jobInstance = jobOp.getJobInstance(execution2ID);
            List<JobExecution> jobExecutions = jobOp.getJobExecutions(jobInstance);
            AssertionUtils.assertWithMessage("Testing list size of JobExecutions", 2, jobExecutions.size());
            boolean seen1 = false;
            boolean seen2 = false;
            for (JobExecution je : jobExecutions) {
                if (je.getExecutionId() == execution1ID) {
                    AssertionUtils.assertWithMessage("Dup of execution 1", !seen1);
                    TestUtil.logMsg((String)"Seen execution #1 ");
                    seen1 = true;
                    continue;
                }
                if (je.getExecutionId() != execution2ID) continue;
                AssertionUtils.assertWithMessage("Dup of execution 2", !seen2);
                TestUtil.logMsg((String)"Seen execution #2 ");
                seen2 = true;
            }
            AssertionUtils.assertWithMessage("Seen both of the two JobExecutions", seen1 && seen2);
            AssertionUtils.assertWithMessage("Job name from JobInstance matches", jobName, jobInstance.getJobName());
            AssertionUtils.assertWithMessage("Job name from JobExecution 1 matches", jobName, execution1.getJobName());
            AssertionUtils.assertWithMessage("Job name from JobExecution 2 matches", jobName, execution2.getJobName());
        }
        catch (Exception e) {
            JobOperatorTests.handleException(METHOD, e);
        }
    }

    private void showStepState(StepExecution step) {
        TestUtil.logMsg((String)"---------------------------");
        TestUtil.logMsg((String)("getStepName(): " + step.getStepName() + " - "));
        TestUtil.logMsg((String)("getJobExecutionId(): " + step.getStepExecutionId() + " - "));
        Metric[] metrics = step.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            TestUtil.logMsg((String)(metrics[i].getType() + ": " + metrics[i].getValue() + " - "));
        }
        TestUtil.logMsg((String)("getStartTime(): " + step.getStartTime() + " - "));
        TestUtil.logMsg((String)("getEndTime(): " + step.getEndTime() + " - "));
        TestUtil.logMsg((String)("getBatchStatus(): " + step.getBatchStatus() + " - "));
        TestUtil.logMsg((String)("getExitStatus(): " + step.getExitStatus()));
        TestUtil.logMsg((String)"---------------------------");
    }
}

