/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import com.ibm.jbatch.tck.artifacts.chunktypes.ArrayIndexCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.ReadRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyPersistentRestartUserData;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.AbstractItemWriter;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="defaultValueArrayWriter")
public class DefaultValueArrayWriter
extends AbstractItemWriter {
    private static final Logger logger = Logger.getLogger(DefaultValueArrayWriter.class.getName());
    private int[] writerDataArray = new int[30];
    private int idx = 0;
    private int chkArraySize;
    int chunkWriteIteration = 0;
    @Inject
    @BatchProperty(name="app.arraysize")
    String appArraySizeString;
    @Inject
    JobContext jobCtx;
    @Inject
    private StepContext stepCtx = null;
    int arraysize;

    public void open(Serializable cpd) throws Exception {
        logger.fine("openWriter");
        MyPersistentRestartUserData myData = null;
        myData = (MyPersistentRestartUserData)this.stepCtx.getPersistentUserData();
        if (myData != null) {
            this.stepCtx.setPersistentUserData((Serializable)new MyPersistentRestartUserData(myData.getExecutionNumber() + 1, null));
            logger.fine("AJM: iteration = " + ((MyPersistentRestartUserData)this.stepCtx.getPersistentUserData()).getExecutionNumber());
        } else {
            this.stepCtx.setPersistentUserData((Serializable)new MyPersistentRestartUserData(1, null));
        }
        ArrayIndexCheckpointData checkpointData = (ArrayIndexCheckpointData)cpd;
        this.arraysize = Integer.parseInt(this.appArraySizeString);
        if (checkpointData == null) {
            this.idx = 0;
            logger.fine("WRITE: chkpt data = null, so idx = " + this.idx);
        } else {
            this.idx = checkpointData.getCurrentIndex();
            logger.fine("WRITE: chkpt data was valid, so idx = " + this.idx);
            logger.fine("WRITE: chunkWriteIteration = " + this.chunkWriteIteration);
        }
        for (int i = 0; i < this.arraysize; ++i) {
            this.writerDataArray[i] = 0;
        }
    }

    public void close() throws Exception {
        for (int i = 0; i < this.arraysize; ++i) {
            logger.fine("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
    }

    public void writeItems(List<Object> myData) throws Exception {
        int i;
        logger.fine("writeMyData receives chunk size=" + myData.size());
        this.jobCtx.setExitStatus("buffer size = " + myData.size());
        logger.fine("WRITE: before writing, idx = " + this.idx);
        logger.fine("WRITE: before writing, chunkWriteIteration = " + this.chunkWriteIteration);
        for (i = 0; i < myData.size(); ++i) {
            this.writerDataArray[this.idx] = ((ReadRecord)myData.get(i)).getCount();
            ++this.idx;
        }
        for (i = 0; i < this.arraysize; ++i) {
            logger.fine("WRITE: writerDataArray[" + i + "] = " + this.writerDataArray[i]);
        }
    }

    public ArrayIndexCheckpointData checkpointInfo() throws Exception {
        ArrayIndexCheckpointData _chkptData = new ArrayIndexCheckpointData();
        _chkptData.setCurrentIndex(this.idx);
        return _chkptData;
    }

    private class MyTransient {
        int data = 0;

        MyTransient(int x) {
            this.data = x;
        }
    }
}

