/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.specialized;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.batch.api.BatchProperty;
import javax.batch.api.listener.StepListener;
import javax.batch.runtime.context.JobContext;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ArtifactInstanceTestStepListener
implements StepListener {
    @Inject
    JobContext jobCtx;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="step.property")
    String stepPropertyString;
    public static final String prop1 = "stepListenerA";
    public static final String prop2 = "stepListenerB";
    int instance1Count = 0;
    int instance2Count = 0;
    boolean uniqueInstance1 = false;
    boolean uniqueInstance2 = false;
    private boolean saw2Listeners = false;
    String passedInProp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeStep() throws Exception {
        StepContext stepContext = this.stepCtx;
        synchronized (stepContext) {
            if (this.stepCtx.getTransientUserData() == null) {
                ConcurrentHashMap<String, Boolean> dataMap = new ConcurrentHashMap<String, Boolean>();
                dataMap.put("sawProp1", false);
                dataMap.put("sawProp2", false);
                dataMap.put("sawChunkProp1", false);
                dataMap.put("sawChunkProp2", false);
                this.stepCtx.setTransientUserData(dataMap);
            }
        }
        Map instanceData = (Map)this.stepCtx.getTransientUserData();
        if (this.stepPropertyString.equals(prop1)) {
            instanceData.put("sawProp1", true);
            ++this.instance1Count;
        } else if (this.stepPropertyString.equals(prop2)) {
            instanceData.put("sawProp2", true);
            ++this.instance2Count;
        }
    }

    public void afterStep() throws Exception {
        String currentStatus;
        Map instanceData = (Map)this.stepCtx.getTransientUserData();
        if (((Boolean)instanceData.get("sawProp1")).booleanValue() && ((Boolean)instanceData.get("sawProp2")).booleanValue()) {
            this.saw2Listeners = true;
        }
        if (this.stepPropertyString.equals(prop1) && this.instance1Count == 1) {
            this.uniqueInstance1 = true;
        }
        if (this.stepPropertyString.equals(prop2) && this.instance2Count == 1) {
            this.uniqueInstance2 = true;
        }
        if ((currentStatus = this.jobCtx.getExitStatus()) != null && currentStatus.equals("BAD")) {
            return;
        }
        if (this.saw2Listeners && this.uniqueInstance1 ^ this.uniqueInstance2) {
            this.jobCtx.setExitStatus(this.jobCtx.getExitStatus() + "StepListener");
        } else {
            this.jobCtx.setExitStatus("STEP_BAD");
        }
    }
}

