/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.sec.stateful.lsecr;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.sec.stateful.common.SecTestLocal;
import com.sun.ts.tests.ejb30.sec.stateful.common.SecTestRoleRefLocal;
import com.sun.ts.tests.ejb30.sec.stateful.common.lTest;
import java.util.Properties;
import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.EJBException;
import javax.ejb.EJBs;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

@Stateful(name="lTestEJB")
@Remote(value={lTest.class})
@EJBs(value={@EJB(name="SecTestEJB", beanName="SecTestEJB", beanInterface=SecTestLocal.class), @EJB(name="SecTestRoleRefEJB", beanName="SecTestRoleRefEJB", beanInterface=SecTestRoleRefLocal.class)})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
@RunAs(value="Manager")
public class lTestEJB
implements lTest {
    @EJB(beanName="SecTestEJB")
    private SecTestLocal ejb1ref = null;
    @EJB(beanName="SecTestRoleRefEJB")
    private SecTestRoleRefLocal ejb2ref = null;
    private SessionContext sctx = null;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private Properties props = null;

    @Resource
    public void setSessionContext(SessionContext sc) {
        this.sctx = sc;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean IsCallerB1(String caller) {
        String name = this.sctx.getCallerPrincipal().getName();
        TestUtil.logMsg((String)("IsCallerB1: " + name));
        return name.indexOf(caller) >= 0;
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean InRole(String role) {
        try {
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbNotAuthz() {
        try {
            this.ejb1ref.EjbNotAuthz();
            TestUtil.logErr((String)"Method call did not generate an expected java.rmi.RemoteException");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Caught javax.ejb.EJBException as expected");
            this.cleanup(this.ejb1ref);
            return true;
        }
        catch (Exception ex) {
            TestUtil.printStackTrace((Throwable)ex);
            TestUtil.logMsg((String)("Caught Exception: " + ex.getMessage()));
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    @Remove
    private void cleanup(SecTestLocal ejbref) {
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbIsAuthz() {
        TestUtil.logMsg((String)"Starting Caller authorization test");
        try {
            boolean result = this.ejb1ref.EjbIsAuthz();
            if (!result) {
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbSecRoleRef(String role) {
        TestUtil.logMsg((String)"Starting Security role reference positive test");
        try {
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbSecRoleRef1(String role) {
        TestUtil.logMsg((String)"Starting Security role reference negative test");
        try {
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbSecRoleRefScope(String role) {
        TestUtil.logTrace((String)"Starting Security role scope test");
        try {
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            if (!result) {
                return false;
            }
            result = this.ejb2ref.EjbSecRoleRefScope(role);
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean EjbOverloadedSecRoleRefs(String role1, String role2) {
        TestUtil.logMsg((String)"Starting Overloaded security role references test");
        try {
            boolean result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1);
            if (!result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref) returned false");
                return false;
            }
            result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1, role2);
            if (result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref,mgr_secrole_ref) returned true");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("EjbOverloadedSecRoleRefs(" + role1 + "," + role2 + ") failed with Exception: "), (Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean checktest1() {
        try {
            boolean result = this.ejb1ref.checktest1();
            return result;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception for checktest1: ", (Throwable)e);
            return false;
        }
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.NEVER)
    public boolean excludetest1() {
        try {
            boolean result = this.ejb1ref.excludetest1();
            TestUtil.logTrace((String)"Should not be here.");
            return false;
        }
        catch (EJBException e) {
            TestUtil.logTrace((String)"Got expected EJBException");
            return true;
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Got wrong Exception in excludetest1:", (Throwable)ex);
            return false;
        }
    }
}

