/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.sec.stateful.lsecr;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.sec.stateful.common.SecTest;
import com.sun.ts.tests.ejb30.sec.stateful.common.SecTestLocal;
import javax.annotation.Resource;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

@Stateful(name="SecTestEJB")
@Remote(value={SecTest.class})
@Local(value={SecTestLocal.class})
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class SecTestEJB
implements SecTest {
    private SessionContext sctx = null;

    @Override
    @RolesAllowed(value={"Administrator"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Remove
    public boolean EjbNotAuthz() {
        return true;
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Remove
    public boolean EjbIsAuthz() {
        return true;
    }

    @Override
    @RolesAllowed(value={"Manager"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean EjbSecRoleRef(String role) {
        return this.sctx.isCallerInRole(role);
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public boolean EjbOverloadedSecRoleRefs(String role1) {
        TestUtil.logMsg((String)("isCallerInRole(" + role1 + ") = " + this.sctx.isCallerInRole(role1)));
        return this.sctx.isCallerInRole(role1);
    }

    @Override
    @RolesAllowed(value={"Administrator", "Manager", "VP", "Employee"})
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Remove
    public boolean EjbOverloadedSecRoleRefs(String role1, String role2) {
        TestUtil.logMsg((String)("isCallerInRole(" + role1 + ")= " + this.sctx.isCallerInRole(role1) + "isCallerInRole(" + role2 + ")= " + this.sctx.isCallerInRole(role2)));
        return this.sctx.isCallerInRole(role1) && this.sctx.isCallerInRole(role2);
    }

    @Override
    @PermitAll
    @Remove
    public boolean checktest1() {
        return true;
    }

    @Override
    @DenyAll
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @Remove
    public boolean excludetest1() {
        return true;
    }

    @Resource
    public void setSessionContext(SessionContext sc) {
        this.sctx = sc;
    }
}

