/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jacc.ejb.methodperm;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jacc.util.LogFileProcessor;
import com.sun.ts.tests.jacc.util.LogRecordEntry;
import java.security.Permission;
import java.security.Permissions;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;

public class Client
extends EETest {
    private Properties props = null;
    private String contextId = "jacc_ctx";
    LogFileProcessor logProcessor = null;
    private String applicationContext;
    private boolean initialized = false;
    private Permissions unCheckedPermissions = new Permissions();
    private Permissions excludedPermissions = new Permissions();
    private Permissions addToRolePermissions = new Permissions();

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        if (!this.initialized) {
            this.logProcessor = new LogFileProcessor(this.props);
            this.logProcessor.fetchLogs("getAppSpecificRecordCollection|appId", "jacc_ejb_methodperm");
            this.unCheckedPermissions = this.logProcessor.getAppSpecificUnCheckedPermissions();
            this.excludedPermissions = this.logProcessor.getAppSpecificExcludedPermissions();
            this.addToRolePermissions = this.logProcessor.getAppSpecificAddToRolePermissions();
            this.initialized = true;
        }
    }

    public void cleanup() throws EETest.Fault {
    }

    public void EJBMethodPermissionTest() throws EETest.Fault {
        boolean verified = false;
        Permissions expectedAddToRolePermissions = new Permissions();
        Permissions addToRoleEJBMethodPermissions = this.logProcessor.getSpecificPermissions(this.addToRolePermissions, "EJBMethodPermission");
        TestUtil.logMsg((String)"Server generated addToRole EJBMethodPermissions");
        this.logProcessor.printPermissionCollection(addToRoleEJBMethodPermissions);
        String[] params = new String[]{};
        expectedAddToRolePermissions.add((Permission)new EJBMethodPermission("jacc_ejb_methodperm_MethodPermBean", "protectedByRoleManager", "Remote", params));
        expectedAddToRolePermissions.add((Permission)new EJBMethodPermission("jacc_ejb_methodperm_MethodPermBean", "protectedByRoleAdminAndManager", "Remote", params));
        expectedAddToRolePermissions.add((Permission)new EJBMethodPermission("jacc_ejb_methodperm_MethodPermBean", "protectedByAnyAuthUser", "Remote", params));
        TestUtil.logMsg((String)"verifying unchecked policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedAddToRolePermissions, addToRoleEJBMethodPermissions);
        if (!verified) {
            throw new EETest.Fault("EJBMethodPermissionTest failed: addToRole policy statements verification failed");
        }
        TestUtil.logMsg((String)"addToRole policy statements verification successful");
    }

    public void EJBMethodPermissionAddToRole() throws EETest.Fault {
        boolean bManagerFound = false;
        boolean bAdminFound = false;
        Collection<LogRecordEntry> records = this.logProcessor.getMsgTagRecordCollection();
        Iterator<LogRecordEntry> iterator = records.iterator();
        while (iterator.hasNext()) {
            LogRecordEntry recordEntry = iterator.next();
            String message = recordEntry.getMessage();
            String permType = null;
            String roleName = null;
            String appContext = null;
            String permName = null;
            try {
                StringTokenizer tokens = new StringTokenizer(message, " :: ");
                if (message.indexOf(" :: ") <= 0) continue;
                tokens.nextToken();
                permType = tokens.nextToken();
                TestUtil.logTrace((String)("EJBMethodPermissionAddToRole:  permType = " + permType));
                if (permType == null || !permType.equals("EJBMethodPermission")) continue;
                roleName = tokens.nextToken();
                appContext = tokens.nextToken();
                permName = tokens.nextToken();
                TestUtil.logTrace((String)("roleName = " + roleName));
                TestUtil.logTrace((String)("appContext = " + appContext));
                TestUtil.logTrace((String)("permName = " + permName));
                if (permName == null || !permName.equals("jacc_ejb_methodperm_MethodPermBean")) continue;
                if (roleName != null && roleName.equals("Manager")) {
                    bManagerFound = true;
                } else if (roleName != null && roleName.equals("Administrator")) {
                    bAdminFound = true;
                } else if (roleName != null && roleName.equals("**")) {
                    TestUtil.logMsg((String)"EJBMethodPermission addToRole called for role '**'");
                }
                if (!bManagerFound || !bAdminFound) continue;
                TestUtil.logMsg((String)"bManagerFound && bAdminFound so breaking");
                break;
            }
            catch (NoSuchElementException ex) {
                TestUtil.logMsg((String)("Invalid MSG_TAG entry found in jacc log file: " + message));
                TestUtil.logMsg((String)ex.getMessage());
                iterator.next();
            }
        }
        TestUtil.logMsg((String)"verifying addToRole policy statments:");
        if (!bAdminFound || !bManagerFound) {
            throw new EETest.Fault("EJBMethodPermissionAddToRole failed: addToRole policy statements verification failed");
        }
        TestUtil.logMsg((String)"addToRole called for method-permission roles:  Administrator and Manager.");
    }

    public void EJBRoleRefPermission() throws EETest.Fault {
        boolean verified = false;
        Permissions expectedAddToRolePermissions = new Permissions();
        Permissions addToRoleEJBRoleRefPermissions = this.logProcessor.getSpecificPermissions(this.addToRolePermissions, "EJBRoleRefPermission");
        TestUtil.logMsg((String)"Server generated addToRole EJBRoleRefPermissions");
        this.logProcessor.printPermissionCollection(addToRoleEJBRoleRefPermissions);
        expectedAddToRolePermissions.add((Permission)new EJBRoleRefPermission("jacc_ejb_methodperm_MethodPermBean", "ADMIN"));
        expectedAddToRolePermissions.add((Permission)new EJBRoleRefPermission("jacc_ejb_methodperm_MethodPermBean", "Administrator"));
        expectedAddToRolePermissions.add((Permission)new EJBRoleRefPermission("jacc_ejb_methodperm_MethodPermBean", "MGR"));
        expectedAddToRolePermissions.add((Permission)new EJBRoleRefPermission("jacc_ejb_methodperm_MethodPermBean", "Manager"));
        expectedAddToRolePermissions.add((Permission)new EJBRoleRefPermission("jacc_ejb_methodperm_MethodPermBean", "EMP"));
        expectedAddToRolePermissions.add((Permission)new EJBRoleRefPermission("jacc_ejb_methodperm_MethodPermBean", "Employee"));
        expectedAddToRolePermissions.add((Permission)new EJBRoleRefPermission("jacc_ejb_methodperm_MethodPermBean", "**"));
        TestUtil.logMsg((String)"verifying addToRole policy statments:");
        verified = this.logProcessor.verifyLogImplies(expectedAddToRolePermissions, addToRoleEJBRoleRefPermissions);
        if (!verified) {
            throw new EETest.Fault("EJBRoleRefPermission failed: addToRole policy statements verification failed");
        }
        TestUtil.logMsg((String)"addToRole policy statements verification successful");
    }

    public void EJBMethodPermissionEquals() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"EJBMethodPermission.equals() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("EJBMethodPermissionEquals : FAILED");
        }
        TestUtil.logMsg((String)"EJBMethodPermissionEquals : PASSED");
    }

    public void EJBRoleRefPermissionEquals() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"EJBRoleRefPermission.equals() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("EJBRoleRefPermissionEquals : FAILED");
        }
        TestUtil.logMsg((String)"EJBRoleRefPermissionEquals : PASSED");
    }

    public void EJBMethodPermissionHashCode() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"EJBMethodPermission.hashCode() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("EJBMethodPermissionHashCode : FAILED");
        }
        TestUtil.logMsg((String)"EJBMethodPermissionHashCode : PASSED");
    }

    public void EJBRoleRefPermissionHashCode() throws EETest.Fault {
        boolean verified = false;
        String[] tempArgs = new String[]{"EJBRoleRefPermission.hashCode() : PASSED"};
        verified = this.logProcessor.verifyLogContains(tempArgs);
        if (!verified) {
            throw new EETest.Fault("EJBRoleRefPermissionHashCode : FAILED");
        }
        TestUtil.logMsg((String)"EJBRoleRefPermissionHashCode : PASSED");
    }
}

