/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.nonpositiveinteger.mininclusive.mininclusive_4;

import jakarta.xml.bind.*;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minInclusive4_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minInclusive4_GetSetCTTests test = new minInclusive4_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "minInclusive-4-1.xml", "minInclusive-4-2.xml", "minInclusive-4-3.xml",
            "minInclusive-4-4.xml", "minInclusive-4-5.xml"
        };

        BigInteger[] expectedValues = {new BigInteger("-15842681987220108564"), new BigInteger("-12555015838406596306"), 
                                       new BigInteger("-3233414323156016904"), new BigInteger("-7840118871328560871"), 
                                       new BigInteger("0")};
        BigInteger[] anExpectedValues = {new BigInteger("-15842681987220108563"), new BigInteger("-15842681987220108564"), 
                                         new BigInteger("0"), new BigInteger("-7840118871328560871"), 
                                         new BigInteger("-1")};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<BigInteger> elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocNames[i]);
            if (!elemObj.getValue().equals(expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!elemObj.getValue().equals(anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        BigInteger[] setValues = {new BigInteger("-15842681987220108564"), new BigInteger("-12555015838406596306"), 
                                  new BigInteger("-3233414323156016904"), new BigInteger("-7840118871328560871"), 
                                  new BigInteger("0")};
        BigInteger[] anSetValues = {new BigInteger("-15842681987220108563"), new BigInteger("-15842681987220108564"), 
                                    new BigInteger("0"), new BigInteger("-7840118871328560871"), 
                                    new BigInteger("-1")};

        JAXBElement<BigInteger> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerMinInclusive4(setValues[i]);
            
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!elemObj.getValue().equals(anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

