/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._int.maxexclusive.maxexclusive_5;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxExclusive5_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxExclusive5_GetSetCTTests test = new maxExclusive5_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "maxExclusive-5-1.xml", "maxExclusive-5-2.xml", "maxExclusive-5-3.xml",
            "maxExclusive-5-4.xml", "maxExclusive-5-5.xml"
        };
        int[] expectedValues = {-2147483648, 1933487881, -1364906274, -760064009, 2147483646};
        int[] anExpectedValues = {2147483646, -2147483648, -1364906274, 760064009, 0};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Integer> elemObj = (JAXBElement<Integer>)unmarshal(xmlDocNames[i]);
            if (elemObj.getValue() != expectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (elemObj.getValue() != anExpectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        int[] setValues = {-2147483648, 1933487881, -1364906274, -760064009, 2147483646};
        int[] anSetValues = {2147483646, -2147483648, -1364906274, 760064009, 0};

        JAXBElement<Integer> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaIntMaxExclusive5(setValues[i]);
            
            if (elemObj.getValue() != setValues[i]){
                return Status.failed("dynamically created JAXBElement<Integer>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (elemObj.getValue() != anSetValues[i]){
                return Status.failed("dynamically created JAXBElement<Integer>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

