/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._byte.maxexclusive.maxexclusive_5;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxExclusive5_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxExclusive5_ValidateCTTests test = new maxExclusive5_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final byte[] validValues = {(byte)-128, (byte)-70, (byte)0, (byte)70, (byte)126};
    
    final byte[] invalidValues = {(byte)127};
    
    JAXBElement<Byte> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "maxExclusive-5-1.xml";
        elemObj = (JAXBElement<Byte>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "maxExclusive-5-1.xml";
        elemObj = (JAXBElement<Byte>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Byte>)(new ObjectFactory()).createNISTSchemaByteMaxExclusive5((byte)0);
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Byte>)(new ObjectFactory()).createNISTSchemaByteMaxExclusive5((byte)0);
        
        return testInvalid();
    }


}

