/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLParameters;
import jdk.incubator.http.ConnectionPool;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.PlainTunnelingConnection;
import jdk.incubator.http.SSLDelegate;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.Utils;

class SSLTunnelConnection
extends HttpConnection {
    final PlainTunnelingConnection delegate;
    protected SSLDelegate sslDelegate;
    private volatile boolean connected;
    final String serverName;

    @Override
    public void connect() throws IOException, InterruptedException {
        this.delegate.connect();
        this.sslDelegate = new SSLDelegate(this.delegate.channel(), this.client, null, this.serverName);
        this.connected = true;
    }

    @Override
    boolean connected() {
        return this.connected && this.delegate.connected();
    }

    @Override
    public CompletableFuture<Void> connectAsync() {
        return this.delegate.connectAsync().thenAccept(void_ -> {
            try {
                this.sslDelegate = new SSLDelegate(this.delegate.channel(), this.client, null, this.serverName);
                this.connected = true;
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
        });
    }

    SSLTunnelConnection(InetSocketAddress inetSocketAddress, HttpClientImpl httpClientImpl, InetSocketAddress inetSocketAddress2) {
        super(inetSocketAddress, httpClientImpl);
        this.serverName = Utils.getServerName(inetSocketAddress);
        this.delegate = new PlainTunnelingConnection(inetSocketAddress, inetSocketAddress2, httpClientImpl);
    }

    @Override
    SSLParameters sslParameters() {
        return this.sslDelegate.getSSLParameters();
    }

    @Override
    public String toString() {
        return "SSLTunnelConnection: " + super.toString();
    }

    private static long countBytes(ByteBuffer[] byteBufferArray, int n, int n2) {
        long l = 0L;
        for (int i = 0; i < n2; ++i) {
            l += (long)byteBufferArray[n + i].remaining();
        }
        return l;
    }

    @Override
    ConnectionPool.CacheKey cacheKey() {
        return ConnectionPool.cacheKey(this.address, this.delegate.proxyAddr);
    }

    @Override
    long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = SSLTunnelConnection.countBytes(byteBufferArray, n, n2);
        SSLDelegate.WrapperResult wrapperResult = this.sslDelegate.sendData(byteBufferArray, n, n2);
        if (wrapperResult.result.getStatus() == SSLEngineResult.Status.CLOSED && l > 0L) {
            throw new IOException("SSLHttpConnection closed");
        }
        return l;
    }

    @Override
    long write(ByteBuffer byteBuffer) throws IOException {
        long l = byteBuffer.remaining();
        SSLDelegate.WrapperResult wrapperResult = this.sslDelegate.sendData(byteBuffer);
        if (wrapperResult.result.getStatus() == SSLEngineResult.Status.CLOSED && l > 0L) {
            throw new IOException("SSLHttpConnection closed");
        }
        return l;
    }

    @Override
    void writeAsync(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        this.write(ByteBufferReference.toBuffers(byteBufferReferenceArray), 0, byteBufferReferenceArray.length);
    }

    @Override
    void writeAsyncUnordered(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        this.write(ByteBufferReference.toBuffers(byteBufferReferenceArray), 0, byteBufferReferenceArray.length);
    }

    @Override
    void flushAsync() throws IOException {
    }

    @Override
    public void close() {
        Utils.close(this.delegate.channel());
    }

    @Override
    void shutdownInput() throws IOException {
        this.delegate.channel().shutdownInput();
    }

    @Override
    void shutdownOutput() throws IOException {
        this.delegate.channel().shutdownOutput();
    }

    @Override
    protected ByteBuffer readImpl() throws IOException {
        ByteBuffer byteBuffer = Utils.getBuffer();
        SSLDelegate.WrapperResult wrapperResult = this.sslDelegate.recvData(byteBuffer);
        return wrapperResult.buf;
    }

    @Override
    SocketChannel channel() {
        return this.delegate.channel();
    }

    @Override
    CompletableFuture<Void> whenReceivingResponse() {
        return this.delegate.whenReceivingResponse();
    }

    @Override
    boolean isSecure() {
        return true;
    }

    @Override
    boolean isProxied() {
        return true;
    }
}

