/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.util;

import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.util.BatchFileParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class CommandLineParser {
    private final Object servicedObject;
    private final KnownOptions knownOptions;
    private final Map<String, String> decoders = new HashMap<String, String>();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(CommandLineParser.class);
    private final Map<String, List<String>> foundOptions = new HashMap<String, List<String>>();

    public CommandLineParser(Object servicedObject, String optionPrefix) {
        this.servicedObject = servicedObject;
        this.knownOptions = new KnownOptions(optionPrefix);
    }

    public final void addOption(String option, OptionInfo info) {
        String temp = option;
        if (!info.isCaseSentitive()) {
            temp = option.toLowerCase();
        }
        this.knownOptions.add(temp, info);
    }

    public final void addOption(String option, OptionInfo info, String decoder) {
        String temp = option;
        if (!info.isCaseSentitive()) {
            temp = option.toLowerCase();
        }
        this.knownOptions.add(temp, info);
        this.decoders.put(temp, decoder);
    }

    public final void removeKnownOption(String option) {
        this.knownOptions.remove(option);
    }

    public void processArgs(String[] args) throws CommandLineParserException {
        args = BatchFileParser.processParameters(args);
        this.foundOptions.clear();
        boolean noValidate = false;
        String optionStr = null;
        for (String arg : args) {
            if (this.knownOptions.isKnownOption(arg)) {
                OptionInfo ki = this.knownOptions.get(arg);
                optionStr = ki.toKey(arg);
                List<String> params = this.foundOptions.get(optionStr);
                if (params == null) {
                    this.foundOptions.put(optionStr, new ArrayList());
                } else if (!ki.isMultiple()) {
                    throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.duplicate", optionStr));
                }
                Option o = Option.byKey(arg);
                if (o == null) continue;
                noValidate = noValidate || o.getKind() == Option.Kind.INSTEAD_OF_ANY;
                continue;
            }
            if (!this.knownOptions.isOption(arg)) {
                if (optionStr == null) continue;
                this.foundOptions.get(optionStr).add(arg);
                continue;
            }
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.unknown", arg));
        }
        if (!noValidate) {
            this.knownOptions.validate(this.foundOptions);
        }
        for (Map.Entry entry : this.foundOptions.entrySet()) {
            this.invokeDecoder((String)entry.getKey(), (List)entry.getValue());
        }
    }

    public boolean isOptionSpecified(String arg, String checkedOption) {
        return this.knownOptions.isOption(arg) && checkedOption.equalsIgnoreCase(arg);
    }

    public boolean isOptionSpecified(String option) {
        if (!this.knownOptions.isKnownOption(option)) {
            throw new IllegalArgumentException(i18n.getString("CommandLineParser.error.option.unknown", option));
        }
        OptionInfo ki = this.knownOptions.get(option);
        String temp = ki.toKey(option);
        return this.foundOptions.get(temp) != null;
    }

    private void invokeDecoder(String option, List<String> params) throws CommandLineParserException {
        String decoder = this.decoders.get(option);
        if (decoder != null) {
            this.invokeExplicitDecoder(decoder, option, params);
        } else {
            this.invokeDefaultDecoder(option, params);
        }
    }

    private void invokeExplicitDecoder(String decoder, String option, List<String> params) throws CommandLineParserException {
        Class<?> cl = this.servicedObject.getClass();
        String[] stemp = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            stemp[i] = params.get(i);
        }
        try {
            Method method = cl.getMethod(decoder, String.class, String[].class);
            method.invoke(this.servicedObject, option, stemp);
        }
        catch (NoSuchMethodException nsme) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.explicit.notfound", new Object[]{decoder, option, cl.getName()}), nsme);
        }
        catch (InvocationTargetException e) {
            Throwable th = e.getTargetException();
            String message = th instanceof CommandLineParserException ? th.getMessage() : i18n.getString("CommandLineParser.error.decoder.failed", new Object[]{option, th});
            throw new CommandLineParserException(message);
        }
        catch (Exception e) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.failed", new Object[]{option, e}));
        }
    }

    private void invokeDefaultDecoder(String option, List<String> params) throws CommandLineParserException {
        try {
            String[] stemp = new String[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                stemp[i] = params.get(i);
            }
            this.getDefaultDecoderMethod(option).invoke(this.servicedObject, new Object[]{stemp});
        }
        catch (Exception e) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.failed", new Object[]{option, e}));
        }
    }

    private boolean isDecoder(Method method, String option) {
        String methodName = "decode" + option;
        return method.getName().equalsIgnoreCase(methodName) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(String[].class);
    }

    private Method getDefaultDecoderMethod(String option) throws CommandLineParserException {
        Method m = this.getDefaultDecoderMethod(this.servicedObject.getClass().getMethods(), option);
        if (m == null) {
            throw new CommandLineParserException(i18n.getString("CommandLineParser.error.decoder.default.notfound", new Object[]{option, this.servicedObject.getClass().getName()}));
        }
        return m;
    }

    private Method getDefaultDecoderMethod(Method[] methods, String option) {
        for (Method method : methods) {
            if (!this.isDecoder(method, option)) continue;
            return method;
        }
        return null;
    }

    public static String[] parseListOption(String[] args) {
        ArrayList<String> ar = new ArrayList<String>();
        for (String arg : args) {
            StringTokenizer st = new StringTokenizer(arg, System.getProperty("path.separator"));
            while (st.hasMoreTokens()) {
                ar.add(st.nextToken());
            }
        }
        return ar.toArray(new String[0]);
    }

    public void addOptions(EnumSet<Option> options, String optionsDecoder) {
        for (Option o : options) {
            this.addOption(o, optionsDecoder);
        }
    }

    public void addOption(Option o, String optionsDecoder) {
        switch (o.getKind()) {
            case NONE: 
            case INSTEAD_OF_ANY: {
                this.addOption(o.getKey(), OptionInfo.optionalFlag(), optionsDecoder);
                if (!o.hasAlias()) break;
                this.addOption(o.getAlias(), OptionInfo.optionalFlag(), optionsDecoder);
                break;
            }
            case SINGLE_OPT: {
                this.addOption(o.getKey(), OptionInfo.option(1), optionsDecoder);
                if (!o.hasAlias()) break;
                this.addOption(o.getAlias(), OptionInfo.option(1), optionsDecoder);
                break;
            }
            case SINGLE_REQ: 
            case REQ_LIST: {
                this.addOption(o.getKey(), OptionInfo.requiredOption(1), optionsDecoder);
                if (!o.hasAlias()) break;
                this.addOption(o.getKey(), OptionInfo.requiredOption(1), optionsDecoder);
                break;
            }
            case MANY_OPT: {
                this.addOption(o.getKey(), OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), optionsDecoder);
                if (!o.hasAlias()) break;
                this.addOption(o.getAlias(), OptionInfo.optionVariableParams(1, Integer.MAX_VALUE), optionsDecoder);
            }
        }
    }

    private static class KnownOptions {
        private final Map<String, OptionInfo> data = new HashMap<String, OptionInfo>();
        private final String optionPrefix;

        public KnownOptions(String optionPrefix) {
            this.optionPrefix = optionPrefix;
        }

        private boolean isKnownOption(String arg) {
            if (this.isOption(arg)) {
                String temp = arg;
                if (!this.data.containsKey(temp)) {
                    OptionInfo ki = this.data.get(temp = temp.toLowerCase());
                    if (ki != null) {
                        return !ki.isCaseSentitive();
                    }
                } else {
                    return true;
                }
            }
            return false;
        }

        private void add(String option, OptionInfo info) {
            if (!option.startsWith(this.optionPrefix)) {
                throw new IllegalArgumentException(i18n.getString("CommandLineParser.error.option.noprefix", this.optionPrefix));
            }
            this.data.put(option, info);
        }

        private void remove(String option) {
            this.data.remove(option);
        }

        private OptionInfo get(String option) {
            String temp = option;
            OptionInfo ki = this.data.get(temp);
            if (ki == null && ((ki = this.data.get(temp = temp.toLowerCase())) == null || ki.isCaseSentitive())) {
                return null;
            }
            return ki;
        }

        private void validateRequiredOptions(Set<String> foundKeys) throws CommandLineParserException {
            for (Map.Entry<String, OptionInfo> stringOptionInfoEntry : this.data.entrySet()) {
                OptionInfo ki = stringOptionInfoEntry.getValue();
                if (!ki.isRequired() || foundKeys.contains(stringOptionInfoEntry.getKey())) continue;
                throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.required", stringOptionInfoEntry.getKey()));
            }
        }

        private void validateCount(String option, int paramCount) throws CommandLineParserException {
            OptionInfo info = this.data.get(option);
            int minCount = info.getMinCount();
            int maxCount = info.getMaxCount();
            if (paramCount < minCount) {
                throw new CommandLineParserException(i18n.getString("CommandLineParser.error.option.require_more_parameters", new Object[]{option, minCount}));
            }
            if (paramCount > maxCount) {
                String msg = i18n.getString("CommandLineParser.error.option.require_less_parameters", new Object[]{option, maxCount});
                if (maxCount == 0) {
                    msg = i18n.getString("CommandLineParser.error.option.require_no_parameters", option);
                }
                throw new CommandLineParserException(msg);
            }
        }

        private void validate(Map<String, List<String>> params) throws CommandLineParserException {
            this.validateRequiredOptions(params.keySet());
            for (Map.Entry<String, List<String>> stringListEntry : params.entrySet()) {
                this.validateCount(stringListEntry.getKey(), stringListEntry.getValue().size());
            }
        }

        public boolean isOption(String arg) {
            return arg.startsWith(this.optionPrefix);
        }
    }
}

