/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.apicover;

import com.sun.tdk.apicover.markup.Adapter;
import com.sun.tdk.signaturetest.core.Erasurator;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class RefCounter {
    private HashMap<String, ClassDescription> api = new HashMap();
    private MODE mode = MODE.WORST;
    private Erasurator erasurator = new Erasurator();
    private Map<String, ClassDescription> ts = new HashMap<String, ClassDescription>();
    Map<String, Integer> results = new HashMap<String, Integer>();

    public void addClass(ClassDescription cd) {
        ArrayList<MemberDescription> modified = new ArrayList<MemberDescription>();
        boolean hasTracked = false;
        Iterator i = cd.getMembersIterator();
        boolean hasMembers = i.hasNext();
        while (i.hasNext()) {
            MemberDescription md = (MemberDescription)i.next();
            if (md.hasModifier(Adapter.coverIgnore)) {
                i.remove();
                continue;
            }
            hasTracked = true;
            MemberDescription md2 = (MemberDescription)md.clone();
            if (this.mode.equals((Object)MODE.WORST) && !md.getDeclaringClassName().equals(cd.getQualifiedName()) && !md.isFinal()) {
                md2.setDeclaringClass(cd.getQualifiedName());
            }
            i.remove();
            modified.add(md2);
        }
        for (MemberDescription md : modified) {
            cd.add(md);
        }
        if (hasTracked || !hasMembers) {
            this.api.put(cd.getQualifiedName(), cd);
        }
    }

    public void addTSClass(ClassDescription cd, boolean fromAPI) {
        if (fromAPI) {
            this.ts.put(cd.getQualifiedName(), this.erasurator.erasure(cd));
            return;
        }
        String parent = this.findSuper(cd);
        if (parent.equals(cd.getQualifiedName()) && cd.getInterfaces().length == 0) {
            return;
        }
        this.ts.put(cd.getQualifiedName(), this.erasurator.erasure(cd));
    }

    public void addRef(MemberDescription call) {
        String calledClass = call.getDeclaringClassName();
        if (this.ts.get(call.getDeclaringClassName()) == null) {
            return;
        }
        try {
            calledClass = this.findDecl(this.ts.get(calledClass), call);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ClassDescription apiClass = this.api.get(calledClass);
        if (apiClass != null) {
            this.erasurator.parseTypeParameters(apiClass);
            Iterator j = apiClass.getMembersIterator();
            while (j.hasNext()) {
                MemberDescription orig = (MemberDescription)j.next();
                MemberDescription erased = this.erasurator.processMember(orig);
                if (!erased.equals(call)) continue;
                this.results.put(orig.toString(), 1);
            }
        }
    }

    private String findDecl(ClassDescription tsClass, MemberDescription md) {
        boolean foundSuper = true;
        while (foundSuper) {
            if (tsClass.getMembersIterator().hasNext()) {
                if (tsClass.containsMember(md)) {
                    return tsClass.findMember(md).getDeclaringClassName();
                }
            } else {
                for (ConstructorDescr constructorDescr : tsClass.getDeclaredConstructors()) {
                    if (!((Object)constructorDescr).equals(md)) continue;
                    return tsClass.getQualifiedName();
                }
                for (MemberDescription memberDescription : tsClass.getDeclaredFields()) {
                    if (!memberDescription.equals(md)) continue;
                    return tsClass.getQualifiedName();
                }
                for (MemberDescription memberDescription : tsClass.getDeclaredMethods()) {
                    if (!memberDescription.equals(md)) continue;
                    return tsClass.getQualifiedName();
                }
            }
            foundSuper = false;
            if (tsClass.getSuperClass() == null || this.ts.get(tsClass.getSuperClass().getQualifiedName()) == null) continue;
            tsClass = this.ts.get(tsClass.getSuperClass().getQualifiedName());
            foundSuper = true;
        }
        return tsClass.getQualifiedName();
    }

    boolean isCovered(MemberDescription md) {
        return this.results.get(md.toString()) != null;
    }

    private String findSuper(ClassDescription tsClass) {
        while (tsClass.getSuperClass() != null) {
            if (this.ts.get(tsClass.getSuperClass().getQualifiedName()) != null) {
                tsClass = this.ts.get(tsClass.getSuperClass().getQualifiedName());
                continue;
            }
            return tsClass.getQualifiedName();
        }
        return tsClass.getQualifiedName();
    }

    public void setMode(String mode) {
        this.mode = "r".equals(mode) ? MODE.REAL : MODE.WORST;
    }

    private void clearInheretid() {
        for (ClassDescription cd : this.api.values()) {
            Iterator i = cd.getMembersIterator();
            while (i.hasNext()) {
                MemberDescription md = (MemberDescription)i.next();
                if (!(md.isConstructor() || md.isField() || md.isMethod())) {
                    i.remove();
                    continue;
                }
                if (!this.mode.equals((Object)MODE.REAL) || md.getDeclaringClassName().equals(cd.getQualifiedName())) continue;
                i.remove();
            }
        }
    }

    public Collection<ClassDescription> getClasses() {
        this.clearInheretid();
        return this.api.values();
    }

    private static enum MODE {
        REAL,
        WORST;

    }
}

