/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public class ContextAndListenerTests
extends ServiceEETest {
    private static final Logger logger = Logger.getLogger(ContextAndListenerTests.class.getName());
    private static JobOperatorBridge jobOp = null;

    public static void setup(String[] args, Properties props) throws EETest.Fault {
        String METHOD = "setup";
        TestUtil.logTrace((String)METHOD);
        try {
            jobOp = new JobOperatorBridge();
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    public static void setUp() throws EETest.Fault {
        jobOp = new JobOperatorBridge();
    }

    public void testExamineJobContextInArtifact() throws EETest.Fault {
        String METHOD = "testExamineJobContextInArtifact()";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: oneArtifactIsJobAndStepListener.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"app.timeinterval=10");
            jobParams.put("app.timeinterval", "10");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("JobContextTestBatchlet", jobParams);
            String testString = "JobName=job1;JobInstanceId=" + jobOp.getJobInstance(execution1.getExecutionId()).getInstanceId() + ";JobExecutionId=" + execution1.getExecutionId();
            TestUtil.logMsg((String)"EXPECTED JobExecution getBatchStatus()=COMPLETED");
            TestUtil.logMsg((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("EXPECTED JobExecution getExitStatus()=" + testString));
            TestUtil.logMsg((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", testString, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    public void testExamineStepContextInArtifact() throws EETest.Fault {
        String METHOD = "testExamineStepContextInArtifact()";
        TestUtil.logTrace((String)METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: oneArtifactIsJobAndStepListener.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"app.timeinterval=10");
            jobParams.put("app.timeinterval", "10");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("StepContextTestBatchlet", jobParams);
            List<StepExecution> steps = jobOp.getStepExecutions(execution1.getExecutionId());
            AssertionUtils.assertWithMessage("list of step executions == 1", steps.size() == 1);
            String testString = "StepName=step1;StepExecutionId=" + steps.get(0).getStepExecutionId();
            TestUtil.logMsg((String)"EXPECTED JobExecution getBatchStatus()=COMPLETED");
            TestUtil.logMsg((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("EXPECTED JobExecution getExitStatus()=" + testString));
            TestUtil.logMsg((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", testString, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    public void testOneArtifactIsJobAndStepListener() throws EETest.Fault {
        String METHOD = "testOneArtifactIsJobAndStepListener";
        TestUtil.logTrace((String)METHOD);
        try {
            String expectedStr = "BeforeJobBeforeStepUnusedExitStatusForPartitionsAfterStepBeforeStepUnusedExitStatusForPartitionsAfterStepAfterJob";
            TestUtil.logMsg((String)"Locate job XML file: oneArtifactIsJobAndStepListener.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"app.timeinterval=10");
            jobParams.put("app.timeinterval", "10");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("oneArtifactIsJobAndStepListener", jobParams);
            TestUtil.logMsg((String)"EXPECTED JobExecution getBatchStatus()=COMPLETED");
            TestUtil.logMsg((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("EXPECTED JobExecution getExitStatus()=" + expectedStr));
            TestUtil.logMsg((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", expectedStr, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    public void testgetException() throws EETest.Fault {
        String METHOD = "testgetException";
        TestUtil.logTrace((String)METHOD);
        try {
            String expectedStr = "MyChunkListener: found instanceof MyParentException";
            TestUtil.logMsg((String)"Locate job XML file: oneArtifactIsJobAndStepListener.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"fail.immediate=true");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("job_chunk_getException", jobParams);
            TestUtil.logMsg((String)"EXPECTED JobExecution getBatchStatus()=FAILED");
            TestUtil.logMsg((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("EXPECTED JobExecution getExitStatus()=" + expectedStr));
            TestUtil.logMsg((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", expectedStr, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    public void testgetExceptionListenerBased() throws EETest.Fault {
        String METHOD = "testgetExceptionListenerBased";
        TestUtil.logTrace((String)METHOD);
        try {
            String expectedStr = "MyChunkListener: found instanceof MyParentException";
            TestUtil.logMsg((String)"Locate job XML file: oneArtifactIsJobAndStepListener.xml");
            TestUtil.logMsg((String)"Create job parameters for execution #1:");
            Properties jobParams = new Properties();
            TestUtil.logMsg((String)"fail.immediate=true");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult for execution #1");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("job_chunk_getExceptionListeners", jobParams);
            TestUtil.logMsg((String)"EXPECTED JobExecution getBatchStatus()=FAILED");
            TestUtil.logMsg((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus()));
            TestUtil.logMsg((String)("EXPECTED JobExecution getExitStatus()=" + expectedStr));
            TestUtil.logMsg((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus()));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", expectedStr, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    public void testJobContextIsUniqueForMainThreadAndPartitions() throws EETest.Fault {
        String METHOD = "testJobContextIsUniqueForMainThreadAndPartitions";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_partitioned_1step.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobAndWaitForResult("job_partitioned_1step");
            TestUtil.logMsg((String)("JobExecution getBatchStatus()=" + jobExecution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
            AssertionUtils.assertObjEquals("COMPLETED", jobExecution.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    public void testJobContextIsUniqueForMainThreadAndFlowsInSplits() throws EETest.Fault {
        String METHOD = "testJobContextIsUniqueForMainThreadAndFlowsInSplits";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_split_batchlet_4steps.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_split_batchlet_4steps");
            TestUtil.logMsg((String)("JobExecution getBatchStatus()=" + execution.getBatchStatus()));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, execution.getBatchStatus());
            AssertionUtils.assertObjEquals("COMPLETED", execution.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    public void testStepContextIsUniqueForMainThreadAndPartitions() throws EETest.Fault {
        String METHOD = "testStepContextIsUniqueForMainThreadAndPartitions";
        TestUtil.logTrace((String)METHOD);
        this.begin(METHOD);
        try {
            TestUtil.logMsg((String)"Locate job XML file: job_partitioned_1step.xml");
            TestUtil.logMsg((String)"Invoke startJobAndWaitForResult");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobAndWaitForResult("job_partitioned_1step");
            TestUtil.logMsg((String)("JobExecution getBatchStatus()=" + jobExecution.getBatchStatus() + ""));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
            List<StepExecution> stepExecs = jobOp.getStepExecutions(jobExecution.getExecutionId());
            StepExecution stepExec = stepExecs.get(0);
            AssertionUtils.assertObjEquals("COMPLETED", stepExec.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    public static void cleanup() throws EETest.Fault {
    }

    private static void handleException(String methodName, Exception e) throws EETest.Fault {
        TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
        TestUtil.printStackTrace((Throwable)e);
        throw new EETest.Fault(methodName + " failed", e);
    }

    private void begin(String str) {
        TestUtil.logMsg((String)("Begin test method: " + str + ""));
    }
}

