/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.mdb.modernconnector.ejb;

import com.sun.ts.tests.ejb32.mdb.modernconnector.ejb.EventLoggerRemote;
import jakarta.ejb.LocalBean;
import jakarta.ejb.Lock;
import jakarta.ejb.LockType;
import jakarta.ejb.Singleton;
import jakarta.ejb.Startup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@Startup
@Singleton
@LocalBean
@Lock(value=LockType.READ)
public class EventLoggerBean
implements EventLoggerRemote {
    private final CountDownLatch expected = new CountDownLatch(6);
    private final List<String> eventRecords = new ArrayList<String>();

    @Override
    public List<String> getEventRecords() {
        return Collections.unmodifiableList(this.eventRecords);
    }

    public void logEvent(String event) {
        this.eventRecords.add(event);
        this.expected.countDown();
    }

    @Override
    public boolean awaitInvocations() {
        try {
            return this.expected.await(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            return false;
        }
    }
}

