/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.mdb;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.mdb.EjbClientIF;
import jakarta.ejb.EJB;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private URL url = null;
    private URLConnection urlConn = null;
    private String SERVLET = "/cditestsmdb_web/ServletTest";
    @EJB(name="ejb/CDITestsMDBClntBean")
    static EjbClientIF ejbclient;
    private static final long serialVersionUID = 1L;
    long timeout;
    String user;
    String password;
    String mode;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.timeout = Integer.parseInt(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            this.hostname = p.getProperty("webServerHost");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null ");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            if (this.hostname == null) {
                throw new Exception("'webServerHost' in ts.jte must not be null");
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            }
            catch (Exception e) {
                throw new Exception("'webServerPort' in ts.jte must be a number");
            }
            TestUtil.logMsg((String)("AppClient DEBUG: ejbclient=" + ejbclient));
            if (ejbclient == null) {
                throw new EETest.Fault("setup failed: ejbclient injection failure");
            }
            ejbclient.init(p);
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        ejbclient.init(p);
        TestUtil.logMsg((String)"setup ok");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }

    public void testCDIInjectionOfMDBWithQueueReplyFromEjb() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"------------------------------------------");
            TestUtil.logMsg((String)"testCDIInjectionOfMDBWithQueueReplyFromEjb");
            TestUtil.logMsg((String)"------------------------------------------");
            boolean passEjb = ejbclient.echo("testCDIInjectionOfMDBWithQueueReplyFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
            passEjb = ejbclient.echo("testCDIInjectionOfMDBWithQueueReplyFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("testCDIInjectionOfMDBWithQueueReplyFromEjb failed");
        }
    }

    public void testCDIInjectionOfMDBWithTopicReplyFromEjb() throws EETest.Fault {
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"------------------------------------------");
            TestUtil.logMsg((String)"testCDIInjectionOfMDBWithTopicReplyFromEjb");
            TestUtil.logMsg((String)"------------------------------------------");
            boolean passEjb = ejbclient.echo("testCDIInjectionOfMDBWithTopicReplyFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
            passEjb = ejbclient.echo("testCDIInjectionOfMDBWithTopicReplyFromEjb");
            if (!passEjb) {
                pass = false;
                TestUtil.logErr((String)"CDI injection test failed from Ejb");
            } else {
                TestUtil.logMsg((String)"CDI injection test passed from Ejb");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"CDI injection test failed from Ejb");
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("testCDIInjectionOfMDBWithTopicReplyFromEjb failed");
        }
    }
}

