/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.dbMeta.dbMeta10;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;

public class dbMetaClient10
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.dbMeta.dbMeta10";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private transient DatabaseMetaData dbmd = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private String dbName = null;
    private String dbUser = null;
    private String drManager = null;
    private String sCatalogName = null;
    private String sSchemaName = null;
    private String sPtable = null;
    private String sFtable = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        dbMetaClient10 theTests = new dbMetaClient10();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                this.dbName = p.getProperty("db1", "");
                this.dbUser = p.getProperty("user1", "");
                this.sPtable = p.getProperty("ptable", "TSTABLE1");
                this.sFtable = p.getProperty("ftable", "TSTABLE2");
                if (this.dbName.length() == 0) {
                    throw new EETest.Fault("Invalid db1  Database Name");
                }
                if (this.dbUser.length() == 0) {
                    throw new EETest.Fault("Invalid Login Id");
                }
                if (this.sPtable.length() == 0) {
                    throw new EETest.Fault("Invalid Primary table");
                }
                if (this.sFtable.length() == 0) {
                    throw new EETest.Fault("Invalid Foreign table");
                }
                if (this.drManager.length() == 0) {
                    throw new EETest.Fault("Invalid DriverManager Name");
                }
                int nLocdbname = this.dbName.indexOf(61);
                this.sSchemaName = this.dbUser;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.dbSch = new dbSchema();
                this.dbSch.createData(p, this.conn);
                this.dbmd = this.conn.getMetaData();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void testOthersUpdatesAreVisible2() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.othersUpdatesAreVisible(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.othersUpdatesAreVisible(1004);
            if (retValue) {
                this.msg.setMsg("Updates made by others are visible for TYPE_SCROLL_INSENSITIVE");
            } else {
                this.msg.setMsg("Updates made by others are not visible for TYPE_SCROLL_INSENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to othersUpdatesAreVisible2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to othersUpdatesAreVisible2 is Failed!");
        }
    }

    public void testOthersUpdatesAreVisible3() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.othersUpdatesAreVisible(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.othersUpdatesAreVisible(1005);
            if (retValue) {
                this.msg.setMsg("Updates made by others are visible for TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.setMsg("Updates made by others are not visible for TYPE_SCROLL_SENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to othersUpdatesAreVisible3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to othersUpdatesAreVisible3 is Failed!");
        }
    }

    public void testOthersDeletesAreVisible1() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.othersDeletesAreVisible(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.othersDeletesAreVisible(1003);
            if (retValue) {
                this.msg.setMsg("Deletes made by others are visible for TYPE_FORWARD_ONLY");
            } else {
                this.msg.setMsg("Deletes made by others are not visible for TYPE_FORWARD_ONLY");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to othersDeletesAreVisible1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to othersDeletesAreVisible1 is Failed!");
        }
    }

    public void testOthersDeletesAreVisible2() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.othersDeletesAreVisible(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.othersDeletesAreVisible(1004);
            if (retValue) {
                this.msg.setMsg("Deletes made by others are visible for TYPE_SCROLL_INSENSITIVE");
            } else {
                this.msg.setMsg("Deletes made by others are not visible for TYPE_SCROLL_INSENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to othersDeletesAreVisible2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to othersDeletesAreVisible2 is Failed!");
        }
    }

    public void testOthersDeletesAreVisible3() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.othersDeletesAreVisible(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.othersDeletesAreVisible(1005);
            if (retValue) {
                this.msg.setMsg("Deletes made by others are visible for TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.setMsg("Deletes made by others are not visible for TYPE_SCROLL_SENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to othersDeletesAreVisible3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to othersDeletesAreVisible3 is Failed!");
        }
    }

    public void testOthersInsertsAreVisible1() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.othersInsertsAreVisible(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.othersInsertsAreVisible(1003);
            if (retValue) {
                this.msg.setMsg("Inserts made by others are visible for TYPE_FORWARD_ONLY");
            } else {
                this.msg.setMsg("Inserts made by others are not visible for TYPE_FORWARD_ONLY");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to othersInsertsAreVisible1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to othersInsertsAreVisible1 is Failed!");
        }
    }

    public void testOthersInsertsAreVisible2() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.othersInsertsAreVisible(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.othersInsertsAreVisible(1004);
            if (retValue) {
                this.msg.setMsg("Inserts made by others are visible for TYPE_SCROLL_INSENSITIVE");
            } else {
                this.msg.setMsg("Inserts made by others are not visible for TYPE_SCROLL_INSENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to othersInsertsAreVisible2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to othersInsertsAreVisible2 is Failed!");
        }
    }

    public void testOthersInsertsAreVisible3() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.othersInsertsAreVisible(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.othersInsertsAreVisible(1005);
            if (retValue) {
                this.msg.setMsg("Inserts made by others are visible for TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.setMsg("Inserts made by others are not visible for TYPE_SCROLL_SENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to othersInsertsAreVisible3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to othersInsertsAreVisible3 is Failed!");
        }
    }

    public void testUpdatesAreDetected1() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.updatesAreDetected(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.updatesAreDetected(1003);
            if (retValue) {
                this.msg.setMsg("Visible row update can be detected for TYPE_FORWARD_ONLY");
            } else {
                this.msg.setMsg("Visible row update cannot be detected for TYPE_FORWARD_ONLY");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to updatesAreDetected1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to updatesAreDetected1 is Failed!");
        }
    }

    public void testUpdatesAreDetected2() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.updatesAreDetected(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.updatesAreDetected(1004);
            if (retValue) {
                this.msg.setMsg("Visible row update can be detected for TYPE_SCROLL_INSENSITIVE");
            } else {
                this.msg.setMsg("Visible row update cannot be detected for TYPE_SCROLL_INSENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to updatesAreDetected2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to updatesAreDetected2 is Failed!");
        }
    }

    public void testUpdatesAreDetected3() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.updatesAreDetected(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.updatesAreDetected(1005);
            if (retValue) {
                this.msg.setMsg("Visible row update can be detected for TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.setMsg("Visible row update cannot be detected for TYPE_SCROLL_SENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to updatesAreDetected3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to updatesAreDetected3 is Failed!");
        }
    }

    public void testDeletesAreDetected1() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.deletesAreDetected(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.deletesAreDetected(1003);
            if (retValue) {
                this.msg.setMsg("Visible row delete can be detected for TYPE_FORWARD_ONLY");
            } else {
                this.msg.setMsg("Visible row delete cannot be detected for TYPE_FORWARD_ONLY");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to deletesAreDetected1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to deletesAreDetected1 is Failed!");
        }
    }

    public void testDeletesAreDetected2() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.deletesAreDetected(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.deletesAreDetected(1004);
            if (retValue) {
                this.msg.setMsg("Visible row delete can be detected for TYPE_SCROLL_INSENSITIVE");
            } else {
                this.msg.setMsg("Visible row delete cannot be detected for TYPE_SCROLL_INSENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to deletesAreDetected2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to deletesAreDetected2 is Failed!");
        }
    }

    public void testDeletesAreDetected3() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.deletesAreDetected(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.deletesAreDetected(1005);
            if (retValue) {
                this.msg.setMsg("Visible row delete can be detected for TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.setMsg("Visible row delete cannot be detected for TYPE_SCROLL_SENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to deletesAreDetected3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to deletesAreDetected3 is Failed!");
        }
    }

    public void testInsertsAreDetected1() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.insertsAreDetected(TYPE_FORWARD_ONLY)");
            boolean retValue = this.dbmd.insertsAreDetected(1003);
            if (retValue) {
                this.msg.setMsg("Visible row insert can be detected for TYPE_FORWARD_ONLY");
            } else {
                this.msg.setMsg("Visible row insert cannot be detected for TYPE_FORWARD_ONLY");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to insertsAreDetected1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to insertsAreDetected1 is Failed!");
        }
    }

    public void testInsertsAreDetected2() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.insertsAreDetected(TYPE_SCROLL_INSENSITIVE)");
            boolean retValue = this.dbmd.insertsAreDetected(1004);
            if (retValue) {
                this.msg.setMsg("Visible row insert can be detected for TYPE_SCROLL_INSENSITIVE");
            } else {
                this.msg.setMsg("Visible row insert cannot be detected for TYPE_SCROLL_INSENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to insertsAreDetected2 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to insertsAreDetected2 is Failed!");
        }
    }

    public void testInsertsAreDetected3() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.insertsAreDetected(TYPE_SCROLL_SENSITIVE)");
            boolean retValue = this.dbmd.insertsAreDetected(1005);
            if (retValue) {
                this.msg.setMsg("Visible row insert can be detected for TYPE_SCROLL_SENSITIVE");
            } else {
                this.msg.setMsg("Visible row insert cannot be detected for TYPE_SCROLL_SENSITIVE");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to insertsAreDetected3 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to insertsAreDetected3 is Failed!");
        }
    }

    public void testGetUDTs() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.getUDTs");
            ResultSet oRet_ResultSet = this.dbmd.getUDTs(this.sCatalogName, this.sSchemaName, "%", null);
            String sRetStr = new String();
            sRetStr = "";
            this.msg.setMsg("Store all the type names returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(3) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getUDTs did not return any user defined types");
            } else {
                this.msg.setMsg("The type names returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getUDTs is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getUDTs is Failed!");
        }
    }

    public void testGetUDTs01() throws EETest.Fault {
        try {
            ResultSetMetaData rsmd = null;
            String[] sColumnNames = new String[]{"TYPE_CAT", "TYPE_SCHEM", "TYPE_NAME", "CLASS_NAME", "DATA_TYPE", "REMARKS"};
            boolean statusColumnMatch = true;
            boolean statusColumnCount = true;
            String sRetStr = new String();
            sRetStr = "";
            int iColumnNamesLength = sColumnNames.length;
            this.msg.setMsg("Calling DatabaseMetaData.getUDTs");
            this.msg.setMsg("invoke getUDTs method");
            ResultSet oRet_ResultSet = this.dbmd.getUDTs(this.sCatalogName, this.sSchemaName, "%", null);
            rsmd = oRet_ResultSet.getMetaData();
            int iCount = rsmd.getColumnCount();
            this.msg.setMsg("Minimum Column Count is:" + iColumnNamesLength);
            this.msg.setMsg("Comparing Column Lengths");
            if (iColumnNamesLength > iCount) {
                statusColumnCount = false;
            } else if (iColumnNamesLength < iCount) {
                iCount = iColumnNamesLength;
                statusColumnCount = true;
            } else {
                statusColumnCount = true;
            }
            this.msg.setMsg("Comparing Column Names...");
            while (iColumnNamesLength > 0) {
                if (!sColumnNames[iColumnNamesLength - 1].equalsIgnoreCase(rsmd.getColumnName(iCount))) {
                    statusColumnMatch = false;
                    break;
                }
                statusColumnMatch = true;
                --iCount;
                --iColumnNamesLength;
            }
            if (!statusColumnMatch && statusColumnCount) {
                this.msg.printTestError("Column names or order wrong.", "Call to getUDTs Failed!");
            }
            this.msg.setMsg("Store all the type names returned");
            while (oRet_ResultSet.next()) {
                sRetStr = sRetStr + oRet_ResultSet.getString(3) + ",";
            }
            if (sRetStr == "") {
                this.msg.setMsg("getUDTs did not return any user defined types");
            } else {
                this.msg.setMsg("The type names returned Are : " + sRetStr.substring(0, sRetStr.length() - 1));
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to getUDTs Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to getUDTs Failed!");
        }
    }

    public void testSupportsTransactionIsolationLevel1() throws EETest.Fault {
        try {
            this.msg.setMsg("Calling DatabaseMetaData.supportsTransactionIsolationLevel(TRANSACTION_NONE)");
            boolean retValue = this.dbmd.supportsTransactionIsolationLevel(0);
            if (retValue) {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_NONE) is supported");
            } else {
                this.msg.setMsg("supportsTransactionIsolationLevel(TRANSACTION_NONE) is not supported");
            }
            this.msg.printTestMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to supportsTransactionIsolationLevel1 is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to supportsTransactionIsolationLevel1 is Failed!");
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.dbSch.destroyData(this.conn);
            this.dbSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

