/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonarraytests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.ArrayBuilder;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.JsonIO;
import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsonarraytests.ArrayCommon;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonValue;

public class ArrayBuildRemove
extends ArrayCommon {
    ArrayBuildRemove() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonArrayBuilder API remove() methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonArrayBuilder API remove() methods added in JSON-P 1.1.");
        this.testRemove(result);
        this.testRemoveOutOfBounds(result);
        return result;
    }

    private void testRemove(TestResult result) {
        Object[] values;
        for (Object value : values = new Object[]{SimpleValues.OBJ_VALUE, "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true}) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - remove(int," + typeName + ")"));
            String json = "[]";
            JsonValue check = JsonIO.read("[]");
            JsonArrayBuilder builder = ArrayBuilder.add(Json.createArrayBuilder(), value);
            builder = this.updateOperationBuilder(builder, 0, null);
            JsonArray out = builder.build();
            if (!this.operationFailed(check, (JsonValue)out)) continue;
            result.fail("remove(" + typeName + ")", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString(check));
        }
    }

    private void testRemoveOutOfBounds(TestResult result) {
        Object[] values = new Object[]{SimpleValues.OBJ_VALUE, "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true};
        int[] indexes = new int[]{-1, 2, 3};
        for (Object value : values) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - remove(int," + typeName + ")"));
            String json = "[" + JsonValueType.toStringValue(value) + "]";
            JsonArrayBuilder builder = ArrayBuilder.add(Json.createArrayBuilder(), value);
            for (int index : indexes) {
                try {
                    builder = this.updateOperationBuilder(builder, index, null);
                    result.fail("remove(int," + typeName + ")", "Calling method with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException");
                }
                catch (IndexOutOfBoundsException e) {
                    TestUtil.logMsg((String)("    - Expected exception for index=" + index + ": " + e.getMessage()));
                }
                catch (Throwable t) {
                    result.fail("remove(int,(" + typeName + ")null)", "Calling method with with out of bounds index=" + index + " argument shall throw IndexOutOfBoundsException, not " + t.getClass().getSimpleName());
                }
            }
        }
    }

    @Override
    protected JsonArrayBuilder createArrayBuilder(Object value) {
        throw new UnsupportedOperationException("Method remove is not implemented.");
    }

    @Override
    protected JsonArrayBuilder createArrayBuilder(int index, Object value) {
        throw new UnsupportedOperationException("Method remove is not implemented.");
    }

    @Override
    protected JsonArrayBuilder updateOperationBuilder(JsonArrayBuilder builder, Object value) {
        throw new UnsupportedOperationException("Method remove is not implemented.");
    }

    @Override
    protected JsonArrayBuilder updateOperationBuilder(JsonArrayBuilder builder, int index, Object value) {
        return ArrayBuilder.remove(builder, index);
    }
}

