/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.sec.descriptors.servlet.basicSSL;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices12.sec.descriptors.servlet.basicSSL.HelloBasic;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceException;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;

public class Client
extends ServiceEETest {
    Service basicNoIdService;
    HelloBasic basicNoIdPort;
    Service basicAuthorizedIdService;
    HelloBasic basicAuthorizedIdPort;
    Service basicUnauthorizedIdService;
    HelloBasic basicUnauthorizedIdPort;
    Service basicInvalidIdService;
    HelloBasic basicInvalidIdPort;
    InitialContext ctx;
    String vehicle = null;
    private TSURL ctsurl = new TSURL();
    private String hostname = "localhost";
    private String PROTOCOL = "https";
    private String urlString = null;
    private int portnum = 8000;
    private static final String ENDPOINTURL = "/WSSecWarBasicSSL_web/jaxws/WSSecWarBasicSSL";

    private void getPorts() throws Exception {
        this.ctx = new InitialContext();
        TestUtil.logMsg((String)"JNDI lookup for basicNoIdService");
        this.basicNoIdService = (Service)this.ctx.lookup("java:comp/env/service/wssecWar/basicNoId");
        TestUtil.logMsg((String)"Get basicNoIdPort");
        this.basicNoIdPort = (HelloBasic)this.basicNoIdService.getPort(HelloBasic.class);
        TestUtil.logMsg((String)"basicNoIdPort obtained");
        BindingProvider bindingProvider = (BindingProvider)this.basicNoIdPort;
        Map map = bindingProvider.getRequestContext();
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
        TestUtil.logMsg((String)"JNDI lookup for basicAuthorizedIdService");
        this.basicAuthorizedIdService = (Service)this.ctx.lookup("java:comp/env/service/wssecWar/basicAuthorizedId");
        TestUtil.logMsg((String)"Get basicAuthorizedIdPort");
        this.basicAuthorizedIdPort = (HelloBasic)this.basicAuthorizedIdService.getPort(HelloBasic.class);
        TestUtil.logMsg((String)"basicAuthorizedIdPort obtained");
        bindingProvider = (BindingProvider)this.basicAuthorizedIdPort;
        map = bindingProvider.getRequestContext();
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
        TestUtil.logMsg((String)"JNDI lookup for basicUnauthorizedIdService");
        this.basicUnauthorizedIdService = (Service)this.ctx.lookup("java:comp/env/service/wssecWar/basicUnauthorizedId");
        TestUtil.logMsg((String)"Get basicUnauthorizedIdPort");
        this.basicUnauthorizedIdPort = (HelloBasic)this.basicUnauthorizedIdService.getPort(HelloBasic.class);
        TestUtil.logMsg((String)"basicUnauthorizedIdPort obtained");
        bindingProvider = (BindingProvider)this.basicUnauthorizedIdPort;
        map = bindingProvider.getRequestContext();
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
        TestUtil.logMsg((String)"JNDI lookup for basicInvalidIdService");
        this.basicInvalidIdService = (Service)this.ctx.lookup("java:comp/env/service/wssecWar/basicInvalidId");
        TestUtil.logMsg((String)"Get basicInvalidIdPort");
        this.basicInvalidIdPort = (HelloBasic)this.basicInvalidIdService.getPort(HelloBasic.class);
        TestUtil.logMsg((String)"basicInvalidIdPort obtained");
        bindingProvider = (BindingProvider)this.basicInvalidIdPort;
        map = bindingProvider.getRequestContext();
        TestUtil.logMsg((String)("Setting the target endpoint address on WS port: " + this.urlString));
        map.put("jakarta.xml.ws.service.endpoint.address", this.urlString);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnum = Integer.parseInt(p.getProperty("securedWebServicePort"));
            this.vehicle = p.getProperty("vehicle");
            this.urlString = this.ctsurl.getURLString(this.PROTOCOL, this.hostname, this.portnum, ENDPOINTURL);
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            this.getPorts();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        TestUtil.logMsg((String)"setup ok");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }

    private void printSeperationLine() {
        TestUtil.logMsg((String)"---------------------------");
    }

    public void secWarBasicNoId() throws EETest.Fault {
        TestUtil.logMsg((String)"SecWarBasicNoId");
        try {
            if (this.vehicle.equals("wsappclient")) {
                TestUtil.logMsg((String)"Skipping secWarBasicNoId test for appclient vehicle");
                return;
            }
            String ret1 = this.basicNoIdPort.sayHelloBasic("secWarBasicNoId");
            TestUtil.logMsg((String)("SecWarBasicNoId failed: unexpected return value " + ret1));
            throw new EETest.Fault("SecWarBasicNoId failed");
        }
        catch (WebServiceException ex) {
            TestUtil.logMsg((String)"SecWarBasicNoId success: got expected WebServiceException");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test SecWarBasicNoId failed: got exception " + t.toString()));
            throw new EETest.Fault("SecWarBasicNoId failed");
        }
    }

    public void secWarBasicUnauthorizedId() throws EETest.Fault {
        TestUtil.logMsg((String)"SecWarBasicUnauthorizedId");
        try {
            String ret1 = this.basicUnauthorizedIdPort.sayHelloBasic("secWarBasicUnauthorizedId");
            TestUtil.logMsg((String)("SecWarBasicUnauthorizedId failed: unexpected return value " + ret1));
            throw new EETest.Fault("SecWarBasicUnauthorizedId failed");
        }
        catch (WebServiceException ex) {
            TestUtil.logMsg((String)"SecWarBasicUnauthorizedId success: got expected WebServiceException");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test SecWarBasicUnauthorizedId failed: got exception " + t.toString()));
            throw new EETest.Fault("SecWarBasicUnauthorizedId failed");
        }
    }

    public void secWarBasicInvalidId() throws EETest.Fault {
        TestUtil.logMsg((String)"SecWarBasicInvalidId");
        try {
            if (this.vehicle.equals("wsappclient")) {
                TestUtil.logMsg((String)"Skipping secWarBasicInvalidId test for appclient vehicle");
                return;
            }
            String ret1 = this.basicInvalidIdPort.sayHelloBasic("secWarBasicInvalidId");
            TestUtil.logMsg((String)("SecWarBasicInvalidId failed: unexpected return value " + ret1));
            throw new EETest.Fault("SecWarBasicInvalidId failed");
        }
        catch (WebServiceException ex) {
            TestUtil.logMsg((String)"SecWarBasicInvalidId success: got WebServiceException");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test SecWarBasicInvalidId failed: got exception " + t.toString()));
            throw new EETest.Fault("SecWarBasicInvalidId failed");
        }
    }

    public void secWarBasicAuthorizedId() throws EETest.Fault {
        TestUtil.logMsg((String)"SecWarBasicAuthorizedId");
        try {
            String ret1 = this.basicAuthorizedIdPort.sayHelloBasic("secWarBasicAuthorizedId");
            if (!ret1.equals("'secWarBasicAuthorizedId' from HelloBasicImpl!")) {
                TestUtil.logMsg((String)("test secWarBasicAuthorized failed: return value: " + ret1));
                throw new EETest.Fault("SecWarBasicAuthorized failed");
            }
            TestUtil.logMsg((String)"SecWarBasicAuthorizedId passed");
        }
        catch (Throwable t) {
            TestUtil.logMsg((String)("test SecWarBasicAuthorizedId failed: got exception " + t.toString()));
            throw new EETest.Fault("SecWarBasicAuthorizedId failed");
        }
    }
}

