/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.sharedclients;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.sharedclients.HttpClient;
import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.SOAPConnectionFactory;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;

public class SaajClient
implements Serializable {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private SOAPConnectionFactory connectionFactory;
    private MessageFactory messageFactory;
    private MimeHeaders headers;
    private HttpClient httpClient;
    private String url;
    private Charset cs;
    private boolean SoapConnectionFactorySupported = true;

    public SaajClient() throws EETest.Fault {
        try {
            this.messageFactory = MessageFactory.newInstance();
            this.httpClient = new HttpClient();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Unable to create message factory", e);
        }
        try {
            this.connectionFactory = SOAPConnectionFactory.newInstance();
        }
        catch (UnsupportedOperationException e) {
            this.SoapConnectionFactorySupported = false;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Unable to create connection factory", e);
        }
    }

    public Charset getCharset() {
        return this.cs;
    }

    public void setCharset(Charset cs) {
        this.cs = cs;
    }

    private String getCharsetAsName() {
        if (this.cs == null) {
            return DEFAULT_CHARSET;
        }
        return this.cs.name().toUpperCase();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private SOAPMessage createSOAPMessage(InputStream is) {
        SOAPMessage message = null;
        this.headers = new MimeHeaders();
        this.headers.addHeader("Content-Type", "text/xml; charset=" + this.getCharsetAsName());
        try {
            message = this.messageFactory.createMessage(this.headers, is);
            message.saveChanges();
        }
        catch (Exception e) {
            message = null;
        }
        return message;
    }

    private SOAPMessage sendAsHTTPMessage(InputStream is) throws IOException {
        this.httpClient.setUrl(this.url);
        this.httpClient.setCharset(this.getCharset());
        InputStream response = this.httpClient.makeRequest(is);
        return this.createSOAPMessage(response);
    }

    private ByteArrayOutputStream getInputStreamAsOutputStream(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        do {
            if ((length = is.read(buffer)) <= 0) continue;
            baos.write(buffer, 0, length);
        } while (length > 0);
        return baos;
    }

    public SOAPMessage makeRequest(InputStream messageContent) throws SOAPException, IOException {
        if (this.SoapConnectionFactorySupported) {
            ByteArrayOutputStream baos = this.getInputStreamAsOutputStream(messageContent);
            ByteArrayInputStream bais1 = new ByteArrayInputStream(baos.toByteArray());
            ByteArrayInputStream bais2 = new ByteArrayInputStream(baos.toByteArray());
            SOAPMessage message = this.createSOAPMessage(bais1);
            if (message != null) {
                SOAPMessage msg = null;
                try {
                    TestUtil.logMsg((String)"***** makeRequest via SAAJ first *****");
                    msg = this.connectionFactory.createConnection().call(message, (Object)this.url);
                }
                catch (Exception e) {
                    TestUtil.logMsg((String)"***** makeRequest via HTTP second *****");
                    msg = this.sendAsHTTPMessage(bais2);
                }
                return msg;
            }
            return this.sendAsHTTPMessage(bais2);
        }
        return this.sendAsHTTPMessage(messageContent);
    }

    public void logMessageInHarness(SOAPMessage message) {
    }
}

