/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefAndAddressingCombinedTest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefAndAddressingCombinedTest.Echo;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefAndAddressingCombinedTest.EchoService;
import com.sun.ts.tests.webservices13.ejb.annotations.WSEjbWSRefAndAddressingCombinedTest.EjbClientIF;
import jakarta.annotation.PostConstruct;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.Stateless;
import jakarta.xml.ws.BindingProvider;
import jakarta.xml.ws.Holder;
import jakarta.xml.ws.WebServiceRef;
import jakarta.xml.ws.soap.Addressing;
import java.util.Map;
import java.util.Properties;

@Stateless(name="WSEjbWSRefAndAddressingCombinedTestClntBean")
@Remote(value={EjbClientIF.class})
public class EjbClient
implements EjbClientIF {
    private static final boolean debug = false;
    @Addressing
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestdefaultechoport", type=Echo.class, value=EchoService.class)
    Echo defaultEchoPort = null;
    @Addressing(enabled=true)
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestenabledechoport", type=Echo.class, value=EchoService.class)
    Echo enabledEchoPort = null;
    @Addressing(enabled=true, required=true)
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestrequiredechoport", type=Echo.class, value=EchoService.class)
    Echo requiredEchoPort = null;
    @Addressing(enabled=false)
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestdisabledechoport", type=Echo.class, value=EchoService.class)
    Echo disabledEchoPort = null;
    @WebServiceRef(name="service/wsejbwsrefandaddrcombtestservice")
    EchoService service = null;

    @PostConstruct
    public void postConstruct() {
        System.out.println("EjbClient:postConstruct()");
        System.out.println("EjbClient DEBUG: service=" + (Object)((Object)this.service));
        System.out.println("EjbClient DEBUG: defaultEchoPort=" + this.defaultEchoPort);
        System.out.println("EjbClient DEBUG: enabledEchoPort=" + this.enabledEchoPort);
        System.out.println("EjbClient DEBUG: requiredEchoPort=" + this.requiredEchoPort);
        System.out.println("EjbClient DEBUG: disabledEchoPort=" + this.disabledEchoPort);
        if (this.service == null || this.defaultEchoPort == null || this.enabledEchoPort == null || this.requiredEchoPort == null || this.disabledEchoPort == null) {
            throw new EJBException("postConstruct failed: injection failure");
        }
    }

    @Override
    public void init(Properties p) {
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("init: failed");
        }
    }

    @Override
    public boolean echo(String string, String testName) {
        if (testName.equals("VerifyAddrHeadersExistForRequiredEchoPort")) {
            return this.VerifyAddrHeadersExistForRequiredEchoPort();
        }
        if (testName.equals("VerifyAddrHeadersDoNotExistForDisabledEchoPort")) {
            return this.VerifyAddrHeadersDoNotExistForDisabledEchoPort();
        }
        return this.VerifyAddrHeadersMayExistForEnabledEchoPort();
    }

    private String getTargetEndpointAddress(Object stub) throws Exception {
        BindingProvider bindingprovider = (BindingProvider)stub;
        Map context = bindingprovider.getRequestContext();
        String url = (String)context.get("jakarta.xml.ws.service.endpoint.address");
        return url;
    }

    private boolean VerifyAddrHeadersExistForRequiredEchoPort() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersExistForRequiredEchoPort");
            Holder testName = new Holder((Object)"VerifyAddrHeadersExistForRequiredEchoPort");
            this.requiredEchoPort.echo("Echo from EjbClient on requiredEchoPort", (Holder<String>)testName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean VerifyAddrHeadersDoNotExistForDisabledEchoPort() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MUST NOT be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersDoNotExistForDisabledEchoPort");
            Holder testName = new Holder((Object)"VerifyAddrHeadersDoNotExistForDisabledEchoPort");
            this.disabledEchoPort.echo("Echo from EjbClient on disabledEchoPort", (Holder<String>)testName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean VerifyAddrHeadersMayExistForEnabledEchoPort() {
        try {
            TestUtil.logMsg((String)"EjbClient invoking EchoService echo() method");
            TestUtil.logMsg((String)"Addressing headers MAY be present on the SOAPRequest/SOAPResponse");
            TestUtil.logMsg((String)"VerifyAddrHeadersMayExistForEnabledEchoPort");
            Holder testName = new Holder((Object)"VerifyAddrHeadersMayExistForEnabledEchoPort");
            this.enabledEchoPort.echo("Echo from EjbClient on enabledEchoPort", (Holder<String>)testName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

