/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.sec.cmp20.common;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.sec.cmp20.common.SecTestLocal;
import com.sun.ts.tests.ejb.ee.sec.cmp20.common.SecTestLocalHome;
import com.sun.ts.tests.ejb.ee.sec.cmp20.common.SecTestRoleRefLocal;
import com.sun.ts.tests.ejb.ee.sec.cmp20.common.SecTestRoleRefLocalHome;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.RemoveException;
import java.util.Properties;

public class lTestEJB
implements EntityBean {
    private static final String ejb1name = "java:comp/env/ejb/SecTestLocal";
    private static final String ejb2name = "java:comp/env/ejb/SecTestRoleRefLocal";
    private SecTestLocalHome ejb1home = null;
    private SecTestLocal ejb1ref = null;
    private SecTestRoleRefLocalHome ejb2home = null;
    private SecTestRoleRefLocal ejb2ref = null;
    private EntityContext ectx = null;
    private boolean newTable = true;
    public String BRAND_NAME;
    public Integer KEY_ID;
    public float PRICE;
    private static final String UserNameProp = "user";
    private static final String UserPasswordProp = "password";
    private String username = "";
    private String password = "";
    private TSNamingContext nctx = null;

    public void lTestEJB() throws CreateException {
        TestUtil.logTrace((String)"TestEJB ejbCreate OK!");
    }

    public Integer ejbCreate(Properties p, boolean newTable, int KEY_ID, String BRAND_NAME, float PRICE) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        try {
            TestUtil.init((Properties)p);
            this.KEY_ID = new Integer(KEY_ID);
            this.BRAND_NAME = BRAND_NAME;
            this.PRICE = PRICE;
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return this.KEY_ID;
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbPostCreate(Properties p, boolean newTable, int KEY_ID, String BRAND_NAME, float PRICE) {
        TestUtil.logTrace((String)"In ejbPostCreate !!");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public void setEntityContext(EntityContext sc) {
        this.ectx = sc;
        try {
            this.nctx = new TSNamingContext();
            this.ejb1home = (SecTestLocalHome)this.nctx.lookup(ejb1name);
            this.ejb2home = (SecTestRoleRefLocalHome)this.nctx.lookup(ejb2name);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public boolean IsCallerB1(String caller) {
        String name = this.ectx.getCallerPrincipal().getName();
        TestUtil.logMsg((String)("IsCallerB1: " + name));
        return name.indexOf(caller) >= 0;
    }

    public boolean IsCallerB2(String caller, Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.IsCaller(caller);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    public boolean InRole(String role, Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    public boolean EjbNotAuthz(Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            this.ejb1ref.EjbNotAuthz();
            TestUtil.logErr((String)"Method call did not generate an expected java.rmi.RemoteException");
            this.ejb1ref.remove();
            return false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)"Caught jakarta.ejb.EJBException as expected");
            this.cleanup(this.ejb1ref);
            return true;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    private void cleanup(SecTestLocal ejbref) {
        if (ejbref != null) {
            try {
                ejbref.remove();
                ejbref = null;
            }
            catch (Exception ex) {
                TestUtil.logErr((String)"Cannot remove the bean: ", (Throwable)ex);
            }
        } else {
            TestUtil.logMsg((String)"ejbref == null");
        }
    }

    public boolean EjbIsAuthz(Properties props) {
        TestUtil.logMsg((String)"Starting Caller authorization test");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbIsAuthz();
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
        return true;
    }

    public boolean EjbSecRoleRef(String role, Properties props) {
        TestUtil.logMsg((String)"Starting Security role reference positive test");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    public boolean EjbSecRoleRef1(String role, Properties props) {
        TestUtil.logMsg((String)"Starting Security role reference negative test");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.cleanup(this.ejb1ref);
            return false;
        }
    }

    public boolean EjbSecRoleRefScope(String role, Properties props) {
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbSecRoleRef(role);
            this.ejb1ref.remove();
            if (!result) {
                return false;
            }
            this.ejb2ref = this.ejb2home.create(1, "coffee-1", 1.0f);
            result = this.ejb2ref.EjbSecRoleRefScope(role);
            this.ejb2ref.remove();
            return !result;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            return false;
        }
    }

    public boolean EjbOverloadedSecRoleRefs(String role1, String role2, Properties props) {
        TestUtil.logMsg((String)"Starting Overloaded security role references test");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1);
            this.ejb1ref.remove();
            if (!result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref) returned false");
                return false;
            }
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            result = this.ejb1ref.EjbOverloadedSecRoleRefs(role1, role2);
            this.ejb1ref.remove();
            if (result) {
                TestUtil.logErr((String)"EjbOverloadedSecRoleRefs(emp_secrole_ref,mgr_secrole_ref) returned true");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("EjbOverloadedSecRoleRefs(" + role1 + "," + role2 + ") failed with Exception: "), (Throwable)e);
            return false;
        }
    }

    public boolean checktest1(Properties props) {
        TestUtil.logMsg((String)"Starting unchecked test1");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.checktest1();
            this.ejb1ref.remove();
            return result;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"checktest1 failed with Exception: ", (Throwable)e);
            return false;
        }
    }

    public boolean excludetest1(Properties props) {
        TestUtil.logMsg((String)"Starting exclude test1");
        try {
            this.ejb1ref = this.ejb1home.create(1, "coffee-1", 1.0f);
            boolean result = this.ejb1ref.excludetest1();
            this.ejb1ref.remove();
            return false;
        }
        catch (EJBException ex) {
            TestUtil.logMsg((String)"Got expected exception.");
            this.cleanup(this.ejb1ref);
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"excludetest1 failed with Exception: ", (Throwable)e);
            return false;
        }
    }
}

