/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.jpa22.repeatable.namednativequery;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.jpa22.repeatable.namednativequery.Coffee;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final long serialVersionUID = 22L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            TestUtil.logTrace((String)"Cleanup data");
            this.removeTestData();
            TestUtil.logTrace((String)"Create Test data");
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTest() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin findTest1");
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            for (int i = 1; i != 5; ++i) {
                Coffee coffeeFound = (Coffee)this.getEntityManager().find(Coffee.class, (Object)i);
                this.assertTrue(coffeeFound != null, "cofee id = " + i + " not found");
                this.assertTrue(coffeeFound.getId() == i, "Unexpected id found:" + coffeeFound.getId() + " expected " + i);
            }
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("findTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            TestUtil.logTrace((String)"createTestData");
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create 5 Coffees");
            Coffee[] cRef = new Coffee[]{new Coffee(Integer.valueOf(1), "hazelnut", 1.0f), new Coffee(Integer.valueOf(2), "vanilla creme", 2.0f), new Coffee(Integer.valueOf(3), "decaf", 3.0f), new Coffee(Integer.valueOf(4), "breakfast blend", 4.0f), new Coffee(Integer.valueOf(5), "mocha", 5.0f)};
            TestUtil.logTrace((String)"Start to persist coffees ");
            for (Coffee c : cRef) {
                if (c == null) continue;
                this.getEntityManager().persist((Object)c);
                TestUtil.logTrace((String)("persisted coffee " + c));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private void assertTrue(boolean b, String message) throws EETest.Fault {
        if (!b) {
            throw new EETest.Fault(message);
        }
    }
}

