/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlTitle;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;

@JsxClass(domClass=HtmlTitle.class)
public class HTMLTitleElement
extends HTMLElement {
    @Override
    @JsxGetter
    public String getText() {
        DomNode firstChild = this.getDomNodeOrDie().getFirstChild();
        if (firstChild != null) {
            return firstChild.getNodeValue();
        }
        return "";
    }

    @JsxSetter
    public void setText(String text) {
        HtmlElement htmlElement = this.getDomNodeOrDie();
        DomNode firstChild = htmlElement.getFirstChild();
        if (firstChild == null) {
            firstChild = new DomText(htmlElement.getPage(), text);
            htmlElement.appendChild(firstChild);
        } else {
            firstChild.setNodeValue(text);
        }
    }

    @Override
    @JsxSetter
    public void setInnerHTML(Object value) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_INNER_HTML_READONLY_FOR_SOME_TAGS)) {
            throw Context.reportRuntimeError((String)"innerHTML is read-only for tag 'title'");
        }
        super.setInnerHTML(value);
    }
}

