/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.unsignedbyte.minexclusive.minexclusive_1;

import jakarta.xml.bind.*;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minExclusive1_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minExclusive1_GetSetCTTests test = new minExclusive1_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "minExclusive-1-1.xml", "minExclusive-1-2.xml", "minExclusive-1-3.xml",
            "minExclusive-1-4.xml", "minExclusive-1-5.xml"
        };
        short[] expectedValues = {(short)1, (short)198, (short)61, (short)216, (short)255};
        short[] anExpectedValues = {(short)255, (short)1, (short)61, (short)255, (short)254};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<Short> elemObj = (JAXBElement<Short>)unmarshal(xmlDocNames[i]);
            if (elemObj.getValue() != expectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (elemObj.getValue() != anExpectedValues[i]){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        short[] setValues = {(short)1, (short)198, (short)61, (short)216, (short)255};
        short[] anSetValues = {(short)255, (short)1, (short)61, (short)255, (short)254};

        JAXBElement<Short> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<Short>)(new ObjectFactory()).createNISTSchemaUnsignedByteMinExclusive1(setValues[i]);
            
            if (elemObj.getValue() != setValues[i]){
                return Status.failed("dynamically created JAXBElement<Short>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (elemObj.getValue() != anSetValues[i]){
                return Status.failed("dynamically created JAXBElement<Short>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

