/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.ManagedExecutors;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.api.common.CallableTask;
import com.sun.ts.tests.concurrency.api.common.RunnableTask;
import com.sun.ts.tests.concurrency.api.common.Util;
import com.sun.ts.tests.concurrency.api.common.managedTaskListener.ListenerEvent;
import com.sun.ts.tests.concurrency.api.common.managedTaskListener.ManagedTaskListenerImpl;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Client
extends ServiceEETest
implements Serializable {
    private static final String MANAGED_EXECUTOR_SVC_JNDI_NAME = "java:comp/DefaultManagedExecutorService";
    private static final String MANAGED_THREAD_FACTORY_JNDI_NAME = "java:comp/DefaultManagedThreadFactory";
    private static final int TASK_MAX_WAIT_SECONDS = 10;
    private static final long LISTENER_MAX_WAIT_MILLIS = 3000L;
    private static final int LISTENER_POOL_INTERVAL_MILLIS = 100;
    private static final String ENV_ENTRY_JNDI_NAME = "java:comp/env/StringValue";
    private static final String ENV_ENTRY_VALUE = "something";
    private ManagedExecutorService managedExecutorSvc;
    private ManagedThreadFactory managedThreadFactory;
    private ManagedTaskListenerImpl managedTaskListener;
    private boolean shutdown = true;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            this.managedExecutorSvc = (ManagedExecutorService)ctx.lookup(MANAGED_EXECUTOR_SVC_JNDI_NAME);
            this.managedThreadFactory = (ManagedThreadFactory)ctx.lookup(MANAGED_THREAD_FACTORY_JNDI_NAME);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                TestUtil.logErr((String)"Exception: ", (Throwable)e);
                throw new EETest.Fault("Setup failed:", e);
            }
        }
        this.managedTaskListener = new ManagedTaskListenerImpl();
    }

    public void cleanup() throws EETest.Fault {
        this.managedTaskListener.clearEvents();
        TestUtil.logTrace((String)"cleanup");
    }

    public void IsCurrentThreadShutdown() throws EETest.Fault {
        Thread createdThread = this.managedThreadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                Client.this.shutdown = ManagedExecutors.isCurrentThreadShutdown();
            }
        });
        Future<?> future = Executors.newSingleThreadExecutor().submit(createdThread);
        this.waitForTaskComplete(future);
        if (this.shutdown) {
            throw new EETest.Fault("IsCurrentThreadShutdown failed because shutdown is set to be true when running job");
        }
    }

    public void IsCurrentThreadShutdown_ManageableThread() throws EETest.Fault {
        Thread createdThread = this.managedThreadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                Client.this.shutdown = ManagedExecutors.isCurrentThreadShutdown();
            }
        });
        Future<?> future = Executors.newSingleThreadExecutor((ThreadFactory)this.managedThreadFactory).submit(createdThread);
        this.waitForTaskComplete(future);
        if (this.shutdown) {
            throw new EETest.Fault("IsCurrentThreadShutdown failed because shutdown is set to be true when running job");
        }
    }

    public void ManageRunnableTaskWithTaskListener() throws EETest.Fault {
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = this.managedExecutorSvc.submit(taskWithListener);
        this.assertTaskAndListenerComplete(futureResult, runnableTask);
    }

    public void ManageRunnableTaskWithNullArg() throws EETest.Fault {
        boolean pass = false;
        Runnable nullTask = null;
        try {
            ManagedExecutors.managedTask(nullTask, (ManagedTaskListener)this.managedTaskListener);
        }
        catch (IllegalArgumentException e) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ManageRunnableTaskWithNullArg failed to get expected exception");
        }
    }

    public void ManageRunnableTaskWithTaskListenerAndMap() throws EETest.Fault {
        ManagedTask managedTask;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        RunnableTask runnableTask = this.createRunnableTask();
        Runnable task = ManagedExecutors.managedTask((Runnable)runnableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        boolean pass = false;
        if (task instanceof ManagedTask && (managedTask = (ManagedTask)task).getExecutionProperties().get("key") == "value") {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("ManageRunnableTaskWithTaskListenerAndMap failed to get expected property");
        }
        this.assertTaskAndListenerComplete(this.managedExecutorSvc.submit(task), runnableTask);
    }

    public void ManageRunnableTaskWithMapAndNullArg() throws EETest.Fault {
        boolean pass = false;
        Runnable nullTask = null;
        HashMap properties = new HashMap();
        try {
            ManagedExecutors.managedTask(nullTask, properties, (ManagedTaskListener)this.managedTaskListener);
        }
        catch (IllegalArgumentException e) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ManageRunnableTaskWithMapAndNullArg failed to get expected exception");
        }
    }

    public void ManageCallableTaskWithTaskListener() throws EETest.Fault {
        String expectedResultStr = "expected something";
        CallableTask<String> callableTask = this.createCallableTask(expectedResultStr);
        Callable taskWithListener = ManagedExecutors.managedTask(callableTask, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = this.managedExecutorSvc.submit(taskWithListener);
        this.assertTaskAndListenerComplete(expectedResultStr, futureResult, callableTask);
    }

    public void ManageCallableTaskWithNullArg() throws EETest.Fault {
        boolean pass = false;
        Callable nullTask = null;
        try {
            ManagedExecutors.managedTask(nullTask, (ManagedTaskListener)this.managedTaskListener);
        }
        catch (IllegalArgumentException e) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ManageCallableTaskWithNullArg failed to get expected exception");
        }
    }

    public void ManageCallableTaskWithTaskListenerAndMap() throws EETest.Fault {
        ManagedTask managedTask;
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("key", "value");
        properties.put("jakarta.enterprise.concurrent.IDENTITY_NAME", "id");
        String expectedResultStr = "expected something";
        CallableTask<String> callableTask = this.createCallableTask(expectedResultStr);
        Callable task = ManagedExecutors.managedTask(callableTask, properties, (ManagedTaskListener)this.managedTaskListener);
        boolean pass = false;
        if (task instanceof ManagedTask && (managedTask = (ManagedTask)task).getExecutionProperties().get("key") == "value") {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("ManageCallableTaskWithTaskListenerAndMap failed to get expected property");
        }
        this.assertTaskAndListenerComplete(expectedResultStr, this.managedExecutorSvc.submit(task), callableTask);
    }

    public void ManageCallableTaskWithMapAndNullArg() throws EETest.Fault {
        boolean pass = false;
        Callable nullTask = null;
        HashMap properties = new HashMap();
        try {
            ManagedExecutors.managedTask(nullTask, properties, (ManagedTaskListener)this.managedTaskListener);
        }
        catch (IllegalArgumentException e) {
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception Caught", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("ManageTaskWithMapAndNullArg failed");
        }
    }

    private void assertTaskAndListenerComplete(Future<?> future, RunnableTask runnableTask) throws EETest.Fault {
        this.waitForTaskComplete(future);
        this.assertListenerComplete(runnableTask);
    }

    private void assertTaskAndListenerComplete(String expectedResult, Future<String> future, CallableTask<?> callableTask) throws EETest.Fault {
        String result = this.waitForTaskComplete(future);
        if (!expectedResult.endsWith(result)) {
            throw new EETest.Fault("Task return different value with expected one.");
        }
        this.assertListenerComplete(callableTask);
    }

    private <T> T waitForTaskComplete(Future<T> future) throws EETest.Fault {
        return Util.waitForTaskComplete(future, 10);
    }

    private void assertListenerComplete(RunnableTask task) throws EETest.Fault {
        Util.waitForListenerComplete(this.managedTaskListener, 3000L, 100);
        if (!(this.managedTaskListener.eventCalled(ListenerEvent.SUBMITTED) && this.managedTaskListener.eventCalled(ListenerEvent.STARTING) && this.managedTaskListener.eventCalled(ListenerEvent.DONE))) {
            throw new EETest.Fault("TaskListener is not completely executed.");
        }
    }

    private RunnableTask createRunnableTask() {
        return new RunnableTask(ENV_ENTRY_JNDI_NAME, ENV_ENTRY_VALUE, this.getClass().getName());
    }

    private CallableTask<String> createCallableTask(String expectedReturnValue) {
        return new CallableTask<String>(ENV_ENTRY_JNDI_NAME, ENV_ENTRY_VALUE, this.getClass().getName(), expectedReturnValue);
    }
}

