/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsongeneratortests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.jsongeneratortests.Generator;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import com.sun.ts.tests.jsonp.common.MyBufferedWriter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private void generateSimpleJsonObject(JsonGenerator generator) {
        try {
            generator.writeStartObject().writeStartObject("object").write("string", "string").write("number", 1).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeEnd().writeStartArray("array").write("string").write(1).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeEnd().writeEnd();
            generator.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e));
        }
    }

    private void generateSimpleJsonArray(JsonGenerator generator) {
        try {
            generator.writeStartArray().writeStartObject().write("string", "string").write("number", 1).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeEnd().writeStartArray().write("string").write(1).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeEnd().writeEnd();
            generator.close();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e));
        }
    }

    private String generateJsonObject() {
        try {
            this.logMsg("Generate a JsonObject");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("intMin", Integer.MIN_VALUE).write("intMax", Integer.MAX_VALUE).write("longMin", Long.MIN_VALUE).write("longMax", Long.MAX_VALUE).write("doubleMin", Double.MIN_VALUE).write("doubleMax", Double.MAX_VALUE).write("bigInteger", new BigInteger(Integer.toString(Integer.MAX_VALUE))).write("bigDecimal", BigDecimal.valueOf(Integer.MIN_VALUE)).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("number", 100).write("true", true).write("false", false).writeNull("null").writeStartObject("object").write("name", "value").write("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).write("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar()).writeEnd().writeStartArray("array").write("one").write("two").write((JsonValue)JSONP_Util.buildJsonObjectFooBar()).write((JsonValue)JSONP_Util.buildJsonArrayFooBar()).writeEnd().writeEnd().writeStartArray("array").write("string").write(Integer.MAX_VALUE).write(Long.MAX_VALUE).write(Double.MAX_VALUE).write(new BigInteger(Integer.toString(Integer.MAX_VALUE))).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("name", "value").writeEnd().writeStartArray().write("one").write("two").writeEnd().writeEnd().write("asciiChars", "\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").writeEnd();
            generator.close();
            return sWriter.toString();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e));
            return null;
        }
    }

    private JsonObject buildJsonObject() {
        try {
            this.logMsg("Build a JsonObject");
            JsonObject jsonObject = Json.createObjectBuilder().add("emptyString", "").add("emptyArray", Json.createArrayBuilder()).add("emptyObject", Json.createObjectBuilder()).add("string", "string").add("intMin", Integer.MIN_VALUE).add("intMax", Integer.MAX_VALUE).add("longMin", Long.MIN_VALUE).add("longMax", Long.MAX_VALUE).add("doubleMin", Double.MIN_VALUE).add("doubleMax", Double.MAX_VALUE).add("bigInteger", new BigInteger(Integer.toString(Integer.MAX_VALUE))).add("bigDecimal", BigDecimal.valueOf(Integer.MIN_VALUE)).add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("object", Json.createObjectBuilder().add("emptyString", "").add("emptyArray", Json.createArrayBuilder()).add("emptyObject", Json.createObjectBuilder()).add("string", "string").add("number", 100).add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("object", Json.createObjectBuilder().add("name", "value").add("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).add("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar())).add("array", Json.createArrayBuilder().add("one").add("two").add((JsonValue)JSONP_Util.buildJsonObjectFooBar()).add((JsonValue)JSONP_Util.buildJsonArrayFooBar()))).add("array", Json.createArrayBuilder().add("string").add(Integer.MAX_VALUE).add(Long.MAX_VALUE).add(Double.MAX_VALUE).add(new BigInteger(Integer.toString(Integer.MAX_VALUE))).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add(Json.createObjectBuilder().add("name", "value")).add(Json.createArrayBuilder().add("one").add("two"))).add("asciiChars", "\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").build();
            return jsonObject;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e));
            return null;
        }
    }

    private String generateJsonArray() {
        try {
            this.logMsg("Generate a JsonArray");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("").writeStartArray().writeEnd().writeStartObject().writeEnd().write("string").write(Integer.MIN_VALUE).write(Integer.MAX_VALUE).write(Long.MIN_VALUE).write(Long.MAX_VALUE).write(Double.MIN_VALUE).write(Double.MAX_VALUE).write(new BigInteger(new Integer(Integer.MAX_VALUE).toString())).write(BigDecimal.valueOf(Integer.MIN_VALUE)).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("number", 100).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("name", "value").write("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).write("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar()).writeEnd().writeStartArray("array").write("one").write("two").write((JsonValue)JSONP_Util.buildJsonObjectFooBar()).write((JsonValue)JSONP_Util.buildJsonArrayFooBar()).writeEnd().writeEnd().writeStartArray().write("string").write(Integer.MAX_VALUE).write(Long.MAX_VALUE).write(Double.MAX_VALUE).write(new BigInteger(new Integer(Integer.MAX_VALUE).toString())).write(true).write(false).writeNull().writeStartObject().write("name", "value").writeEnd().writeStartArray().write("one").write("two").writeEnd().writeEnd().write("\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").writeEnd();
            generator.close();
            return sWriter.toString();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e));
            return null;
        }
    }

    private JsonArray buildJsonArray() {
        try {
            this.logMsg("Build a JsonArray");
            JsonArray jsonArray = Json.createArrayBuilder().add("").add(Json.createArrayBuilder()).add(Json.createObjectBuilder()).add("string").add(Integer.MIN_VALUE).add(Integer.MAX_VALUE).add(Long.MIN_VALUE).add(Long.MAX_VALUE).add(Double.MIN_VALUE).add(Double.MAX_VALUE).add(new BigInteger(new Integer(Integer.MAX_VALUE).toString())).add(BigDecimal.valueOf(Integer.MIN_VALUE)).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add(Json.createObjectBuilder().add("emptyString", "").add("emptyArray", Json.createArrayBuilder()).add("emptyObject", Json.createObjectBuilder()).add("string", "string").add("number", 100).add("true", JsonValue.TRUE).add("false", JsonValue.FALSE).add("null", JsonValue.NULL).add("object", Json.createObjectBuilder().add("name", "value").add("objectFooBar", (JsonValue)JSONP_Util.buildJsonObjectFooBar()).add("arrayFooBar", (JsonValue)JSONP_Util.buildJsonArrayFooBar())).add("array", Json.createArrayBuilder().add("one").add("two").add((JsonValue)JSONP_Util.buildJsonObjectFooBar()).add((JsonValue)JSONP_Util.buildJsonArrayFooBar()))).add(Json.createArrayBuilder().add("string").add(Integer.MAX_VALUE).add(Long.MAX_VALUE).add(Double.MAX_VALUE).add(new BigInteger(new Integer(Integer.MAX_VALUE).toString())).add(JsonValue.TRUE).add(JsonValue.FALSE).add(JsonValue.NULL).add(Json.createObjectBuilder().add("name", "value")).add(Json.createArrayBuilder().add("one").add("two"))).add("\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").build();
            return jsonArray;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception occurred: " + e));
            return null;
        }
    }

    public void jsonGeneratorObjectTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            this.generateSimpleJsonObject(generator);
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            this.logMsg("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(sWriter.toString());
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorObjectTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorObjectTest1 Failed");
        }
    }

    public void jsonGeneratorObjectTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGenerator((OutputStream)baos);
            generator.writeStartObject().write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("intMin", Integer.MIN_VALUE).write("intMax", Integer.MAX_VALUE).write("longMin", Long.MIN_VALUE).write("longMax", Long.MAX_VALUE).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("number", 100).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("name", "value").writeEnd().writeStartArray("array").write("one").write("two").writeEnd().writeEnd().writeStartArray("array").write("string").write(Integer.MAX_VALUE).write(Long.MAX_VALUE).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("name", "value").writeEnd().writeStartArray().write("one").write("two").writeEnd().writeEnd().write("asciiChars", "\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").writeEnd();
            generator.close();
            this.logMsg("Dump of string: " + baos.toString("UTF-8"));
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "{\"emptyString\":\"\",\"emptyArray\":[],\"emptyObject\":{},\"string\":\"string\",\"intMin\":-2147483648,\"intMax\":2147483647,\"longMin\":-9223372036854775808,\"longMax\":9223372036854775807,\"true\":true,\"false\":false,\"null\":null,\"object\":{\"emptyString\":\"\",\"emptyArray\":[],\"emptyObject\":{},\"string\":\"string\",\"number\":100,\"true\":true,\"false\":false,\"null\":null,\"object\":{\"name\":\"value\"},\"array\":[\"one\",\"two\"]},\"array\":[\"string\",2147483647,9223372036854775807,true,false,null,{\"name\":\"value\"},[\"one\",\"two\"]],\"asciiChars\":\"\\\\\\\"\\\\\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"}";
            this.logMsg("Read the JSON text back from OutputStream removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-8"));
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorObjectTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorObjectTest2 Failed");
        }
    }

    public void jsonGeneratorObjectTest3() throws EETest.Fault {
        boolean pass = true;
        try {
            JsonObject expJsonObject = this.buildJsonObject();
            String jsonText = this.generateJsonObject();
            JsonReader reader = Json.createReader((Reader)new StringReader(jsonText));
            JsonObject actJsonObject = (JsonObject)reader.read();
            this.logMsg("Compare expJsonObject and actJsonObject for equality");
            pass = JSONP_Util.assertEqualsJsonObjects(expJsonObject, actJsonObject);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorObjectTest3 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorObjectTest3 Failed");
        }
    }

    public void jsonGeneratorObjectTest4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create generator output in UTF-16BE encoding.");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16BE);
            this.generateSimpleJsonObject(generator);
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            this.logMsg("Read the JSON text back encoding from OutputStream using UTF-16BE encoding removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-16BE"));
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorObjectTest4 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorObjectTest4 Failed");
        }
    }

    public void jsonGeneratorObjectTest5() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader = null;
        String expUnicodeChars = "\u0000\u000f\u001f\u00ff\uff00\uffff";
        try {
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("unicodechars", "\u0000\u000f\u001f\u00ff\uff00\uffff").writeEnd();
            generator.close();
            sWriter.close();
            this.logMsg("Testing read of " + sWriter.toString());
            reader = Json.createReader((Reader)new StringReader(sWriter.toString()));
            JsonObject jsonObject = reader.readObject();
            String actUnicodeChars = jsonObject.getJsonString("unicodechars").getString();
            reader.close();
            TestUtil.logMsg((String)("actUnicodeChars=" + actUnicodeChars));
            pass = JSONP_Util.assertEquals(expUnicodeChars, actUnicodeChars);
        }
        catch (Exception e) {
            this.logErr("Exception occurred: " + e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorObjectTest5 Failed");
        }
    }

    public void jsonGeneratorArrayTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            this.generateSimpleJsonArray(generator);
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "[{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},[\"string\",1,true,false,null]]";
            this.logMsg("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(sWriter.toString());
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorArrayTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorArrayTest1 Failed");
        }
    }

    public void jsonGeneratorArrayTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGenerator((OutputStream)baos);
            generator.writeStartArray().write("").writeStartArray().writeEnd().writeStartObject().writeEnd().write("string").write(Integer.MIN_VALUE).write(Integer.MAX_VALUE).write(Long.MIN_VALUE).write(Long.MAX_VALUE).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("emptyString", "").writeStartArray("emptyArray").writeEnd().writeStartObject("emptyObject").writeEnd().write("string", "string").write("number", 100).write("true", JsonValue.TRUE).write("false", JsonValue.FALSE).write("null", JsonValue.NULL).writeStartObject("object").write("name", "value").writeEnd().writeStartArray("array").write("one").write("two").writeEnd().writeEnd().writeStartArray().write("string").write(Integer.MAX_VALUE).write(Long.MAX_VALUE).write(JsonValue.TRUE).write(JsonValue.FALSE).write(JsonValue.NULL).writeStartObject().write("name", "value").writeEnd().writeStartArray().write("one").write("two").writeEnd().writeEnd().write("\\\"\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM").writeEnd();
            generator.close();
            this.logMsg("Dump of string: " + baos.toString("UTF-8"));
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "[\"\",[],{},\"string\",-2147483648,2147483647,-9223372036854775808,9223372036854775807,true,false,null,{\"emptyString\":\"\",\"emptyArray\":[],\"emptyObject\":{},\"string\":\"string\",\"number\":100,\"true\":true,\"false\":false,\"null\":null,\"object\":{\"name\":\"value\"},\"array\":[\"one\",\"two\"]},[\"string\",2147483647,9223372036854775807,true,false,null,{\"name\":\"value\"},[\"one\",\"two\"]],\"\\\\\\\"\\\\\\\\!@#$%^&*()_+|~1234567890-=`[]{}:;',./<>? qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM\"]";
            this.logMsg("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-8"));
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorArrayTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorArrayTest2 Failed");
        }
    }

    public void jsonGeneratorArrayTest3() throws EETest.Fault {
        boolean pass = true;
        try {
            JsonArray expJsonArray = this.buildJsonArray();
            String jsonText = this.generateJsonArray();
            this.logMsg("generator json text: " + jsonText);
            JsonReader reader = Json.createReader((Reader)new StringReader(jsonText));
            JsonArray actJsonArray = (JsonArray)reader.read();
            this.logMsg("Compare expJsonArray and actJsonArray for equality");
            pass = JSONP_Util.assertEqualsJsonArrays(expJsonArray, actJsonArray);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorArrayTest3 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorArrayTest3 Failed");
        }
    }

    public void jsonGeneratorArrayTest4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create generator output in UTF-16BE encoding.");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16BE);
            this.generateSimpleJsonArray(generator);
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "[{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},[\"string\",1,true,false,null]]";
            this.logMsg("Read the JSON text back from OutputStream using UTF-16BE encoding removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-16BE"));
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorArrayTest4 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorArrayTest4 Failed");
        }
    }

    public void jsonGeneratorArrayTest5() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader = null;
        String expUnicodeChars = "\u0000\u000f\u001f\u00ff\uff00\uffff";
        try {
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("\u0000\u000f\u001f\u00ff\uff00\uffff").writeEnd();
            generator.close();
            sWriter.close();
            this.logMsg("Testing read of " + sWriter.toString());
            reader = Json.createReader((Reader)new StringReader(sWriter.toString()));
            JsonArray jsonArray = reader.readArray();
            String actUnicodeChars = jsonArray.getJsonString(0).getString();
            reader.close();
            TestUtil.logMsg((String)("actUnicodeChars=" + actUnicodeChars));
            pass = JSONP_Util.assertEquals(expUnicodeChars, actUnicodeChars);
        }
        catch (Exception e) {
            this.logErr("Exception occurred: " + e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorArrayTest5 Failed");
        }
    }

    public void jsonGeneratorObjectConfigTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create JsonGenerator using configuration with PRETTY_PRINTING");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGeneratorFactory(JSONP_Util.getPrettyPrintingConfig()).createGenerator((Writer)sWriter);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("PRETTY_PRINTING feature\n" + sWriter.toString()));
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            this.logMsg("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(sWriter.toString());
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorObjectConfigTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorObjectConfigTest1 Failed");
        }
    }

    public void jsonGeneratorObjectConfigTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create JsonGenerator using configuration with PRETTY_PRINTING");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory(JSONP_Util.getPrettyPrintingConfig()).createGenerator((OutputStream)baos);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("PRETTY_PRINTING feature\n" + baos.toString("UTF-8")));
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            this.logMsg("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-8"));
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorObjectConfigTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorObjectConfigTest2 Failed");
        }
    }

    public void jsonGeneratorObjectEncodingTest1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create JsonGenerator using UTF-8 encoding");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_8);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("Generator Output=" + baos.toString("UTF-8")));
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            this.logMsg("Read the JSON text back from OutputStream using UTF-8 encoding removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-8"));
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorObjectEncodingTest1 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorObjectEncodingTest1 Failed");
        }
    }

    public void jsonGeneratorObjectEncodingTest2() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create JsonGenerator using configuration with PRETTY_PRINTING using UTF-16BE encoding");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGeneratorFactory(JSONP_Util.getPrettyPrintingConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16BE);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("PRETTY_PRINTING feature\n" + baos.toString("UTF-16BE")));
            this.logMsg("Create expected JSON text with no whitespace");
            String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
            this.logMsg("Read the JSON text back from OutputStream using UTF-16BE encoding removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-16BE"));
            pass = JSONP_Util.assertEqualsJsonText(expJson, actJson);
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonGeneratorObjectEncodingTest2 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorObjectEncodingTest2 Failed");
        }
    }

    public void jsonGeneratorUTFEncodedTests() throws EETest.Fault {
        String actJson;
        JsonGenerator generator;
        ByteArrayOutputStream baos;
        boolean pass = true;
        this.logMsg("Create expected JSON text with no whitespace for use with comparison");
        String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
        try {
            this.logMsg("-----------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-8]");
            this.logMsg("-----------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonGenerator using UTF-8 encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_8);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-8")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-8 encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-8 encoding: " + e);
        }
        try {
            this.logMsg("------------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-16]");
            this.logMsg("------------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonGenerator using UTF-16 encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-16")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-16 encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-16"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-16 encoding: " + e);
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-16LE]");
            this.logMsg("--------------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonGenerator using UTF-16LE encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16LE);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-16LE")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-16LE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-16LE"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-16LE encoding: " + e);
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-16BE]");
            this.logMsg("--------------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonGenerator using UTF-16BE encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_16BE);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-16BE")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-16BE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-16BE"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-16BE encoding: " + e);
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-32LE]");
            this.logMsg("--------------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonGenerator using UTF-32LE encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_32LE);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-32LE")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-32LE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-32LE"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-32LE encoding: " + e);
        }
        try {
            this.logMsg("--------------------------------------------------------------------------------------------------------");
            this.logMsg("TEST CASE [Json.createGeneratorFactory(Map<String,?>).createGenerator(OutputStream, Charset) as UTF-32BE]");
            this.logMsg("--------------------------------------------------------------------------------------------------------");
            this.logMsg("Create JsonGenerator using UTF-32BE encoding");
            baos = new ByteArrayOutputStream();
            generator = Json.createGeneratorFactory(JSONP_Util.getEmptyConfig()).createGenerator((OutputStream)baos, JSONP_Util.UTF_32BE);
            this.generateSimpleJsonObject(generator);
            TestUtil.logMsg((String)("Generated Output=" + baos.toString("UTF-32BE")));
            this.logMsg("Read the JSON text back from OutputStream using UTF-32BE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace(baos.toString("UTF-32BE"));
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Exception occurred testing generation to UTF-32BE encoding: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorUTFEncodedTests Failed");
        }
    }

    public void jsonGeneratorExceptionTests() throws EETest.Fault {
        JsonGenerator generator;
        StringWriter sWriter;
        boolean pass = true;
        try {
            this.logMsg("Trip NumberFormatException for write(double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(Double.NaN);
            this.logErr("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            this.logMsg("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException for write(double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(Double.NEGATIVE_INFINITY);
            this.logErr("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            this.logMsg("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException for write(double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(Double.POSITIVE_INFINITY);
            this.logErr("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            this.logMsg("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException for write(String,double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("badnumber", Double.NaN);
            this.logErr("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            this.logMsg("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException for write(String,double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("badnumber", Double.NEGATIVE_INFINITY);
            this.logErr("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            this.logMsg("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip NumberFormatException for write(String,double) if value is Not-a-Number(NaN) or infinity");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("badnumber", Double.POSITIVE_INFINITY);
            this.logErr("Did not get expected NumberFormatException");
            pass = false;
        }
        catch (NumberFormatException e) {
            this.logMsg("Caught expected NumberFormatException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationExceptipn if an incomplete JSON is generated.");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("name", "value");
            generator.close();
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationExceptipn if an incomplete JSON is generated.");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string");
            generator.close();
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(JsonValue) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(JsonValue.TRUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("name");
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(BigInteger) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(new BigInteger(new Integer(Integer.MAX_VALUE).toString()));
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(BigDecimal) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(BigDecimal.valueOf(Integer.MIN_VALUE));
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(int) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(Integer.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(long) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(Long.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(double) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(Double.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(boolean) if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write(true);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for writeNull() if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeNull();
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for writeStartArray() if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeStartArray();
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for writeStartObject() if not called within array context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeStartObject();
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,JsonValue) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", JsonValue.TRUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,String) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", "name");
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,BigInteger) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", new BigInteger(new Integer(Integer.MAX_VALUE).toString()));
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,BigDecimal) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", BigDecimal.valueOf(Integer.MIN_VALUE));
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,int) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", Integer.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,long) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", Long.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,double) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", Double.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,boolean) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write("string", true);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for writeNull(String) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeNull("string");
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for writeStartArray(String) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeStartArray("string");
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for writeStartObject(String) if not called within object context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeStartObject("string");
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,JsonValue) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", "value");
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for writeEnd() when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().writeEnd();
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,BigInteger) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", new BigInteger(new Integer(Integer.MAX_VALUE).toString()));
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,BigDecimal) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", BigDecimal.valueOf(Integer.MIN_VALUE));
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,int) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", Integer.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,long) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", Long.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,double) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", Double.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String,boolean) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().write("name", false);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for writeNull(String) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeEnd().writeNull("name");
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(JsonValue) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(JsonValue.TRUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(String) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(JsonValue.TRUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(BigDecimal) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(BigDecimal.valueOf(Integer.MIN_VALUE));
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(BigInteger) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(new BigInteger(new Integer(Integer.MAX_VALUE).toString()));
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(int) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(Integer.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(long) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(Long.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(double) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(Double.MAX_VALUE);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for write(boolean) when invoked after the writeEnd method is called");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().write(true);
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonGenerationException for for writeNull() when invoked with no context");
            sWriter = new StringWriter();
            generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().writeEnd().writeNull();
            this.logErr("Did not get expected JsonGenerationException");
            pass = false;
        }
        catch (JsonGenerationException e) {
            this.logMsg("Caught expected JsonGenerationException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorExceptionTests Failed");
        }
    }

    public void flushTest() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Generate some partial Json and flush output.");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().writeStartObject("object").writeEnd().flush();
            this.logMsg("Create expected partial JSON text with no whitespace");
            String expJson = "{\"object\":{}";
            this.logMsg("Read the JSON text back from Writer removing whitespace");
            String actJson = JSONP_Util.removeWhitespace(sWriter.toString());
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
            this.logMsg("Generate additional Json to complete and flush output.");
            generator.writeStartArray("array").writeEnd().writeEnd().flush();
            expJson = "{\"object\":{},\"array\":[]}";
            this.logMsg("Read the JSON text back from Writer removing whitespace");
            actJson = JSONP_Util.removeWhitespace(sWriter.toString());
            if (!JSONP_Util.assertEqualsJsonText(expJson, actJson)) {
                pass = false;
            }
            generator.close();
        }
        catch (Exception e) {
            throw new EETest.Fault("flushTest Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("flushTest Failed");
        }
    }

    public void jsonGeneratorIOErrorTests() throws EETest.Fault {
        JsonGenerator generator;
        MyBufferedWriter mbw;
        boolean pass = true;
        try {
            this.logMsg("Trip JsonException if there is an i/o error on JsonGenerator.close().");
            mbw = new MyBufferedWriter(new StringWriter());
            generator = Json.createGenerator((Writer)mbw);
            generator.writeStartObject().writeEnd();
            mbw.setThrowIOException(true);
            this.logMsg("Calling JsonGenerator.close()");
            generator.close();
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Trip JsonException if there is an i/o error on JsonGenerator.flush().");
            mbw = new MyBufferedWriter(new StringWriter());
            generator = Json.createGenerator((Writer)mbw);
            generator.writeStartObject().writeEnd();
            mbw.setThrowIOException(true);
            this.logMsg("Calling JsonGenerator.flush()");
            generator.flush();
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonGeneratorIOErrorTests Failed");
        }
    }

    public void jsonGeneratorDocumentRootTest() throws EETest.Fault {
        Generator genTest = new Generator();
        TestResult result = genTest.test();
        result.eval();
    }
}

