/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.connector.localTx.transaction.conSharing2;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSDataSource;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import java.util.Properties;
import java.util.Vector;

public class BeanBEJB
implements SessionBean {
    private static final Properties testProps = null;
    private SessionContext sctx = null;
    private TSNamingContext context = null;
    private TSConnection con;
    private TSDataSource ds;

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        try {
            this.sctx = sc;
            this.context = new TSNamingContext();
            this.ds = (TSDataSource)this.context.lookup("java:comp/env/eis/whitebox-tx");
            TestUtil.logTrace((String)("ds: " + this.ds));
            TestUtil.logTrace((String)"TSDataSource lookup OK!");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception setting EJB context/DataSources", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbDestroy() {
        TestUtil.logTrace((String)"ejbDestroy");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
        try {
            this.con = this.ds.getConnection();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception connecting to DB", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void ejbPassivate() {
        this.dbUnConnect();
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void dbConnect() {
        TestUtil.logTrace((String)"dbConnect");
        try {
            this.conTable2();
            TestUtil.logTrace((String)"Made connection to DB");
        }
        catch (Exception se) {
            TestUtil.logErr((String)"Exception opening db connection ", (Throwable)se);
            throw new EJBException(se.getMessage());
        }
    }

    public void dbUnConnect() {
        TestUtil.logTrace((String)"dbUnConnect");
        try {
            if (this.con != null) {
                this.con.close();
                this.con = null;
            }
        }
        catch (Exception se) {
            TestUtil.logErr((String)"Exception closing db connection ", (Throwable)se);
            throw new EJBException(se.getMessage());
        }
    }

    public void createData() {
        TestUtil.logTrace((String)"createData");
        try {
            this.createTable2();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception creating table ", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public boolean insert(String str) {
        try {
            this.con.insert("3", str);
            return true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception inserting a row into table ", (Throwable)e);
            return false;
        }
    }

    public void delete(String str) {
        TestUtil.logTrace((String)"delete");
        try {
            this.con.delete(str);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void destroyData() {
        TestUtil.logTrace((String)"destroyData");
        try {
            this.dropTable2();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured trying to drop table", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public Vector getResults() {
        TestUtil.logTrace((String)"getResults");
        try {
            Vector results = this.con.readData();
            return results;
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void conTable2() {
        TestUtil.logTrace((String)"conTable2");
        try {
            this.con = this.ds.getConnection();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception connecting DB", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    private void createTable2() {
        try {
            this.dropTable2();
            TestUtil.logTrace((String)"Deleted all rows from table ");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logMsg((String)("Exception encountered while deleting rows " + e.getMessage()));
        }
    }

    private void dropTable2() {
        TestUtil.logTrace((String)"dropTable2");
        try {
            this.con.dropTable();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception dropping ", (Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

