/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.query.apitests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.query.apitests.DataTypes2;
import com.sun.ts.tests.jpa.core.query.apitests.Department;
import com.sun.ts.tests.jpa.core.query.apitests.Employee;
import com.sun.ts.tests.jpa.core.query.apitests.Insurance;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.TypedQuery;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Client
extends PMClientBase {
    private final Employee[] empRef = new Employee[21];
    private final Date d1 = this.getSQLDate("2000-02-14");
    private final java.util.Date dateId = this.getUtilDate("2009-01-10");
    final Department[] deptRef = new Department[5];
    private static final DecimalFormat df = new DecimalFormat();

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setupNoData(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught in Setup: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught in Setup: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupDataTypes2(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createDataTypes2Data();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught in Setup: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanupNoData() throws EETest.Fault {
        TestUtil.logTrace((String)"in cleanupNoData");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstResultTest() throws EETest.Fault {
        int gfr;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = true;
        boolean pass11 = false;
        boolean pass12 = false;
        boolean pass13 = false;
        boolean pass14 = true;
        Object[][] expectedResultSet = new Object[][]{{4, 4}, {4, 9}, {4, 14}, {4, 19}, {5, 5}, {5, 10}, {5, 15}, {5, 20}};
        try {
            int i;
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select d.id, e.id from Department d join d.employees e where d.id <= 5  order by d.id, e.id");
            gfr = query.getFirstResult();
            if (gfr != 0) {
                TestUtil.logErr((String)("getFirstResult() - Expecting result=0, actual=" + gfr));
            } else {
                pass1 = true;
            }
            query.setFirstResult(13);
            gfr = query.getFirstResult();
            if (gfr != 13) {
                TestUtil.logErr((String)("getFirstResult() - Expecting result=11, actual=" + gfr));
            } else {
                pass2 = true;
            }
            List q = query.getResultList();
            if (TestUtil.traceflag) {
                TestUtil.logTrace((String)("query returned " + q.size() + " results."));
                i = 0;
                for (Object obj : q) {
                    TestUtil.logTrace((String)(i++ + "=" + Arrays.asList((Object[])obj)));
                }
            }
            if (q.size() == 8) {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                i = 0;
                pass3 = true;
                for (Object obj : q) {
                    Object[] expected = expectedResultSet[i++];
                    Object[] departmentIdEmpId = null;
                    if (obj instanceof Object[]) {
                        TestUtil.logTrace((String)"The element in the result list is of type Object[], continue . . .");
                        departmentIdEmpId = (Object[])obj;
                        if (Arrays.equals(expected, departmentIdEmpId)) continue;
                        TestUtil.logErr((String)("Expecting element value: " + Arrays.asList(expected) + ", actual element value: " + Arrays.asList(departmentIdEmpId)));
                        pass4 = false;
                    } else {
                        TestUtil.logErr((String)("The element in the result list is not of type Object[]:" + obj));
                        pass4 = false;
                    }
                    break;
                }
            } else {
                TestUtil.logErr((String)("Did not get expected results.  Expected: 10, got: " + q.size()));
                TestUtil.logErr((String)"Expected results:");
                i = 0;
                for (Object[] obj : expectedResultSet) {
                    TestUtil.logErr((String)(i++ + "=" + Arrays.toString(obj)));
                }
                TestUtil.logErr((String)"Actual results:");
                i = 0;
                for (Object obj : q) {
                    TestUtil.logErr((String)(i++ + "=" + Arrays.asList((Object[])obj)));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e.id from Employee e where e.id <= 10 order by e.id", Integer.class);
            gfr = query.getFirstResult();
            if (gfr != 0) {
                TestUtil.logErr((String)("getFirstResult() - Expecting result=0, actual=" + gfr));
            } else {
                pass11 = true;
            }
            query.setFirstResult(5);
            gfr = query.getFirstResult();
            if (gfr != 5) {
                TestUtil.logErr((String)("getFirstResult() - Expecting result=5, actual=" + gfr));
            } else {
                pass12 = true;
            }
            List actual = query.getResultList();
            String[] expected = new String[]{"6", "7", "8", "9", "10"};
            if (!this.checkEntityPK(actual, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass13 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass14 = false;
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass11 && pass12 && pass13 && pass14)) {
            throw new EETest.Fault("setFirstResultTest failed");
        }
    }

    public void setFirstResultIllegalArgumentExceptionTest() throws EETest.Fault {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e.id from Employee e where e.id <= 10 order by e.id");
            query.setFirstResult(-5);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e.id from Employee e where e.id <= 10 order by e.id", Integer.class);
            query.setFirstResult(-5);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setFirstResultIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterTest() throws EETest.Fault {
        String s;
        Parameter p;
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter("fName", (Object)"Stephen");
            p = q.getParameter("fName", String.class);
            s = p.getName();
            if (!s.equals("fName")) {
                TestUtil.logErr((String)("getName() - Expected:fName, actual:" + s));
            } else {
                pass1 = true;
            }
        }
        catch (IllegalStateException ise) {
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter("fName", (Object)"Stephen");
            p = q.getParameter("fName", String.class);
            s = p.getName();
            if (!s.equals("fName")) {
                TestUtil.logErr((String)("getName() - Expected:fName, actual:" + s));
            } else {
                pass2 = true;
            }
        }
        catch (IllegalStateException ise) {
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterTest failed");
        }
    }

    public void getParameterIllegalArgumentExceptionTest() throws EETest.Fault {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName");
            q.getParameter("doesnotexist", String.class);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class);
            q.getParameter("doesnotexist", String.class);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterIllegalArgumentException2Test() throws EETest.Fault {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName");
            q.getParameter("doesnotexist");
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class);
            q.getParameter("doesnotexist");
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterIllegalArgumentException2Test failed");
        }
    }

    public void getParameterIntClassTest() throws EETest.Fault {
        String s;
        Parameter p;
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"Stephen");
            p = q.getParameter(1, String.class);
            s = p.getName();
            if (s != null) {
                TestUtil.logErr((String)("getName() - Expected:null, actual:" + s));
            } else {
                pass1 = true;
            }
        }
        catch (IllegalStateException ise) {
            pass1 = true;
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"Stephen");
            p = q.getParameter(1, String.class);
            s = p.getName();
            if (s != null) {
                TestUtil.logErr((String)("getName() - Expected:null, actual:" + s));
            } else {
                pass2 = true;
            }
        }
        catch (IllegalStateException ise) {
            pass2 = true;
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterIntClassTest failed");
        }
    }

    public void getParameterIntIllegalArgumentExceptionTest() throws EETest.Fault {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logTrace((String)"Creating query for getParameterIntIllegalArgumentExceptionTest");
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"foo");
            query.getParameter(99);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"foo");
            query.getParameter(99);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterIntIllegalArgumentExceptionTest failed");
        }
    }

    @SetupMethod(name="setupNoData")
    @CleanupMethod(name="cleanupNoData")
    public void getParameterIntIllegalArgumentException2Test() throws EETest.Fault {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"Tom");
            query.getParameter(1, List.class);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"Tom");
            query.getParameter(1, List.class);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterIntIllegalArgumentException2Test failed");
        }
    }

    public void getParameterValueParameterTest() throws EETest.Fault {
        String s;
        Parameter p;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        String expectedName = "fName";
        String expectedValue = "Stephen";
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter(expectedName, (Object)expectedValue);
            p = query.getParameter(expectedName);
            if (p != null) {
                s = (String)query.getParameterValue(p);
                if (!s.equals(expectedValue)) {
                    TestUtil.logErr((String)("Expected:" + expectedValue + ",Actual=" + s));
                } else {
                    pass1 = true;
                }
            } else {
                TestUtil.logErr((String)"getParameter returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter(expectedName, (Object)expectedValue);
            p = query.getParameter(expectedName);
            if (p != null) {
                s = (String)query.getParameterValue(p);
                if (!s.equals(expectedValue)) {
                    TestUtil.logErr((String)("Expected:" + expectedValue + ",Actual=" + s));
                } else {
                    pass2 = true;
                }
            } else {
                TestUtil.logErr((String)"getParameter returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterValueParameterTest failed");
        }
    }

    public void getParameterValueParameterIllegalArgumentExceptionTest() throws EETest.Fault {
        Parameter p;
        Query query2;
        Query query1;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname1").setParameter("fname1", (Object)"fnameValue1");
            query2 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname2").setParameter("fname2", (Object)"fnameValue2");
            p = query2.getParameter("fname2");
            query1.getParameterValue(p);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname1", Employee.class).setParameter("fname1", (Object)"fnameValue1");
            query2 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname2", Employee.class).setParameter("fname2", (Object)"fnameValue2");
            p = query2.getParameter("fname2");
            query1.getParameterValue(p);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterValueParameterIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueParameterIllegalStateExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        TestUtil.logMsg((String)"Testing Query version");
        Query query1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1");
        Set set = query1.getParameters();
        if (set.size() != 1) {
            TestUtil.logErr((String)("Expected one parameter, actual=" + set.size()));
            for (Object p : set) {
                TestUtil.logErr((String)("Parameter:" + p.toString()));
            }
        } else {
            pass1 = true;
        }
        try {
            for (Object p : set) {
                query1.getParameterValue((Parameter)p);
            }
            TestUtil.logErr((String)"IllegalStateException was not thrown");
        }
        catch (IllegalStateException iae) {
            TestUtil.logTrace((String)"Received expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        TypedQuery tquery1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1", Employee.class);
        set = tquery1.getParameters();
        if (set.size() != 1) {
            TestUtil.logErr((String)("Expected one parameter, actual=" + set.size()));
            for (Parameter p : set) {
                TestUtil.logErr((String)("Parameter:" + p.toString()));
            }
        } else {
            pass3 = true;
        }
        try {
            for (Parameter p : set) {
                tquery1.getParameterValue(p);
            }
            TestUtil.logErr((String)"IllegalStateException was not thrown");
        }
        catch (IllegalStateException iae) {
            TestUtil.logTrace((String)"Received expected IllegalStateException");
            pass4 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("getParameterValueParameterIllegalStateExceptionTest failed");
        }
    }

    public void setParameterParameterObjectIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        TestUtil.logMsg((String)"Testing Query version");
        Query query1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1");
        Query query2 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName2");
        Set set = query2.getParameters();
        if (set.size() != 1) {
            TestUtil.logErr((String)("Expected one parameter, actual=" + set.size()));
            for (Parameter p : set) {
                TestUtil.logErr((String)("Parameter:" + p.toString()));
            }
        } else {
            pass1 = true;
        }
        try {
            for (Parameter p : set) {
                query1.setParameter(p, (Object)"object1");
            }
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        TypedQuery tquery1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1", Employee.class);
        TypedQuery tquery2 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName2", Employee.class);
        set = tquery2.getParameters();
        if (set.size() != 1) {
            TestUtil.logErr((String)("Expected one parameter, actual=" + set.size()));
            for (Parameter p : set) {
                TestUtil.logErr((String)("Parameter:" + p.toString()));
            }
        } else {
            pass3 = true;
        }
        try {
            for (Parameter p : set) {
                tquery1.setParameter(p, (Object)"object1");
            }
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass4 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("setParameterParameterObjectIllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        TestUtil.logMsg((String)"Testing Query version");
        Query query1 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date1");
        Query query2 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date2");
        Set set = query2.getParameters();
        if (set.size() != 1) {
            TestUtil.logErr((String)("Expected one parameter, actual=" + set.size()));
            for (Parameter p : set) {
                TestUtil.logErr((String)("Parameter:" + p.toString()));
            }
        } else {
            pass1 = true;
        }
        try {
            for (Parameter p : set) {
                query1.setParameter(p, this.getCalDate(), TemporalType.DATE);
            }
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        TypedQuery tquery1 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date1", Employee.class);
        TypedQuery tquery2 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date2", Employee.class);
        set = tquery2.getParameters();
        if (set.size() != 1) {
            TestUtil.logErr((String)("Expected one parameter, actual=" + set.size()));
            for (Parameter p : set) {
                TestUtil.logErr((String)("Parameter:" + p.toString()));
            }
        } else {
            pass3 = true;
        }
        try {
            for (Parameter p : set) {
                tquery1.setParameter(p, this.getCalDate(), TemporalType.DATE);
            }
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass4 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        TestUtil.logMsg((String)"Testing Query version");
        Query query1 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date1");
        Query query2 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date2");
        Set set = query2.getParameters();
        if (set.size() != 1) {
            TestUtil.logErr((String)("Expected one parameter, actual=" + set.size()));
            for (Parameter p : set) {
                TestUtil.logErr((String)("Parameter:" + p.toString()));
            }
        } else {
            pass1 = true;
        }
        try {
            for (Parameter p : set) {
                query1.setParameter(p, this.dateId, TemporalType.DATE);
            }
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        TypedQuery tquery1 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date1", Employee.class);
        TypedQuery tquery2 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date2", Employee.class);
        set = tquery2.getParameters();
        if (set.size() != 1) {
            TestUtil.logErr((String)("Expected one parameter, actual=" + set.size()));
            for (Parameter p : set) {
                TestUtil.logErr((String)("Parameter:" + p.toString()));
            }
        } else {
            pass3 = true;
        }
        try {
            for (Parameter p : set) {
                tquery1.setParameter(p, this.dateId, TemporalType.DATE);
            }
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass4 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueStringTest() throws EETest.Fault {
        String s;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        String expectedName = "fName";
        String expectedValue = "Stephen";
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter(expectedName, (Object)expectedValue);
            s = (String)query.getParameterValue(expectedName);
            if (!s.equals(expectedValue)) {
                TestUtil.logErr((String)("Expected:" + expectedValue + ",Actual=" + s));
            } else {
                pass1 = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter(expectedName, (Object)expectedValue);
            s = (String)query.getParameterValue(expectedName);
            if (!s.equals(expectedValue)) {
                TestUtil.logErr((String)("Expected:" + expectedValue + ",Actual=" + s));
            } else {
                pass2 = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterValueStringTest failed");
        }
    }

    public void getParameterValueStringIllegalArgumentExceptionTest() throws EETest.Fault {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1").setParameter("fName1", (Object)"fnameValue");
            query.getParameterValue("fName2");
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1", Employee.class).setParameter("fName1", (Object)"fnameValue");
            query.getParameterValue("fName2");
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterValueStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueStringIllegalStateExceptionTest() throws EETest.Fault {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname1");
            query.getParameterValue("fname1");
            TestUtil.logErr((String)"IllegalStateException was not thrown");
        }
        catch (IllegalStateException iae) {
            TestUtil.logTrace((String)"Received expected IllegalStateException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname1", Employee.class);
            query.getParameterValue("fname1");
            TestUtil.logErr((String)"IllegalStateException was not thrown");
        }
        catch (IllegalStateException iae) {
            TestUtil.logTrace((String)"Received expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterValueStringIllegalStateExceptionTest failed");
        }
    }

    public void getParameterValueIntTest() throws EETest.Fault {
        String s;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        String expectedValue = "Stephen";
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)expectedValue);
            s = (String)query.getParameterValue(1);
            if (!s.equals(expectedValue)) {
                TestUtil.logErr((String)("Expected:" + expectedValue + ",Actual=" + s));
            } else {
                pass1 = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)expectedValue);
            s = (String)query.getParameterValue(1);
            if (!s.equals(expectedValue)) {
                TestUtil.logErr((String)("Expected:" + expectedValue + ",Actual=" + s));
            } else {
                pass2 = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterValueIntTest failed");
        }
    }

    public void getParameterValueIntIllegalArgumentExceptionTest() throws EETest.Fault {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"foo");
            query.getParameterValue(99);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"foo");
            query.getParameterValue(99);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterValueIntIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueIntIllegalStateExceptionTest() throws EETest.Fault {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1");
            query.getParameterValue(1);
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)"Received expected IllegalStateException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class);
            query.getParameterValue(1);
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            TestUtil.logTrace((String)"Received expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getParameterValueIntIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter1Test() throws EETest.Fault {
        List result;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        Integer[] expected = new Integer[]{this.empRef[4].getId(), this.empRef[6].getId()};
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter("fName", (Object)"Stephen");
            result = query.getResultList();
            if (!this.checkEntityPK(result, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter("fName", (Object)"Stephen");
            result = query.getResultList();
            if (!this.checkEntityPK(result, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameter1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter2Test() throws EETest.Fault {
        boolean pass = false;
        Integer[] expected = new Integer[]{this.empRef[0].getId(), this.empRef[4].getId(), this.empRef[6].getId()};
        try {
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName or e.firstName = :Fname").setParameter("fName", (Object)"Stephen").setParameter("Fname", (Object)"Alan");
            List result = query.getResultList();
            if (!this.checkEntityPK(result, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + result.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("setParameter2Test failed");
        }
    }

    public void setParameterStringObject1IllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter("fName", (Object)Float.valueOf(5.0f));
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter("fName", (Object)Float.valueOf(5.0f));
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterStringObject1IllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterStringObject2IllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter("doesnotexist", (Object)"foo");
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter("doesnotexist", (Object)"foo");
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterStringObject2IllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterStringDateTemporalTypeTest() throws EETest.Fault {
        List q;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[0]);
        cEmp.add(this.empRef[19]);
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate");
            q = query.setParameter("hDate", (java.util.Date)this.d1, TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate", Employee.class);
            q = tquery.setParameter("hDate", (java.util.Date)this.d1, TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterStringDateTemporalTypeTest failed");
        }
    }

    public void setParameterStringDateTemporalTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate").setParameter("doesnotexist", (java.util.Date)this.d1, TemporalType.DATE);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate", Employee.class).setParameter("doesnotexist", (java.util.Date)this.d1, TemporalType.DATE);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterStringDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterStringCalendarTemporalTypeTest() throws EETest.Fault {
        List q;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[20]);
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate");
            q = query.setParameter("hDate", this.getCalDate(), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate", Employee.class);
            q = tquery.setParameter("hDate", this.getCalDate(), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterStringCalendarTemporalTypeTest failed");
        }
    }

    public void setParameterStringCalendarTemporalTypeTestIllegalArgumentExceptionTest() throws EETest.Fault {
        Calendar c = Calendar.getInstance();
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityManager().createQuery("select d from Department d where :param > 1").setParameter("badName", c, TemporalType.TIMESTAMP);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select d from Department d where :param > 1", Department.class).setParameter("badName", c, TemporalType.TIMESTAMP);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterStringCalendarTemporalTypeTestIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterIntObjectTest() throws EETest.Fault {
        List q;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[4]);
        cEmp.add(this.empRef[6]);
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1");
            q = query.setParameter(1, (Object)"Stephen").getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class);
            q = tquery.setParameter(1, (Object)"Stephen").getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterIntObjectTest failed");
        }
    }

    public void setParameterIntObjectIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        TestUtil.logMsg((String)"Testing query version");
        try {
            TestUtil.logMsg((String)"Testing a parm that does not exist ");
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"Kellie").setParameter(2, (Object)"Lee");
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing a parm of incorrect type");
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)1);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            TestUtil.logMsg((String)"Testing a parm that does not exist");
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"Kellie").setParameter(2, (Object)"Lee");
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass3 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        try {
            TestUtil.logMsg((String)"Testing a parm of incorrect type");
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)1);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass4 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("setParameterIntObjectIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterIntDateTemporalTypeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[0]);
        cEmp.add(this.empRef[19]);
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1").setParameter(1, (java.util.Date)this.d1, TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class);
            List q = tquery.setParameter(1, (java.util.Date)this.d1, TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterIntDateTemporalTypeTest failed");
        }
    }

    public void setParameterIntDateTemporalTypeIllegalArgumentException1Test() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityManager().createQuery("select d from Department d where :hDate > 1").setParameter(5, (java.util.Date)this.d1, TemporalType.DATE);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select d from Department d where :hDate > 1", Department.class).setParameter(5, (java.util.Date)this.d1, TemporalType.DATE);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterIntDateTemporalTypeIllegalArgumentException1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterIntCalendarTemporalTypeTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[20]);
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1").setParameter(1, this.getCalDate(), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class);
            List q = tquery.setParameter(1, this.getCalDate(), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterIntCalendarTemporalTypeTest failed");
        }
    }

    public void setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest() throws EETest.Fault {
        Calendar c = Calendar.getInstance();
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityManager().createQuery("select d from Department d where ?1 > 1").setParameter(5, c, TemporalType.TIMESTAMP);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select d from Department d where ?1 > 1", Department.class).setParameter(5, c, TemporalType.TIMESTAMP);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter7Test() throws EETest.Fault {
        List q;
        Parameter p;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[1]);
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"Stephen");
            p = query.getParameter(1);
            query.setParameter(p, (Object)"Arthur");
            q = query.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"Stephen");
            p = query.getParameter(1);
            query.setParameter(p, (Object)"Arthur");
            q = query.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameter7Test failed");
        }
    }

    public void setParameterParameterCalendarTemporalTypeTest() throws EETest.Fault {
        List q;
        Parameter p;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[20]);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing Query version");
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1");
            p = query.getParameter(1);
            query.setParameter(p, this.getCalDate(), TemporalType.DATE);
            q = query.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class);
            p = tquery.getParameter(1);
            tquery.setParameter(p, this.getCalDate(), TemporalType.DATE);
            q = tquery.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterParameterCalendarTemporalTypeTest failed");
        }
    }

    public void setParameterParameterDateTemporalTypeTest() throws EETest.Fault {
        List q;
        Parameter p;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[5]);
        cEmp.add(this.empRef[14]);
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing Query version");
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1");
            p = query.getParameter(1);
            query.setParameter(p, this.getUtilDate("2005-02-18"), TemporalType.DATE);
            q = query.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class);
            p = tquery.getParameter(1);
            tquery.setParameter(p, this.getUtilDate("2005-02-18"), TemporalType.DATE);
            q = tquery.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameterParameterDateTemporalTypeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter8Test() throws EETest.Fault {
        List q;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[5]);
        cEmp.add(this.empRef[14]);
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            q = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1").setParameter(1, this.getUtilDate("2005-02-18"), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            q = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class).setParameter(1, this.getUtilDate("2005-02-18"), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setParameter8Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultNoResultExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityManager().createQuery("select d.name from Department d where d.id = 99").getSingleResult();
            TestUtil.logErr((String)"NoResultException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (NoResultException nre) {
            TestUtil.logTrace((String)("Exception Caught as Expected:" + (Object)((Object)nre)));
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.name from Department d where d.id = 99", String.class).getSingleResult();
            TestUtil.logErr((String)"NoResultException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (NoResultException nre) {
            TestUtil.logTrace((String)("Exception Caught as Expected:" + (Object)((Object)nre)));
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getSingleResultNoResultExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultTransactionRequiredException() throws EETest.Fault {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Query version");
        try {
            q = this.getEntityManager().createQuery("select d from  Department d where d.id = 1");
            q.setLockMode(LockModeType.WRITE);
            q.getSingleResult();
            TestUtil.logErr((String)"TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException ise) {
            TestUtil.logTrace((String)"Exception Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select d from  Department d where d.id = 1", Department.class);
            q.setLockMode(LockModeType.WRITE);
            q.getSingleResult();
            TestUtil.logErr((String)"TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException ise) {
            TestUtil.logTrace((String)"Exception Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getSingleResultTransactionRequiredException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultNonUniqueResultExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.name from Department d where d.id > 1").getSingleResult();
            TestUtil.logErr((String)"NoResultException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (NonUniqueResultException nure) {
            TestUtil.logTrace((String)("Exception Caught as Expected:" + (Object)((Object)nure)));
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.name from Department d where d.id > 1", String.class).getSingleResult();
            TestUtil.logErr((String)"NoResultException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (NonUniqueResultException nure) {
            TestUtil.logTrace((String)("Exception Caught as Expected:" + (Object)((Object)nure)));
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getSingleResultNonUniqueResultExceptionTest failed");
        }
    }

    public void isBoundTest() throws EETest.Fault {
        Parameter p;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        String expectedName = "fName";
        String expectedValue = "Stephen";
        try {
            TestUtil.logTrace((String)"Creating query for isBoundTest");
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter(expectedName, (Object)expectedValue);
            p = query.getParameter(expectedName);
            if (p != null) {
                if (!query.isBound(p)) {
                    TestUtil.logErr((String)("isbound returned false even though a value is bound to the parameter " + expectedName + "[" + p.getName() + "]"));
                } else {
                    pass1 = true;
                }
            } else {
                TestUtil.logErr((String)"getParameter returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter(expectedName, (Object)expectedValue);
            p = query.getParameter(expectedName);
            if (p != null) {
                if (!query.isBound(p)) {
                    TestUtil.logErr((String)("isbound returned false even though a value is bound to the parameter " + expectedName + "[" + p.getName() + "]"));
                } else {
                    pass2 = true;
                }
            } else {
                TestUtil.logErr((String)"getParameter returned null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("isBoundTest failed");
        }
    }

    public void setFirstResult() throws EETest.Fault {
        List actual;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(2);
        expected.add(3);
        expected.add(3);
        expected.add(4);
        expected.add(4);
        expected.add(5);
        TestUtil.logMsg((String)"Testing query");
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("select e.department.id from Employee e where e.id < 10 order by e.department.id").setFirstResult(3);
            actual = q.getResultList();
            if (!this.checkEntityPK(actual, expected, true)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        try {
            this.getEntityTransaction().begin();
            TestUtil.logMsg((String)"Testing TypedQuery");
            TypedQuery tq = this.getEntityManager().createQuery("select e.department.id from Employee e where e.id < 10 order by e.department.id", Integer.class).setFirstResult(3);
            actual = tq.getResultList();
            if (!this.checkEntityPK(actual, expected, true)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setFirstResult failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest11() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            Query query = null;
            try {
                query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1 and e.lastName = ?3").setParameter(1, (Object)"Kellie").setParameter(2, (Object)"Lee");
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exeception", (Throwable)e);
            }
            if (!pass) {
                try {
                    query.getResultList();
                }
                catch (RuntimeException e) {
                    TestUtil.logMsg((String)("Did not get expected IllegalArgumentException when setting an invalid parameter on a query, but got expected RuntimeException when executing the query: " + e));
                    pass = true;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("queryAPITest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest12() throws EETest.Fault {
        boolean pass = false;
        TestUtil.logTrace((String)"invoke query for queryAPITest12 ...");
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityTransaction().begin();
            Query query = null;
            try {
                query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1 and e.lastName = ?2").setParameter(1, (Object)"Kate").setParameter(2, (Object)10);
            }
            catch (IllegalArgumentException iae) {
                TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
                pass = true;
            }
            catch (Exception e) {
                TestUtil.logErr((String)"Received unexpected exeception", (Throwable)e);
            }
            if (!pass) {
                try {
                    query.getResultList();
                }
                catch (RuntimeException e) {
                    TestUtil.logMsg((String)("Did not get expected IllegalArgumentException when setting an invalid parameter on a query, but got expected RuntimeException when executing the query: " + e));
                    pass = true;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("queryAPITest12 failed");
        }
    }

    public void setFirstResultIllegalArgumentException() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        this.getEntityTransaction().begin();
        TestUtil.logMsg((String)"Testing query version");
        try {
            this.getEntityManager().createQuery("select d from Department d").setFirstResult(-3);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select d from Department d", Department.class).setFirstResult(-3);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        this.getEntityTransaction().rollback();
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setFirstResultIllegalArgumentException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGetMaxResultsTest() throws EETest.Fault {
        List q;
        int gmr;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        Integer[] expected = new Integer[]{1, 2, 3, 4, 5};
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select d from Department d order by d.id");
            gmr = query.getMaxResults();
            if (gmr != Integer.MAX_VALUE) {
                TestUtil.logErr((String)("getMaxResults() called when setMaxResults() not called - Expected:2147483647, actual:" + gmr));
                pass1 = false;
            } else {
                query.setMaxResults(15);
                gmr = query.getMaxResults();
                if (gmr != 15) {
                    TestUtil.logErr((String)("getMaxResults() - Expected: 15, Actual:" + gmr));
                    pass1 = false;
                } else {
                    q = query.getResultList();
                    if (!this.checkEntityPK(q, expected)) {
                        TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + q.size()));
                    } else {
                        TestUtil.logTrace((String)"Expected results received");
                        pass1 = true;
                    }
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass1 = false;
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select d from Department d order by d.id", Department.class);
            gmr = query.getMaxResults();
            if (gmr != Integer.MAX_VALUE) {
                TestUtil.logErr((String)("getMaxResults() called when setMaxResults() not called - Expected:2147483647, actual:" + gmr));
                pass2 = false;
            } else {
                query.setMaxResults(15);
                gmr = query.getMaxResults();
                if (gmr != 15) {
                    TestUtil.logErr((String)("getMaxResults() - Expected: 15, Actual:" + gmr));
                    pass2 = false;
                } else {
                    q = query.getResultList();
                    if (!this.checkEntityPK(q, expected)) {
                        TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + q.size()));
                    } else {
                        TestUtil.logTrace((String)"Expected results received");
                        pass2 = true;
                    }
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass2 = false;
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setGetMaxResultsTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxResultsIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d from Department d order by d.id").setMaxResults(-15);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d from Department d order by d.id", Department.class).setMaxResults(-15);
            TestUtil.logErr((String)"IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("setMaxResultsIllegalArgumentExceptionTest failed");
        }
    }

    public void getResultListTransactionRequiredExceptionTest() throws EETest.Fault {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            query = this.getEntityManager().createQuery("select d from Department d ");
            query.setLockMode(LockModeType.READ);
            query.getResultList();
            TestUtil.logErr((String)"TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            TestUtil.logTrace((String)"Received expected TransactionRequiredException ");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select d from Department d ", Department.class);
            query.setLockMode(LockModeType.READ);
            query.getResultList();
        }
        catch (TransactionRequiredException tre) {
            TestUtil.logTrace((String)"Received expected TransactionRequiredException ");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getResultListTransactionRequiredExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxResults() throws EETest.Fault {
        boolean pass = false;
        boolean found = false;
        Integer[] expected = new Integer[]{4, 1};
        try {
            TestUtil.logTrace((String)"Invoking query");
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("select d from Department d order by d.name").setMaxResults(2).getResultList();
            if (!this.checkEntityPK(q, expected)) {
                TestUtil.logErr((String)("Did not get expected results. Expected " + expected.length + " references, got: " + q.size()));
            } else {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("setMaxResults failed");
        }
    }

    public void queryAPITest16() throws EETest.Fault {
        boolean pass1 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("UPDATE Employee e SET e.salary = e.salary * 10.0 where e.salary > :minsal").setParameter("minsal", (Object)Float.valueOf(50000.0f));
            q.getResultList();
            this.getEntityTransaction().commit();
            TestUtil.logErr((String)"IllegalStateException not thrown");
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1) {
            throw new EETest.Fault("queryAPITest16 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest17() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"Invoking query");
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("DELETE FROM Employee e where e.salary > :minsal").setParameter("minsal", (Object)Float.valueOf(50000.0f));
            q.getResultList();
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("queryAPITest17 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultTest() throws EETest.Fault {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            TestUtil.logMsg((String)"Testing Query version");
            this.getEntityTransaction().begin();
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1");
            Object o = q.getSingleResult();
            if (o instanceof Employee) {
                Employee e = (Employee)o;
                if (e.getId() != 1) {
                    TestUtil.logErr((String)("Expected employee with id:1, actual:" + e.getId()));
                } else {
                    pass1 = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1", Employee.class);
            Employee e = (Employee)q.getSingleResult();
            if (e.getId() != 1) {
                TestUtil.logErr((String)("Expected employee with id:1, actual:" + e.getId()));
            } else {
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getSingleResultTest failed");
        }
    }

    public void getSingleResultIllegalStateException() throws EETest.Fault {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        this.getEntityTransaction().begin();
        TestUtil.logMsg((String)"Testing delete query");
        try {
            q = this.getEntityManager().createQuery("DELETE FROM Employee e where e.salary > 50000.0");
            q.getSingleResult();
            TestUtil.logErr((String)"IllegalStateException was not thrown");
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        TestUtil.logMsg((String)"Testing update query");
        try {
            q = this.getEntityManager().createQuery("Update Employee e SET e.salary = e.salary * 10.0");
            q.getSingleResult();
            TestUtil.logErr((String)"IllegalStateException was not thrown");
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception re) {
            TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getSingleResultIllegalStateException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdateIllegalStateException() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.id from Department d").executeUpdate();
            TestUtil.logErr((String)"IllegalStateException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.id from Department d", Integer.class).executeUpdate();
            TestUtil.logErr((String)"IllegalStateException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"IllegalStateException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("executeUpdateIllegalStateException failed");
        }
    }

    public void executeUpdateTransactionRequiredExceptionTest() throws EETest.Fault {
        boolean pass1 = false;
        TestUtil.logMsg((String)"Testing Query version");
        try {
            this.getEntityManager().createQuery("update Department d  set d.name = NULLIF(d.name, 'Engineering')").executeUpdate();
            TestUtil.logErr((String)"TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException ise) {
            TestUtil.logTrace((String)"TransactionRequiredException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1) {
            throw new EETest.Fault("executeUpdateTransactionRequiredExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest21() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Starting queryAPITest21");
            Department dept1 = (Department)this.getEntityManager().find(Department.class, (Object)1);
            dept1.setName("Research and Development");
            this.getEntityManager().createQuery("SELECT d FROM Department d WHERE d.name = 'Research and Development'").setFlushMode(FlushModeType.AUTO).getResultList();
            Department newDepartment = (Department)this.getEntityManager().find(Department.class, (Object)1);
            if (newDepartment.getName().equals("Research and Development")) {
                TestUtil.logTrace((String)"Expected results received");
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected result:Research and Development, actual:" + newDepartment.getName()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Caught exception:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("queryAPITest21 failed");
        }
    }

    public void queryAPITest22() throws EETest.Fault {
        int result_size = 0;
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Setting department name to IT for id 1");
            Query q = this.getEntityManager().createQuery("update Department d set d.name='IT' where d.id=1");
            result_size = q.executeUpdate();
            if (result_size == 1) {
                TestUtil.logTrace((String)"Updated 1 rows");
            }
            this.doFlush();
            this.clearCache();
            Department dept = (Department)this.getEntityManager().find(Department.class, (Object)1);
            if (dept != null) {
                if (dept.getId() == 1) {
                    if (dept.getName().equals("IT")) {
                        TestUtil.logTrace((String)("Received expected name:" + dept.getName()));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Received unexpected d.name =" + dept.getName()));
                    }
                } else {
                    TestUtil.logErr((String)("Received incorrect Department, expected id=1 and name=IT, actual id=" + dept.getId() + " and name=" + dept.getName()));
                }
            } else {
                TestUtil.logErr((String)"department returned was null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryAPITest22 failed");
        }
    }

    public void queryAPITest23() throws EETest.Fault {
        int result_size = 0;
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Deleting Employee where id 1");
            Query q = this.getEntityManager().createQuery("delete from Employee e where e.id=1");
            result_size = q.executeUpdate();
            if (result_size == 1) {
                TestUtil.logTrace((String)"Updated 1 rows");
            }
            this.doFlush();
            this.clearCache();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            if (emp == null) {
                TestUtil.logTrace((String)"Employee returned expected null");
                pass = true;
            } else {
                TestUtil.logErr((String)("Expected null Employee, instead got:" + emp.toString()));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryAPITest23 failed");
        }
    }

    public void queryAPITest24() throws EETest.Fault {
        int result_size = 0;
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Setting department name to IT for ids < 5");
            Query q = this.getEntityManager().createQuery("update Department d set d.name='IT' where d.id<5");
            result_size = q.executeUpdate();
            if (result_size == 4) {
                TestUtil.logTrace((String)"Updated 4 rows");
            }
            this.doFlush();
            this.clearCache();
            TestUtil.logMsg((String)"Testing ids 1 to 4");
            for (int i = 1; i < 5; ++i) {
                Department dept = (Department)this.getEntityManager().find(Department.class, (Object)i);
                if (dept != null) {
                    if (dept.getId() == i) {
                        if (dept.getName().equals("IT")) {
                            TestUtil.logTrace((String)("Received expected name:" + dept.getName()));
                            continue;
                        }
                        TestUtil.logErr((String)("Received unexpected d.name =" + dept.getName()));
                        pass = false;
                        continue;
                    }
                    TestUtil.logErr((String)("Received incorrect Department, expected id=1 and name=IT, actual id=" + dept.getId() + " and name=" + dept.getName()));
                    continue;
                }
                TestUtil.logErr((String)"department returned was null");
            }
            TestUtil.logMsg((String)"Testing id 5");
            Department dept = (Department)this.getEntityManager().find(Department.class, (Object)5);
            if (dept != null) {
                if (dept.getId() == 5) {
                    if (dept.getName().equals(this.deptRef[4].getName())) {
                        TestUtil.logTrace((String)("Received expected name:" + dept.getName()));
                    } else {
                        TestUtil.logErr((String)("Received unexpected name =" + dept.getName()));
                        pass = false;
                    }
                } else {
                    TestUtil.logErr((String)("Received incorrect Department, expected id=1 and name=IT, actual id=" + dept.getId() + " and name=" + dept.getName()));
                }
            } else {
                TestUtil.logErr((String)"department returned was null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryAPITest24 failed");
        }
    }

    public void queryAPITest25() throws EETest.Fault {
        int result_size = 0;
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Deleting Employee where id < 21");
            Query q = this.getEntityManager().createQuery("delete from Employee e where e.id<21");
            result_size = q.executeUpdate();
            if (result_size == 20) {
                TestUtil.logTrace((String)"Updated 20 rows");
            }
            this.doFlush();
            this.clearCache();
            for (int i = 1; i < 21; ++i) {
                Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)i);
                if (emp == null) {
                    TestUtil.logTrace((String)("Employee " + i + " returned was null"));
                    pass = true;
                    continue;
                }
                TestUtil.logErr((String)("Expected null Employee, instead got:" + emp.toString()));
            }
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)21);
            if (emp != null) {
                TestUtil.logTrace((String)"Employee 21 returned was expected non-null");
                pass = true;
            } else {
                TestUtil.logErr((String)"Expected non-null Employee for id 21");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("queryAPITest25 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest27() throws EETest.Fault {
        int result_size = 0;
        boolean pass1 = false;
        boolean pass2 = true;
        try {
            TestUtil.logTrace((String)"Invoking query");
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("select e.hireDate from Employee e where e.hireDate = '2000-02-14'");
            List result = q.getResultList();
            result_size = result.size();
            TestUtil.logTrace((String)("Result Size = " + result_size));
            if (result_size == 2) {
                Date expectedHireDate = Date.valueOf("2000-02-14");
                pass1 = true;
                TestUtil.logTrace((String)"Received expected count 2");
                for (Date d : result) {
                    TestUtil.logTrace((String)("date=" + d));
                    if (d.equals(expectedHireDate)) {
                        TestUtil.logTrace((String)"Received expected HireDate ");
                        continue;
                    }
                    TestUtil.logErr((String)("Received unexpected Employee HireDate = " + d.toString()));
                    pass2 = false;
                }
            } else {
                TestUtil.logTrace((String)("Received unexpected count " + result));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryAPITest27 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupDataTypes2")
    public void queryAPITest28() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = true;
        Time timeValue = this.getTimeData("10:30:15");
        TestUtil.logTrace((String)("time Value = " + timeValue.toString()));
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)("FIND D2: " + this.dateId));
            DataTypes2 dataTypes2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != dataTypes2) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting TimeData ");
                dataTypes2.setTimeData(timeValue);
                pass1 = true;
            } else {
                TestUtil.logErr((String)"Null returned during initial find");
            }
            this.getEntityManager().merge((Object)dataTypes2);
            this.doFlush();
            this.clearCache();
            TestUtil.logTrace((String)"Make sure update occurred");
            TestUtil.logTrace((String)"FIND D2 again:");
            dataTypes2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != dataTypes2) {
                if (dataTypes2.getTimeData().equals(timeValue)) {
                    TestUtil.logTrace((String)("Update occurred properly:" + dataTypes2));
                    pass2 = true;
                } else {
                    TestUtil.logErr((String)"Update did not occur properly");
                }
            } else {
                TestUtil.logErr((String)"Find returned null after update");
            }
            TestUtil.logTrace((String)"Retrieving all results first");
            List cDataTypes2 = this.getEntityManager().createQuery("select d from DataTypes2 d").getResultList();
            for (DataTypes2 d : cDataTypes2) {
                TestUtil.logTrace((String)("result:" + d.toString()));
            }
            TestUtil.logTrace((String)"Check results when testing for Time");
            List result = this.getEntityManager().createQuery("select d.timeData from DataTypes2 d where d.timeData = :time").setParameter("time", (Object)timeValue).getResultList();
            int result_size = result.size();
            TestUtil.logTrace((String)("Result Size = " + result_size));
            if (result_size == 1) {
                pass3 = true;
                TestUtil.logTrace((String)"Received expected result size");
                for (Time t : result) {
                    TestUtil.logTrace((String)("time=" + t));
                    if (t.equals(timeValue)) {
                        TestUtil.logTrace((String)"Received expected Time ");
                        continue;
                    }
                    pass4 = false;
                    TestUtil.logErr((String)("Received unexpected Time = " + t.toString()));
                }
            } else {
                TestUtil.logErr((String)("Expected 1 result, instead got: " + result_size));
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("queryAPITest28 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SetupMethod(name="setupDataTypes2")
    public void queryAPITest29() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin queryAPITest29");
        int result_size = 0;
        boolean pass1 = false;
        boolean pass2 = true;
        Timestamp tsValue = this.getTimestampData("2006-11-11");
        TestUtil.logTrace((String)("timestamp Value = " + tsValue.toString()));
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"FIND D2");
            DataTypes2 dataTypes2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != dataTypes2) {
                TestUtil.logTrace((String)"DataType Entity is not null, setting TimeData ");
                dataTypes2.setTsData(tsValue);
            }
            this.getEntityManager().merge((Object)dataTypes2);
            this.doFlush();
            this.clearCache();
            TestUtil.logTrace((String)"Check results");
            if (null != dataTypes2) {
                Query q = this.getEntityManager().createQuery("select d.tsData from DataTypes2 d where d.tsData = '2006-11-11 10:10:10'");
                List result = q.getResultList();
                result_size = result.size();
                TestUtil.logTrace((String)("Result Size = " + result_size));
                if (result_size == 1) {
                    pass1 = true;
                    TestUtil.logTrace((String)"Received expected result size");
                    for (Timestamp t : result) {
                        TestUtil.logTrace((String)("time=" + t));
                        if (t.equals(tsValue)) {
                            TestUtil.logTrace((String)"Received expected TimeStamp ");
                            continue;
                        }
                        TestUtil.logErr((String)("Received unexpected TimeStamp = " + t.toString()));
                        pass2 = false;
                    }
                } else {
                    TestUtil.logErr((String)("Did not get expected results.  Expected " + tsValue + " , got: " + dataTypes2.getTsData()));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("queryAPITest29 failed");
        }
    }

    public void getResultListIllegalStateException() throws EETest.Fault {
        boolean pass1 = false;
        boolean pass2 = false;
        TestUtil.logMsg((String)"Testing Delete");
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("DELETE FROM Employee e where e.id in (1,2,3)");
        try {
            query.getResultList();
            TestUtil.logTrace((String)"Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"Received expected IllegalStateException");
            pass1 = true;
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)ex);
        }
        TestUtil.logMsg((String)"Testing Update");
        Query q = this.getEntityManager().createQuery("Update Employee e SET e.salary=0 where e.id in (1,2,3)");
        try {
            q.getResultList();
            TestUtil.logTrace((String)"Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            TestUtil.logTrace((String)"Received expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception ex) {
            TestUtil.logErr((String)"Received unexpected exception", (Throwable)ex);
        }
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception re) {
            TestUtil.logErr((String)"Unexpected Exception while rolling back TX:", (Throwable)re);
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("getResultListIllegalStateException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noTransactionLockModeTypeNoneTest() throws EETest.Fault {
        Employee e;
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        TestUtil.logMsg((String)"Query getSingleResult test");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1");
            q.setLockMode(LockModeType.NONE);
            Object o = q.getSingleResult();
            if (o instanceof Employee) {
                e = (Employee)o;
                if (e.getId() == 1) {
                    pass1 = true;
                    TestUtil.logTrace((String)("Received expected employee id:" + e.getId()));
                } else {
                    TestUtil.logErr((String)("Expected employee with id:1, actual:" + e.getId()));
                }
            } else {
                TestUtil.logErr((String)("Received non Employee object:" + o));
            }
        }
        catch (Exception e2) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e2);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"TypedQuery getSingleResult test");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1", Employee.class);
            q.setLockMode(LockModeType.NONE);
            Employee e3 = (Employee)q.getSingleResult();
            if (e3.getId() == 1) {
                pass2 = true;
                TestUtil.logTrace((String)("Received expected employee id:" + e3.getId()));
            } else {
                TestUtil.logErr((String)("Expected employee with id:1, actual:" + e3.getId()));
            }
        }
        catch (Exception e4) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e4);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"Query getResultList test");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1");
            q.setLockMode(LockModeType.NONE);
            List c = q.getResultList();
            if (c.size() == 1) {
                Object o = c.iterator().next();
                if (o instanceof Employee) {
                    Employee e5 = (Employee)o;
                    if (e5.getId() == 1) {
                        pass3 = true;
                        TestUtil.logTrace((String)("Received expected employee id:" + e5.getId()));
                    } else {
                        TestUtil.logErr((String)("Expected employee with id:1, actual:" + e5.getId()));
                    }
                } else {
                    TestUtil.logErr((String)("Received non Employee object:" + o));
                }
            } else {
                TestUtil.logErr((String)"Got more than one result");
            }
        }
        catch (Exception e6) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e6);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        TestUtil.logMsg((String)"TypedQuery getResultList test");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1", Employee.class);
            q.setLockMode(LockModeType.NONE);
            List le = q.getResultList();
            if (le.size() == 1) {
                e = (Employee)le.get(0);
                if (e.getId() == 1) {
                    pass4 = true;
                    TestUtil.logTrace((String)("Received expected employee id:" + e.getId()));
                } else {
                    TestUtil.logErr((String)("Expected employee with id:1, actual:" + e.getId()));
                }
            } else {
                TestUtil.logErr((String)"Got more than one result");
            }
        }
        catch (Exception e7) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e7);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in while rolling back TX:", (Throwable)re);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new EETest.Fault("noTransactionLockModeTypeNoneTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        TestUtil.logTrace((String)"createTestData");
        Insurance[] insRef = new Insurance[5];
        Date d2 = this.getSQLDate("2001-06-27");
        Date d3 = this.getSQLDate("2002-07-07");
        Date d4 = this.getSQLDate("2003-03-03");
        Date d5 = this.getSQLDate("2004-04-10");
        Date d6 = this.getSQLDate("2005-02-18");
        Date d7 = this.getSQLDate("2000-09-17");
        Date d8 = this.getSQLDate("2001-11-14");
        Date d9 = this.getSQLDate("2002-10-04");
        Date d10 = this.getSQLDate("2003-01-25");
        Date d11 = this.getSQLDate();
        try {
            this.getEntityTransaction().begin();
            this.deptRef[0] = new Department(1, "Engineering");
            this.deptRef[1] = new Department(2, "Marketing");
            this.deptRef[2] = new Department(3, "Sales");
            this.deptRef[3] = new Department(4, "Accounting");
            this.deptRef[4] = new Department(5, "Training");
            TestUtil.logTrace((String)"Start to persist departments ");
            for (Department department : this.deptRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted department " + department));
            }
            insRef[0] = new Insurance(1, "Prudential");
            insRef[1] = new Insurance(2, "Cigna");
            insRef[2] = new Insurance(3, "Sentry");
            TestUtil.logTrace((String)"Start to persist insurance ");
            for (Department department : insRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted insurance " + department));
            }
            this.empRef[0] = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[0].setInsurance(insRef[0]);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[1]);
            this.empRef[1].setInsurance(insRef[1]);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[2]);
            this.empRef[2].setInsurance(insRef[2]);
            this.empRef[3] = new Employee(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[3]);
            this.empRef[3].setInsurance(insRef[0]);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[4]);
            this.empRef[4].setInsurance(insRef[1]);
            this.empRef[5] = new Employee(6, "Karen", "Tegan", d6, 80000.0f);
            this.empRef[5].setDepartment(this.deptRef[0]);
            this.empRef[5].setInsurance(insRef[2]);
            this.empRef[6] = new Employee(7, "Stephen", "Cruise", d7, 90000.0f);
            this.empRef[6].setDepartment(this.deptRef[1]);
            this.empRef[6].setInsurance(insRef[0]);
            this.empRef[7] = new Employee(8, "Irene", "Caruso", d8, 20000.0f);
            this.empRef[7].setDepartment(this.deptRef[2]);
            this.empRef[7].setInsurance(insRef[1]);
            this.empRef[8] = new Employee(9, "William", "Keaton", d9, 35000.0f);
            this.empRef[8].setDepartment(this.deptRef[3]);
            this.empRef[8].setInsurance(insRef[2]);
            this.empRef[9] = new Employee(10, "Kate", "Hudson", d10, 20000.0f);
            this.empRef[9].setDepartment(this.deptRef[4]);
            this.empRef[9].setInsurance(insRef[0]);
            this.empRef[10] = new Employee(11, "Jonathan", "Smith", d10, 40000.0f);
            this.empRef[10].setDepartment(this.deptRef[0]);
            this.empRef[10].setInsurance(insRef[1]);
            this.empRef[11] = new Employee(12, "Mary", "Macy", d9, 40000.0f);
            this.empRef[11].setDepartment(this.deptRef[1]);
            this.empRef[11].setInsurance(insRef[2]);
            this.empRef[12] = new Employee(13, "Cheng", "Fang", d8, 40000.0f);
            this.empRef[12].setDepartment(this.deptRef[2]);
            this.empRef[12].setInsurance(insRef[0]);
            this.empRef[13] = new Employee(14, "Julie", "OClaire", d7, 60000.0f);
            this.empRef[13].setDepartment(this.deptRef[3]);
            this.empRef[13].setInsurance(insRef[1]);
            this.empRef[14] = new Employee(15, "Steven", "Rich", d6, 60000.0f);
            this.empRef[14].setDepartment(this.deptRef[4]);
            this.empRef[14].setInsurance(insRef[2]);
            this.empRef[15] = new Employee(16, "Kellie", "Lee", d5, 60000.0f);
            this.empRef[15].setDepartment(this.deptRef[0]);
            this.empRef[15].setInsurance(insRef[0]);
            this.empRef[16] = new Employee(17, "Nicole", "Martin", d4, 60000.0f);
            this.empRef[16].setDepartment(this.deptRef[1]);
            this.empRef[16].setInsurance(insRef[1]);
            this.empRef[17] = new Employee(18, "Mark", "Francis", d3, 60000.0f);
            this.empRef[17].setDepartment(this.deptRef[2]);
            this.empRef[17].setInsurance(insRef[2]);
            this.empRef[18] = new Employee(19, "Will", "Forrest", d2, 60000.0f);
            this.empRef[18].setDepartment(this.deptRef[3]);
            this.empRef[18].setInsurance(insRef[0]);
            this.empRef[19] = new Employee(20, "Katy", "Hughes", this.d1, 60000.0f);
            this.empRef[19].setDepartment(this.deptRef[4]);
            this.empRef[19].setInsurance(insRef[1]);
            this.empRef[20] = new Employee(21, "Jane", "Smmith", d11, 60000.0f);
            this.empRef[20].setDepartment(this.deptRef[0]);
            this.empRef[20].setInsurance(insRef[2]);
            for (Department department : this.empRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                TestUtil.logTrace((String)("persisted employee " + department));
            }
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)"Created TestData");
        }
        catch (Exception re) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in createTestData while rolling back TX:", (Throwable)re);
            }
        }
    }

    private void createDataTypes2Data() throws Exception {
        TestUtil.logTrace((String)"createDataTypes2Data");
        try {
            this.getEntityTransaction().begin();
            DataTypes2 dT2 = new DataTypes2(this.dateId);
            dT2.setDateData(this.dateId);
            dT2.setTimeData(this.getTimeData("01:01:01"));
            this.getEntityManager().persist((Object)dT2);
            java.util.Date d = this.getUtilDate("2010-02-11");
            dT2 = new DataTypes2(d);
            dT2.setDateData(d);
            dT2.setTimeData(this.getTimeData("02:02:02"));
            this.getEntityManager().persist((Object)dT2);
            d = this.getUtilDate("2011-03-12");
            dT2 = new DataTypes2(d);
            dT2.setDateData(d);
            dT2.setTimeData(this.getTimeData("03:03:03"));
            this.getEntityManager().persist((Object)dT2);
            d = this.getUtilDate("2012-04-01");
            dT2 = new DataTypes2(d);
            dT2.setDateData(d);
            dT2.setTimeData(this.getTimeData("04:04:04"));
            this.getEntityManager().persist((Object)dT2);
            this.getEntityTransaction().commit();
            TestUtil.logTrace((String)"Created TestData");
        }
        catch (Exception re) {
            TestUtil.logErr((String)"Unexpected Exception in createTestData:", (Throwable)re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in createTestData while rolling back TX:", (Throwable)re);
            }
        }
    }

    private static void logErrorEmp(Collection c) {
        for (Object o : c) {
            Employee e = (Employee)o;
            TestUtil.logErr((String)("id=" + e.getId() + ", first=" + e.getFirstName() + ", last=" + e.getLastName() + ", hireDate=" + e.getHireDate()));
        }
    }

    private static void logTraceEmp(Collection c) {
        for (Object o : c) {
            Employee e = (Employee)o;
            TestUtil.logTrace((String)("id=" + e.getId() + ", first=" + e.getFirstName() + ", last=" + e.getLastName() + ", hireDate=" + e.getHireDate()));
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

