/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.streamMsgQueue;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.StreamMessage;
import java.util.ArrayList;
import java.util.Properties;

public class StreamMsgQueueTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core.streamMsgQueue.StreamMsgQueueTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    public static void main(String[] args) {
        StreamMsgQueueTests theTests = new StreamMsgQueueTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.user = p.getProperty("user");
            this.password = p.getProperty("password");
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' in ts.jte must not be null");
            }
            if (this.password == null) {
                throw new Exception("'password' in ts.jte must not be null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' in ts.jte must not be null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }

    public void streamMessageConversionQTestsBoolean() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsBoolean");
            this.logTrace("Verify conversion support for boolean primitive type section 3.11.3");
            messageSent.writeBoolean(abool);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readBoolean to read a boolean");
            try {
                if (messageReceived.readBoolean() == abool) {
                    this.logTrace("Pass: boolean to boolean - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readString to read a boolean");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Boolean.valueOf(abool).toString())) {
                    this.logTrace("Pass: boolean to string - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read a boolean - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                this.logMsg("Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Count returned from readBytes is : " + nCount);
            this.logMsg("--");
            this.logMsg("Use readByte to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readByte();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readShort();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readChar();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readInt();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readLong();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readFloat();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read a boolean - expect MessageFormatException");
            try {
                messageReceived.reset();
                messageReceived.readDouble();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsBoolean", e);
        }
    }

    public void streamMessageConversionQTestsByte() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsByte");
            this.logTrace("Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeByte(bValue);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readByte to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readString to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Byte.toString(bValue))) {
                    this.logTrace("Pass: byte to string - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read a byte - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Count returned from readBytes is : " + nCount);
            this.logMsg("--");
            this.logMsg("Use readByte to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == bValue) {
                    this.logTrace("Pass: byte to byte - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == bValue) {
                    this.logTrace("Pass: byte to short - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                pass = false;
                this.logMsg("Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == bValue) {
                    this.logTrace("Pass: byte to int - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)bValue) {
                    this.logTrace("Pass: byte to long - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read a boolean - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsByte", e);
        }
    }

    public void streamMessageConversionQTestsShort() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            short sValue = 1;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsShort");
            this.logTrace("Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeShort(sValue);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readBoolean to read a short - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readString to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Short.toString(sValue))) {
                    this.logTrace("Pass: short to string - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read a short - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Count returned from readBytes is : " + nCount);
            this.logMsg("--");
            this.logMsg("Use readByte to read a short - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == sValue) {
                    this.logTrace("Pass: short to short - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read a short - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a byte");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == sValue) {
                    this.logTrace("Pass: short to int - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a short");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)sValue) {
                    this.logTrace("Pass: short to long - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a short - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read a short - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsShort", e);
        }
    }

    public void streamMessageConversionQTestsInt() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsInt");
            this.logTrace("Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeInt(iValue);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readBoolean to read an int - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readString to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Integer.toString(iValue))) {
                    this.logTrace("Pass: int to string - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read an int - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Count returned from readBytes is : " + nCount);
            this.logMsg("--");
            this.logMsg("Use readByte to read an int - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read an int");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read an int - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == iValue) {
                    this.logTrace("Pass: int to int - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read an int");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == (long)iValue) {
                    this.logTrace("Pass: int to long - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read an int - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read an int - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsInt", e);
        }
    }

    public void streamMessageConversionQTestsLong() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsLong");
            this.logTrace("Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeLong(lValue);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readBoolean to read a long - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                this.logMsg("Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readString to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Long.toString(lValue))) {
                    this.logTrace("Pass: long to string - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read  a long - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Count returned from readBytes is : " + nCount);
            this.logMsg("--");
            this.logMsg("Use readByte to read an long - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a long");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read a long - this is not valid");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a long");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a long");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == lValue) {
                    this.logTrace("Pass: int to long - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a long - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read an long - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsLong", e);
        }
    }

    public void streamMessageConversionQTestsFloat() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsFloat");
            this.logTrace("Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeFloat(fValue);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readBoolean to read a float  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readString to read a float");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Float.toString(fValue))) {
                    this.logTrace("Pass: float to string - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read  a float ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Count returned from readBytes is : " + nCount);
            this.logMsg("--");
            this.logMsg("Use readByte to read a float  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a float");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read a long  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a float");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a long");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == fValue) {
                    this.logTrace("Pass: float to float - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read an float  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == (double)fValue) {
                    this.logTrace("Pass: float to double - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsFloat", e);
        }
    }

    public void streamMessageConversionQTestsDouble() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsDouble");
            this.logTrace("Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeDouble(dValue);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readBoolean to read a double  ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readString to read a double");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(Double.toString(dValue))) {
                    this.logTrace("Pass: double to string");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read  a double ");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Count returned from readBytes is : " + nCount);
            this.logMsg("--");
            this.logMsg("Use readByte to read a double  ");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a double");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read a double  ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a double");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a double");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a double  ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read a double  ");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == dValue) {
                    this.logTrace("Pass: double to double ");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsDouble", e);
        }
    }

    public void streamMessageConversionQTestsString() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            int charValue = 97;
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            String myString = "10";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsString");
            this.logTrace("Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeString(myString);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readString to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readString().equals(myString)) {
                    this.logTrace("Pass: string to string - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read a String");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Count returned from readBytes is : " + nCount);
            this.logMsg("--");
            this.logMsg("Use readByte to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readByte() == Byte.parseByte(myString)) {
                    this.logTrace("Pass: String to byte ");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a string");
            try {
                messageReceived.reset();
                if (messageReceived.readShort() == Short.parseShort(myString)) {
                    this.logTrace("Pass: String to short ");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read a String ");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readInt() == Integer.parseInt(myString)) {
                    this.logTrace("Pass: String to int ");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readLong() == Long.parseLong(myString)) {
                    this.logTrace("Pass: String to long ");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readFloat() == Float.parseFloat(myString)) {
                    this.logTrace("Pass: String to float ");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read a String");
            try {
                messageReceived.reset();
                if (messageReceived.readDouble() == Double.parseDouble(myString)) {
                    this.logTrace("Pass: String to double ");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBoolean to read a string ");
            try {
                messageReceived.clearBody();
                messageReceived.writeString("true");
                messageReceived.reset();
                if (messageReceived.readBoolean() == abool) {
                    this.logTrace("Pass: String to boolean ");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBoolean to read a string  that is !true ");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                if (!b) {
                    this.logMsg("Fail: !true should return false");
                    pass = false;
                } else {
                    this.logTrace("Pass: !true returned false");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsString", e);
        }
    }

    public void streamMessageConversionQTestsChar() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{0};
            char charValue = 'a';
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsChar");
            this.logTrace("Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeChar(charValue);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readBoolean to read a char - this is not valid");
            try {
                messageReceived.reset();
                boolean b = messageReceived.readBoolean();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readString to read a char");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                this.logTrace("char returned for \"a\" is : " + s);
                if (s.equals("a")) {
                    this.logTrace("Pass: char to string - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read a char - expect MessageFormatException");
            int nCount = 0;
            try {
                messageReceived.reset();
                nCount = messageReceived.readBytes(bValues);
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("Count returned from readBytes is : " + nCount);
            this.logMsg("--");
            this.logMsg("Use readByte to read a char - this is not valid");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a char");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read a char ");
            try {
                messageReceived.reset();
                if (messageReceived.readChar() == 'a') {
                    this.logTrace("Pass: char to char - valid");
                } else {
                    this.logMsg("Fail: wrong value returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a char ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                this.logMsg("Fail: MessageFormatException was not thrown");
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a char");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a char - this is not valid");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read a char - this is not valid");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsChar", e);
        }
    }

    public void streamMessageConversionQTestsBytes() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            int bValue = 127;
            boolean abool = true;
            byte[] bValues = new byte[]{1, 2, 3};
            byte[] bValues2 = new byte[]{0, 0, 0};
            boolean sValue = true;
            long lValue = 2L;
            double dValue = 3.0;
            float fValue = 5.0f;
            int iValue = 6;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsBytes");
            this.logTrace("Verify conversion support for byte[] primitive type section 3.11.3");
            messageSent.writeBytes(bValues);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readBytes[] to read a byte[] ");
            boolean nCount = false;
            try {
                messageReceived.reset();
                if (messageReceived.readBytes(bValues2) == 3) {
                    this.logTrace("Pass: byte[] to byte[] - valid");
                } else {
                    this.logMsg("Fail: count incorrect");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readBoolean to read a byte[]");
            messageReceived.reset();
            try {
                boolean b = messageReceived.readBoolean();
                this.logMsg("Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readString to read a byte[]");
            try {
                messageReceived.reset();
                String s = messageReceived.readString();
                this.logMsg("Fail: byte[] to boolean conversion should have thrown MessageFormatException");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readByte to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                byte b = messageReceived.readByte();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readChar to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                char c = messageReceived.readChar();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read a byte[] - expect MessageFormatException");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                this.logMsg("Fail: MessageFormatException was not thrown");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof MessageFormatException) {
                    this.logTrace("Pass: MessageFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsBytes", e);
        }
    }

    public void streamMessageConversionQTestsInvFormatString() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            String myString = "mytest string";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageConversionQTestsInvFormatString");
            this.logTrace("Verify conversion support for byte primitive type section 3.11.3");
            messageSent.writeString(myString);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("--");
            this.logMsg("Use readByte to read a String that is not valid ");
            try {
                byte b = messageReceived.readByte();
                this.logMsg("Fail: java.lang.NumberFormatException expected");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof NumberFormatException) {
                    this.logTrace("Pass: NumberFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Verify that the data can be read as a string and pointer did not move");
            try {
                String s = messageReceived.readString();
                this.logTrace("message read: " + s);
                if (s.equals(myString)) {
                    this.logTrace("Pass: able to read the string");
                } else {
                    this.logMsg("Fail: string not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readShort to read a string that is not valid ");
            try {
                messageReceived.reset();
                short s = messageReceived.readShort();
                this.logMsg("Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof NumberFormatException) {
                    this.logTrace("Pass: NumberFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readInt to read a String that is not valid ");
            try {
                messageReceived.reset();
                int i = messageReceived.readInt();
                this.logMsg("Fail: NumberFormatException was expected");
            }
            catch (Exception e) {
                if (e instanceof NumberFormatException) {
                    this.logTrace("Pass: NumberFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readLong to read a String that is not valid ");
            try {
                messageReceived.reset();
                long l = messageReceived.readLong();
                this.logMsg("Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof NumberFormatException) {
                    this.logTrace("Pass: NumberFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readFloat to read a String that is not valid ");
            try {
                messageReceived.reset();
                float f = messageReceived.readFloat();
                this.logMsg("Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof NumberFormatException) {
                    this.logTrace("Pass: NumberFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            this.logMsg("--");
            this.logMsg("Use readDouble to read a String that is not valid ");
            try {
                messageReceived.reset();
                double d = messageReceived.readDouble();
                this.logMsg("Fail: NumberFormatException was expected");
                pass = false;
            }
            catch (Exception e) {
                if (e instanceof NumberFormatException) {
                    this.logTrace("Pass: NumberFormatException thrown as expected");
                }
                this.logErr("Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageConversionQTestsInvFormatString", e);
        }
    }

    public void streamMessageQTestsFullMsg() throws EETest.Fault {
        try {
            int i;
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            byte bValue = 127;
            boolean abool = false;
            byte[] bValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
            byte[] bValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
            byte[] bValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            byte[] bValuesReturned2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            char charValue = 'Z';
            short sValue = Short.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = 6;
            boolean pass = true;
            String myString = "text";
            String sTesting = "Testing StreamMessages";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.logTrace("Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageQTestsFullMsg");
            this.logTrace("");
            messageSent.writeBytes(bValues2, 0, bValues.length);
            messageSent.writeBoolean(abool);
            messageSent.writeByte(bValue);
            messageSent.writeBytes(bValues);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(dValue);
            messageSent.writeFloat(fValue);
            messageSent.writeInt(iValue);
            messageSent.writeLong(lValue);
            messageSent.writeObject((Object)sTesting);
            messageSent.writeShort(sValue);
            messageSent.writeString(myString);
            messageSent.writeObject(null);
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                int nCount;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned2);
                    this.logTrace("nCount is " + nCount);
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned2.length; ++i) {
                        if (bValuesReturned2[i] != bValues2[i]) {
                            this.logMsg("Fail: byte[] " + i + " is not valid");
                            pass = false;
                            continue;
                        }
                        this.logTrace("PASS: byte[]" + i + " is valid");
                    }
                } while (nCount >= bValuesReturned2.length);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readBoolean() == abool) {
                    this.logTrace("Pass: boolean returned ok");
                } else {
                    this.logMsg("Fail: boolean not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readByte() == bValue) {
                    this.logTrace("Pass: Byte returned ok");
                } else {
                    this.logMsg("Fail: Byte not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int nCount;
                do {
                    nCount = messageReceived.readBytes(bValuesReturned);
                    this.logTrace("nCount is " + nCount);
                    if (nCount == -1) continue;
                    for (i = 0; i < bValuesReturned2.length; ++i) {
                        if (bValuesReturned2[i] != bValues2[i]) {
                            this.logMsg("Fail: byte[] " + i + " is not valid");
                            pass = false;
                            continue;
                        }
                        this.logTrace("PASS: byte[]" + i + " is valid");
                    }
                } while (nCount >= bValuesReturned2.length);
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readChar() == charValue) {
                    this.logTrace("Pass: correct char");
                } else {
                    this.logMsg("Fail: char not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readDouble() == dValue) {
                    this.logTrace("Pass: correct double");
                } else {
                    this.logMsg("Fail: double not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readFloat() == fValue) {
                    this.logTrace("Pass: correct float");
                } else {
                    this.logMsg("Fail: float not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readInt() == iValue) {
                    this.logTrace("Pass: correct int");
                } else {
                    this.logMsg("Fail: int not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readLong() == lValue) {
                    this.logTrace("Pass: correct long");
                } else {
                    this.logMsg("Fail: long not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readObject().equals(sTesting)) {
                    this.logTrace("Pass: correct object");
                } else {
                    this.logMsg("Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readShort() == sValue) {
                    this.logTrace("Pass: correct short");
                } else {
                    this.logMsg("Fail: short not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readString().equals(myString)) {
                    this.logTrace("Pass: correct string");
                } else {
                    this.logMsg("Fail: string not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readObject() == null) {
                    this.logTrace("Pass: correct object");
                } else {
                    this.logMsg("Fail: object not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageQTestsFullMsg", e);
        }
    }

    public void streamMessageQTestNull() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageQTestNull");
            this.logTrace("writeString(null) ");
            try {
                messageSent.writeString(null);
            }
            catch (Exception e) {
                this.logErr("unexpected exception " + e.getClass().getName() + " was thrown");
                throw new EETest.Fault("Error: failed to write a null object with writeString", e);
            }
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("  ");
            try {
                if (messageReceived.readObject() == null) {
                    this.logTrace("Pass: Read a null");
                } else {
                    this.logMsg("Fail: null value not returned");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                this.logErr("trying to read a null object");
                this.logErr("unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new EETest.Fault("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageQTestNull", e);
        }
    }

    public void streamMessageQNotWritable() throws EETest.Fault {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            short sValue = Short.MAX_VALUE;
            char cValue = '\uffff';
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            float fValue = 0.0f;
            double dValue = -0.0;
            String ssValue = "abc";
            byte[] bbValue = new byte[]{0, 88, 127};
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "streamMessageQNotWritable");
            try {
                messageSent.writeString("Test Message for streamMessageQNotWritable");
            }
            catch (Exception e) {
                this.logErr("unexpected exception " + e.getClass().getName() + " was thrown");
                throw new EETest.Fault("Error: failed to writeString", e);
            }
            this.logTrace("Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            this.logTrace("Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            this.logMsg("Writing a boolean ... ");
            try {
                messageReceived.writeBoolean(pass);
                this.logErr("Shouldn't get here");
                throw new EETest.Fault("Error: test failed to be able to writeBoolean");
            }
            catch (MessageNotWriteableException e) {
                this.logMsg("Got Expected MessageNotWriteableException with writeBoolean");
                this.logMsg("Writing a byte ... ");
                try {
                    messageReceived.writeByte(bValue);
                    this.logErr("Shouldn't get here");
                    throw new EETest.Fault("Error: test failed to be able to writeByte");
                }
                catch (MessageNotWriteableException e2) {
                    this.logMsg("Got Expected MessageNotWriteableException with writeByte");
                    this.logMsg("Writing a short ... ");
                    try {
                        messageReceived.writeShort(sValue);
                        this.logErr("Shouldn't get here");
                        throw new EETest.Fault("Error: test failed to be able to writeShort");
                    }
                    catch (MessageNotWriteableException e3) {
                        this.logMsg("Got Expected MessageNotWriteableException with writeShort");
                        this.logMsg("Writing a char ... ");
                        try {
                            messageReceived.writeChar(cValue);
                            this.logErr("Shouldn't get here");
                            throw new EETest.Fault("Error: test failed to be able to writeChar");
                        }
                        catch (MessageNotWriteableException e4) {
                            this.logMsg("Got Expected MessageNotWriteableException with writeChar");
                            this.logMsg("Writing a int ... ");
                            try {
                                messageReceived.writeInt(iValue);
                                this.logErr("Shouldn't get here");
                                throw new EETest.Fault("Error: test failed to be able to writeInt");
                            }
                            catch (MessageNotWriteableException e5) {
                                this.logMsg("Got Expected MessageNotWriteableException with writeInt");
                                this.logMsg("Writing a long ... ");
                                try {
                                    messageReceived.writeLong(lValue);
                                    this.logErr("Shouldn't get here");
                                    throw new EETest.Fault("Error: test failed to be able to writeLong");
                                }
                                catch (MessageNotWriteableException e6) {
                                    this.logMsg("Got Expected MessageNotWriteableException with writeLong");
                                    this.logMsg("Writing a float ... ");
                                    try {
                                        messageReceived.writeFloat(fValue);
                                        this.logErr("Shouldn't get here");
                                        throw new EETest.Fault("Error: test failed to be able to writeFloat");
                                    }
                                    catch (MessageNotWriteableException e7) {
                                        this.logMsg("Got Expected MessageNotWriteableException with writeFloat");
                                        this.logMsg("Writing a double ... ");
                                        try {
                                            messageReceived.writeDouble(dValue);
                                            this.logErr("Shouldn't get here");
                                            throw new EETest.Fault("Error: test failed to be able to writeDouble");
                                        }
                                        catch (MessageNotWriteableException e8) {
                                            this.logMsg("Got Expected MessageNotWriteableException with writeDouble");
                                            this.logMsg("Writing a bytes... ");
                                            try {
                                                messageReceived.writeBytes(bbValue);
                                                this.logErr("Shouldn't get here");
                                                throw new EETest.Fault("Error: test failed to be able to writeBytes");
                                            }
                                            catch (MessageNotWriteableException e9) {
                                                this.logMsg("Got Expected MessageNotWriteableException with writeBytes");
                                                this.logMsg("Writing a string ... ");
                                                try {
                                                    messageReceived.writeString(ssValue);
                                                    this.logErr("Shouldn't get here");
                                                    throw new EETest.Fault("Error: test failed to be able to writeString");
                                                }
                                                catch (MessageNotWriteableException e10) {
                                                    this.logMsg("Got Expected MessageNotWriteableException with writeString");
                                                    this.logMsg("Writing a object ... ");
                                                    try {
                                                        messageReceived.writeObject((Object)new Integer(iValue));
                                                        this.logErr("Shouldn't get here");
                                                        throw new EETest.Fault("Error: test failed to be able to writeObject");
                                                    }
                                                    catch (MessageNotWriteableException e11) {
                                                        this.logMsg("Got Expected MessageNotWriteableException with writeObject");
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("streamMessageQNotWritable", e);
        }
    }
}

