/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateless.cm.allowedmethodstest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.cm.allowedmethodstest.Helper;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.TimedObject;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerService;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;

public class TestBeanEJB
implements SessionBean,
TimedObject {
    private SessionContext sctx = null;
    private TSNamingContext nctx = null;
    private Helper helperRef = null;
    private String role = "Administrator";
    private Hashtable table = new Hashtable();
    private static final String testLookup = "java:comp/env/ejb/Helper";
    private UserTransaction ut;
    private static final String[] tests = new String[]{"ejbCreate", "setSessionContext", "businessMethod"};
    private static final Properties[] methodList = new Properties[]{new Properties(), new Properties(), new Properties()};

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.doOperationTests("ejbCreate");
    }

    public void setSessionContext(SessionContext sc) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sc;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("Unable to obtain NamingContext");
        }
        this.doOperationTests("setSessionContext");
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbTimeout(Timer timer) {
        TestUtil.logTrace((String)"ejbTimeout");
    }

    public Hashtable getResults() {
        TestUtil.logTrace((String)"getResults");
        return this.table;
    }

    public void businessMethod(Helper ref) {
        TestUtil.logTrace((String)"businessMethod");
        this.doOperationTests("businessMethod");
        try {
            ref.setData(this.table);
        }
        catch (RemoteException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new EJBException(re.getMessage());
        }
    }

    public void setHelper(Helper ref) {
        TestUtil.logTrace((String)"setHelper");
        this.helperRef = ref;
    }

    public void txNotSupported(Helper ref) {
        TestUtil.logTrace((String)"txNotSupported");
        this.doOperationTests("businessMethod");
        try {
            ref.setData(this.table);
        }
        catch (RemoteException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new EJBException(re.getMessage());
        }
    }

    public void txSupports(Helper ref) {
        TestUtil.logTrace((String)"txSupports");
        this.doOperationTests("businessMethod");
        try {
            ref.setData(this.table);
        }
        catch (RemoteException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new EJBException(re.getMessage());
        }
    }

    public void txNever(Helper ref) {
        TestUtil.logTrace((String)"txNever");
        this.doOperationTests("businessMethod");
        try {
            ref.setData(this.table);
        }
        catch (RemoteException re) {
            TestUtil.printStackTrace((Throwable)re);
            throw new EJBException(re.getMessage());
        }
    }

    private int testIndex(String s) {
        TestUtil.logTrace((String)"testIndex");
        for (int i = 0; i < tests.length; ++i) {
            if (!s.equals(tests[i])) continue;
            return i;
        }
        return -1;
    }

    private void setTestList(int i) {
        TestUtil.logTrace((String)"setTestList");
        methodList[i].setProperty("getEJBHome", "true");
        methodList[i].setProperty("getCallerPrincipal", "true");
        methodList[i].setProperty("isCallerInRole", "true");
        methodList[i].setProperty("getEJBObject", "true");
        methodList[i].setProperty("JNDI_Access", "true");
        methodList[i].setProperty("UserTransaction", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test1", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test2", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test3", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test4", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test5", "true");
        methodList[i].setProperty("UserTransaction_Methods_Test6", "true");
        methodList[i].setProperty("getEJBLocalHome", "true");
        methodList[i].setProperty("getEJBLocalObject", "true");
        methodList[i].setProperty("getTimerService", "true");
        methodList[i].setProperty("TimerService_Methods_Test1", "true");
        methodList[i].setProperty("TimerService_Methods_Test2", "true");
        methodList[i].setProperty("TimerService_Methods_Test3", "true");
        methodList[i].setProperty("TimerService_Methods_Test4", "true");
        methodList[i].setProperty("TimerService_Methods_Test5", "true");
        methodList[i].setProperty("TimerService_Methods_Test6", "true");
        methodList[i].setProperty("TimerService_Methods_Test7", "true");
        methodList[i].setProperty("getMessageContext", "true");
        methodList[i].setProperty("getRollbackOnly", "true");
        methodList[i].setProperty("setRollbackOnly", "true");
    }

    private void doOperationTests(String s) {
        Date d;
        TestUtil.logTrace((String)"doOperationTests");
        int i = this.testIndex(s);
        TestUtil.logMsg((String)("index for " + s + " is " + i));
        TestUtil.logMsg((String)("methodList length=" + methodList.length));
        TestUtil.logMsg((String)("tests length=" + tests.length));
        this.setTestList(i);
        TestUtil.logMsg((String)("Operations testing for " + s + " method ..."));
        try {
            this.sctx.getEJBHome();
            TestUtil.logMsg((String)"Operations test: getEJBHome() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBHome", "false");
            TestUtil.logMsg((String)"Operations test: getEJBHome() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBHome", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBHome() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getCallerPrincipal();
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getCallerPrincipal", "false");
            TestUtil.logMsg((String)"Operations test: getCallerPrincipal() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getCallerPrincipal", "unexpected");
            TestUtil.logMsg((String)("Operations test: getCallerPrincipal() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.isCallerInRole(this.role);
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("isCallerInRole", "false");
            TestUtil.logMsg((String)"Operations test: isCallerInRole() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("isCallerInRole", "unexpected");
            TestUtil.logMsg((String)("Operations test: isCallerInRole() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBObject();
            TestUtil.logMsg((String)"Operations test: getEJBObject() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBObject", "false");
            TestUtil.logMsg((String)"Operations test: getEJBObject() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBObject", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBObject() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            Context ctx = (Context)this.nctx.lookup("java:comp/env");
            TestUtil.logMsg((String)"Operations test: JNDI_Access - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("JNDI_Access", "false");
            TestUtil.logMsg((String)"Operations test: JNDI_Access - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("JNDI_Access", "unexpected");
            TestUtil.logMsg((String)("Operations test: JNDI_Access - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.ut = this.sctx.getUserTransaction();
            TestUtil.logMsg((String)"Operations test: UserTransaction - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().begin();
            TestUtil.logMsg((String)"Operations test: UserTransaction.begin - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test1", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.begin - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test1", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.begin - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().commit();
            TestUtil.logMsg((String)"Operations test: UserTransaction.commit - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test2", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.commit - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test2", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.commit - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().getStatus();
            TestUtil.logMsg((String)"Operations test: UserTransaction.getStatus - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test3", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.getStatus - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test3", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.getStatus - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().rollback();
            TestUtil.logMsg((String)"Operations test: UserTransaction.rollback - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test4", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.rollback - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test4", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.rollback - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().setRollbackOnly();
            TestUtil.logMsg((String)"Operations test: UserTransaction.setRollbackOnly - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test5", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.setRollbackOnly - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test5", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.setRollbackOnly - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getUserTransaction().setTransactionTimeout(5);
            TestUtil.logMsg((String)"Operations test: UserTransaction.setTransactionTimeout - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("UserTransaction_Methods_Test6", "false");
            TestUtil.logMsg((String)"Operations test: UserTransaction.setTransactionTimeout - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("UserTransaction_Methods_Test6", "unexpected");
            TestUtil.logMsg((String)("Operations test: UserTransaction.setTransactionTimeout - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBLocalHome();
            TestUtil.logMsg((String)"Operations test: getEJBLocalHome() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBLocalHome", "false");
            TestUtil.logMsg((String)"Operations test: getEJBLocalHome() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBLocalHome", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBLocalHome() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getEJBLocalObject();
            TestUtil.logMsg((String)"Operations test: getEJBLocalObject() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getEJBLocalObject", "false");
            TestUtil.logMsg((String)"Operations test: getEJBLocalObject() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getEJBLocalObject", "unexpected");
            TestUtil.logMsg((String)("Operations test: getEJBLocalObject() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getTimerService();
            TestUtil.logMsg((String)"Operations test: getTimerService() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getTimerService", "false");
            TestUtil.logMsg((String)"Operations test: getTimerService() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getTimerService", "unexpected");
            TestUtil.logMsg((String)("Operations test: getTimerService() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService timesrv = this.sctx.getTimerService();
            Timer tt = timesrv.createTimer(10000L, (Serializable)((Object)"test1"));
            tt.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test1() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test1", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test1() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test1", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test1() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService timesrv2 = this.sctx.getTimerService();
            Timer t2 = timesrv2.createTimer(10000L, 10000L, (Serializable)((Object)"test2"));
            t2.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test2() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test2", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test2() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test2", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test2() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            long expiration = System.currentTimeMillis() + 900000L;
            d = new Date(expiration);
            TimerService timesrv3 = this.sctx.getTimerService();
            Timer t3 = timesrv3.createTimer(d, (Serializable)((Object)"test3"));
            t3.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test3() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test3", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test3() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test3", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test3() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            long expiration = System.currentTimeMillis() + 900000L;
            d = new Date(expiration);
            TimerService timesrv4 = this.sctx.getTimerService();
            Timer t4 = timesrv4.createTimer(d, 10000L, (Serializable)((Object)"test4"));
            t4.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test4() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test4", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test4() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test4", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test4() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService ts = this.sctx.getTimerService();
            Collection ccol = ts.getTimers();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test5() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test5", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test5() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test5", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test5() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService timesrv6 = this.sctx.getTimerService();
            Timer t6 = timesrv6.createTimer(10000L, (Serializable)((Object)"test6"));
            t6.getHandle();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test6() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test6", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test6() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test6", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test6() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            TimerService timesrv7 = this.sctx.getTimerService();
            Timer t7 = timesrv7.createTimer(10000L, (Serializable)((Object)"test7"));
            t7.cancel();
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test7() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("TimerService_Methods_Test7", "false");
            TestUtil.logMsg((String)"Operations test: TimerService_Methods_Test7() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("TimerService_Methods_Test7", "unexpected");
            TestUtil.logMsg((String)("Operations test: TimerService_Methods_Test7() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.getRollbackOnly();
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("getRollbackOnly", "false");
            TestUtil.logMsg((String)"Operations test: getRollbackOnly() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("getRollbackOnly", "unexpected");
            TestUtil.logMsg((String)("Operations test: getRollbackOnly() - not allowed (Unexpected Exception) - " + e));
        }
        try {
            this.sctx.setRollbackOnly();
            TestUtil.logMsg((String)"Operations test: setRollbackOnly() - allowed");
        }
        catch (IllegalStateException e) {
            methodList[i].setProperty("setRollbackOnly", "false");
            TestUtil.logMsg((String)"Operations test: setRollbackOnly() - not allowed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            methodList[i].setProperty("setRollbackOnly", "unexpected");
            TestUtil.logMsg((String)("Operations test: setRollbackOnly() - not allowed (Unexpected Exception) - " + e));
        }
        this.table.put(s, methodList[i]);
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    public void findAndCancelTimer() {
        try {
            TestUtil.logTrace((String)"findTimer method entered");
            TimerService ts = this.sctx.getTimerService();
            TestUtil.logTrace((String)"find Timers");
            Collection ccol = ts.getTimers();
            for (Timer t : ccol) {
                t.cancel();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("findTimer:" + e);
        }
    }

    public boolean getCallerPrincipalTest(String s) {
        TestUtil.logTrace((String)"getCallerPrincipalTest");
        try {
            Principal principal = this.sctx.getCallerPrincipal();
            if (principal != null) {
                TestUtil.logMsg((String)("getCallerPrincipal() returned Principal: " + principal));
                String name = principal.getName();
                if (name.indexOf(s) < 0) {
                    TestUtil.logErr((String)("principal - expected: " + s + ", received: " + name));
                    return false;
                }
                return true;
            }
            TestUtil.logErr((String)"getCallerPrincipal() returned null reference");
            return false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

