/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.sharedclients;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;

public class HttpClient
implements Serializable {
    private static final String DEFAULT_CHARSET = "UTF-8";
    public static final String HTTP_METHOD_GET = "GET";
    public static final String HTTP_METHOD_POST = "POST";
    private String method = "POST";
    private HashMap headers = new HashMap();
    private String url;
    private Charset cs;
    private HttpURLConnection conn;

    public HttpClient() throws EETest.Fault {
        this.headers.put("SOAPAction", "\"\"");
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Charset getCharset() {
        return this.cs;
    }

    public void setCharset(Charset cs) {
        this.cs = cs;
    }

    private String getCharsetAsName() {
        if (this.cs == null) {
            return DEFAULT_CHARSET;
        }
        return this.cs.name().toUpperCase();
    }

    public void setMethod(String method) {
        this.method = method != null ? method : HTTP_METHOD_POST;
    }

    public String getMethod() {
        return this.method;
    }

    public void addHeader(String name, String value) {
        String current = (String)this.headers.get(name = this.properCase(name));
        if (current != null) {
            value = current + ", " + value;
        }
        this.headers.put(name, value);
    }

    public void setHeader(String name, String value) {
        this.headers.put(this.properCase(name), value);
    }

    public void setHeaderCaseAsIs(String name, String value) {
        this.headers.put(name, value);
    }

    public int getStatusCode() throws IOException {
        return this.conn.getResponseCode();
    }

    public String getStatusMessage() throws IOException {
        return this.conn.getResponseMessage();
    }

    public InputStream makeRequest(InputStream messageContent) throws IOException {
        String name = this.getCharsetAsName();
        TestUtil.logMsg((String)("Charset name=" + name));
        this.addHeader("Content-Type", "text/xml; charset=" + name);
        this.conn = (HttpURLConnection)new URL(this.url).openConnection();
        this.sendRequest(messageContent);
        return this.receiveResponse();
    }

    protected void sendRequest(InputStream is) throws IOException {
        this.conn.setRequestMethod(this.method);
        for (String name : this.headers.keySet()) {
            String value = (String)this.headers.get(name);
            TestUtil.logMsg((String)("Setting HTTP_HEADER: " + name + "=" + value));
            this.conn.setRequestProperty(name, value);
        }
        if (is != null) {
            this.conn.setDoOutput(true);
            OutputStream os = this.conn.getOutputStream();
            this.transfer(is, os);
        }
    }

    protected InputStream receiveResponse() throws IOException {
        byte[] response;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            InputStream is;
            try {
                is = this.conn.getInputStream();
            }
            catch (IOException e) {
                is = this.conn.getErrorStream();
            }
            if (is == null) {
                return null;
            }
            this.transfer(is, os);
            response = os.toByteArray();
        }
        catch (IOException e) {
            TestUtil.printStackTrace((Throwable)e);
            response = null;
        }
        return response != null ? new ByteArrayInputStream(response) : null;
    }

    protected void transfer(InputStream is, OutputStream os) throws IOException {
        int length;
        byte[] buffer = new byte[1024];
        do {
            try {
                length = is.read(buffer);
                if (length <= 0) continue;
                os.write(buffer, 0, length);
            }
            catch (IOException e) {
                return;
            }
        } while (length > 0);
        os.flush();
    }

    protected String properCase(String name) {
        StringBuffer buffer = new StringBuffer(name.length());
        int previous = 45;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (previous == 45) {
                buffer.append(Character.toUpperCase(c));
            } else {
                buffer.append(Character.toLowerCase(c));
            }
            previous = c;
        }
        return buffer.toString();
    }

    public void logMessageInHarness(InputStream message) {
    }

    public String getResponseHeader(String name) {
        return this.conn.getHeaderField(name);
    }
}

