/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.entitytest.cascadeall.manyXmany;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.entitytest.cascadeall.manyXmany.A;
import com.sun.ts.tests.jpa.core.entitytest.cascadeall.manyXmany.B;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMXMTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMXMTest1");
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("1", "b1", 1);
            B b2 = new B("2", "b2", 1);
            B b3 = new B("3", "b3", 1);
            B b4 = new B("4", "b4", 1);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("1", "bean1", 1, v1);
            this.createA(aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                pass = true;
            } else {
                TestUtil.logErr((String)"Test failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMXMTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMXMTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMXMTest2");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("1", "b1", 2);
            B b2 = new B("2", "b2", 2);
            B b3 = new B("3", "b3", 2);
            B b4 = new B("4", "b4", 2);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            A aRef = new A("2", "bean2", 2, v1);
            this.getEntityManager().persist((Object)aRef);
            Collection newCol = aRef.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    A newA = this.findA("2");
                    TestUtil.logTrace((String)"Remove newA ");
                    this.getEntityManager().remove((Object)newA);
                    this.getEntityManager().flush();
                    TestUtil.logTrace((String)"Persist a removed entity ");
                    this.getEntityManager().persist((Object)newA);
                    pass = this.getInstanceStatus(newA);
                }
                catch (Exception ee) {
                    TestUtil.logErr((String)"Unexpected exception trying to persist a removed entity", (Throwable)ee);
                    pass = false;
                }
            } else {
                TestUtil.logTrace((String)"Instance is not already persisted. Test Fails.");
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMXMTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMXMTest3() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"New instances");
            B b1 = new B("4", "b4", 4);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            A aRef = new A("4", "bean4", 4, v1);
            this.createA(aRef);
            this.getEntityTransaction().begin();
            A a2 = this.findA("4");
            if (this.getEntityManager().contains((Object)a2)) {
                a2.setAName("newBean4");
                this.getEntityManager().flush();
                TestUtil.logTrace((String)("getAName returns: " + a2.getAName()));
                if (a2.getAName().equals("newBean4")) {
                    pass = true;
                }
            } else {
                TestUtil.logErr((String)"Entity not managed - test fails.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMXMTest3 failed");
        }
    }

    public void cascadeAllMXMTest4() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMXMTest4");
        boolean pass = false;
        try {
            B b1 = new B("1", "b1", 5);
            B b2 = new B("2", "b2", 5);
            B b3 = new B("3", "b3", 5);
            B b4 = new B("4", "b4", 5);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("5", "bean5", 5, v1);
            this.getEntityManager().persist((Object)a1);
            Collection newCol = a1.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    TestUtil.logTrace((String)"Remove instances");
                    this.getEntityManager().remove((Object)this.findB("1"));
                    this.getEntityManager().remove((Object)this.findB("2"));
                    this.getEntityManager().remove((Object)this.findB("3"));
                    this.getEntityManager().remove((Object)this.findB("4"));
                    this.getEntityManager().remove((Object)a1);
                    if (!this.getEntityManager().contains((Object)a1)) {
                        pass = true;
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception fe) {
                    TestUtil.logErr((String)"Unexpected exception caught trying to remove entity instance :", (Throwable)fe);
                }
            } else {
                TestUtil.logErr((String)"Test failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMXMTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMXMTest5() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMXMTest5");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New B instances");
            B b1 = new B("1", "b1", 6);
            B b2 = new B("2", "b2", 6);
            B b3 = new B("3", "b3", 6);
            B b4 = new B("4", "b4", 6);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("6", "bean6", 6, v1);
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            A a2 = this.findA("6");
            Collection newCol = a2.getBCol();
            this.dumpCollectionDataB(newCol);
            if (newCol.contains(b1) && newCol.contains(b2) && newCol.contains(b3) && newCol.contains(b4)) {
                try {
                    pass = this.getInstanceStatus(a2);
                }
                catch (Exception e) {
                    TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception fe) {
            TestUtil.logErr((String)("Unexpected exception caught trying to remove entity instance :" + fe));
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMXMTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMXMTest6() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMXMTest6");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New B instances");
            B b1 = new B("1", "b1", 7);
            B b2 = new B("2", "b2", 7);
            B b3 = new B("3", "b3", 7);
            B b4 = new B("4", "b4", 7);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("7", "bean7", 7, v1);
            this.getEntityManager().persist((Object)a1);
            pass = this.getInstanceStatus(a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMXMTest6 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMXMTest7() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMXMTest7");
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New A instance");
            B b1 = new B("1", "b1", 8);
            B b2 = new B("2", "b2", 8);
            B b3 = new B("3", "b3", 8);
            B b4 = new B("4", "b4", 8);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            TestUtil.logTrace((String)"New B instances");
            A a1 = new A("8", "bean8", 8, v1);
            this.getEntityManager().persist((Object)a1);
            pass = this.getEntityManager().contains((Object)b1) && this.getEntityManager().contains((Object)b2) && this.getEntityManager().contains((Object)b3) && this.getEntityManager().contains((Object)b4);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMXMTest7 failed");
        }
    }

    public void cascadeAllMXMTest8() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMXMTest8");
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            B b1 = new B("1", "b1", 9);
            B b2 = new B("2", "b2", 9);
            B b3 = new B("3", "b3", 9);
            B b4 = new B("4", "b4", 9);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("9", "bean9", 9, v1);
            pass = this.getInstanceStatus(a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (pass) {
            throw new EETest.Fault("cascadeAllMXMTest8 failed");
        }
    }

    public void cascadeAllMXMTest9() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin cascadeAllMXMTest9");
        boolean pass1 = true;
        boolean pass2 = true;
        boolean pass = true;
        try {
            B b1 = new B("1", "b1", 10);
            B b2 = new B("2", "b2", 10);
            B b3 = new B("3", "b3", 10);
            B b4 = new B("4", "b4", 10);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("10", "bean10", 10, v1);
            pass1 = !this.getEntityManager().contains((Object)b1) && !this.getEntityManager().contains((Object)b2) && !this.getEntityManager().contains((Object)b3) && !this.getEntityManager().contains((Object)b4);
            pass2 = this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!(pass1 || pass2 || pass)) {
            TestUtil.logErr((String)("pass=" + pass + ", pass1=" + pass1 + ", pass2=" + pass2));
            throw new EETest.Fault("cascadeAllMXMTest9 failed");
        }
    }

    public void cascadeAllMXMTest10() throws EETest.Fault {
        boolean pass = false;
        B bRef1 = null;
        try {
            this.getEntityTransaction().begin();
            A a1 = new A("11", "a11", 11);
            B bRef = new B("11", "bean11", 11);
            this.getEntityManager().persist((Object)bRef);
            if (this.getEntityManager().contains((Object)bRef)) {
                bRef1 = this.findB("11");
                Vector<A> v1 = new Vector<A>();
                v1.add(a1);
                bRef1.setACol(v1);
                this.getEntityManager().persist((Object)bRef1);
                this.getEntityManager().flush();
                pass = this.getEntityManager().contains((Object)a1);
                TestUtil.logTrace((String)"try to find A");
                A a2 = this.findA("11");
                if (null != a2) {
                    TestUtil.logTrace((String)"A2 is not null");
                }
            }
            Vector nullCol = new Vector();
            if (bRef1 != null) {
                bRef1.setACol(nullCol);
                this.getEntityManager().merge((Object)bRef);
                a1.setBCol(nullCol);
                this.getEntityManager().merge((Object)a1);
                this.getEntityTransaction().commit();
            } else {
                TestUtil.logErr((String)"bRef1 was null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMXMTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cascadeAllMXMTest11() throws EETest.Fault {
        boolean pass = false;
        try {
            TestUtil.logTrace((String)"New instances");
            this.getEntityTransaction().begin();
            B b1 = new B("1", "b1", 12);
            B b2 = new B("2", "b2", 12);
            B b3 = new B("3", "b3", 12);
            B b4 = new B("4", "b4", 12);
            Vector<B> v1 = new Vector<B>();
            v1.add(b1);
            v1.add(b2);
            v1.add(b3);
            v1.add(b4);
            TestUtil.logTrace((String)"New A instance");
            A a1 = new A("12", "bean12", 12, v1);
            this.getEntityManager().persist((Object)a1);
            this.getEntityManager().flush();
            pass = this.getEntityManager().contains((Object)a1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("cascadeAllMXMTest11 failed");
        }
    }

    private void createA(A a) {
        TestUtil.logTrace((String)"Entered createA method");
        this.getEntityTransaction().begin();
        this.getEntityManager().persist((Object)a);
        this.getEntityManager().flush();
        this.getEntityTransaction().commit();
    }

    private A findA(String id) {
        TestUtil.logTrace((String)"Entered findA method");
        return (A)this.getEntityManager().find(A.class, (Object)id);
    }

    private B findB(String id) {
        TestUtil.logTrace((String)"Entered findB method");
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    private boolean getInstanceStatus(Object o) {
        TestUtil.logTrace((String)"Entered getInstanceStatus method");
        return this.getEntityManager().contains(o);
    }

    private void dumpCollectionDataB(Collection c) {
        TestUtil.logTrace((String)"collection Data");
        TestUtil.logTrace((String)"---------------");
        TestUtil.logTrace((String)("- size=" + c.size()));
        Iterator i = c.iterator();
        int elem = 1;
        while (i.hasNext()) {
            B v = (B)i.next();
            TestUtil.logTrace((String)("- Element #" + elem++));
            TestUtil.logTrace((String)("  id=" + v.getBId() + ", name=" + v.getBName() + ", value=" + v.getBValue()));
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM FKEYS_MXM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM AEJB_MXM_BI_BTOB").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM BEJB_MXM_BI_BTOB").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

