/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.common;

import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.FpUtils;
import com.sun.ts.lib.util.TestUtil;
import java.util.Properties;

public class Utils
extends ServiceEETest {
    private Properties props = null;

    public static boolean isMatchingFloatingPointVal(Float expected, Double obtained) {
        return Utils.isMatchingFloatingPointVal(new Double(expected.doubleValue()), obtained, Math.ulp(expected.floatValue()));
    }

    public static boolean isMatchingFloatingPointVal(Double expected, Float obtained) {
        return Utils.isMatchingFloatingPointVal(expected, new Double(obtained.doubleValue()), Math.ulp(expected.floatValue()));
    }

    public static boolean isMatchingFloatingPointVal(Float expected, Float obtained) {
        return Utils.isMatchingFloatingPointVal(new Double(expected.doubleValue()), new Double(obtained.doubleValue()), Math.ulp(expected.floatValue()));
    }

    public static boolean isMatchingFloatingPointVal(Double expected, Double obtained) {
        return Utils.isMatchingFloatingPointVal(new Double(expected), new Double(obtained), Math.ulp(expected));
    }

    public static boolean isMatchingFloatingPointVal(Double expected, Double obtained, double expectedUlp) {
        boolean rval = false;
        String tracestr = "testing if (golden) expected value=" + expected;
        tracestr = tracestr + " matches obtained value=" + obtained;
        TestUtil.logTrace((String)tracestr);
        double ulpToUse = expectedUlp;
        if (expected.doubleValue() != obtained.doubleValue() && expected == expectedUlp) {
            ulpToUse = Math.ulp(obtained);
        }
        if (Double.compare(expected, obtained) == 0) {
            TestUtil.logTrace((String)"Expected and obtained values matched using Double.compare()");
            rval = true;
        } else if (0 == Utils.testUlpCore(obtained, expected, ulpToUse)) {
            TestUtil.logTrace((String)"values matched based on level of ulp/roundoff being within expected range.");
            rval = true;
        } else {
            TestUtil.logTrace((String)"Doubles do not matched using Double.compare() or calculated roundoff error.");
        }
        return rval;
    }

    public static int testUlpCore(double result, double expected, double ulps) {
        String msg = "testUlpCore:  (double) result = " + result;
        msg = msg + "\n              (double) expected = " + expected;
        msg = msg + "\n              (double) ulps = " + ulps;
        TestUtil.logTrace((String)msg);
        if (Double.compare(expected, result) == 0) {
            return 0;
        }
        if (ulps == 0.0) {
            return 1;
        }
        double difference = expected - result;
        TestUtil.logTrace((String)(" (double) difference = " + difference));
        TestUtil.logTrace((String)("Math.abs(difference/Math.ulp(expected)) = " + Math.abs(difference / Math.ulp(expected))));
        if (FpUtils.isUnordered((double)expected, (double)result) || Double.isNaN(difference)) {
            TestUtil.logTrace((String)"Unordered values - floating points do not match");
            return 1;
        }
        if (!(Math.abs(difference / Math.ulp(expected)) <= Math.abs(ulps))) {
            TestUtil.logTrace((String)"invalid rounding error detected via ulp");
            return 1;
        }
        TestUtil.logTrace((String)"roundoff was in acceptable range ");
        return 0;
    }
}

