/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.relaxedclientview.common;

import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb32.relaxedclientview.common.HelperSingleton;
import com.sun.ts.tests.ejb32.relaxedclientview.common.NormalInterface1;
import com.sun.ts.tests.ejb32.relaxedclientview.common.NormalInterface2;
import com.sun.ts.tests.ejb32.relaxedclientview.common.TestConstants;
import jakarta.ejb.EJB;
import javax.naming.InitialContext;

public class AbstractHelperSingleton
implements HelperSingleton,
TestConstants {
    @EJB(beanName="NoAnnotationBean", name="noAnnotationNormalInterface1")
    protected NormalInterface1 noAnnotationNormalInterface1;
    @EJB(beanName="NoAnnotationBean", name="noAnnotationNormalInterface2")
    protected NormalInterface2 noAnnotationNormalInterface2;
    @EJB(beanName="LocalAnnotationBean", name="localAnnotationNormalInterface1")
    protected NormalInterface1 localAnnotationNormalInterface1;
    @EJB(beanName="LocalAnnotationBean", name="localAnnotationNormalInterface2")
    protected NormalInterface2 localAnnotationNormalInterface2;
    @EJB(beanName="LocalDDBean", name="localDDNormalInterface1")
    protected NormalInterface1 localDDNormalInterface1;
    protected InitialContext initContext;

    public AbstractHelperSingleton() {
        try {
            this.initContext = new InitialContext();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String noAnnotationTest() throws TestFailedException {
        try {
            int result = this.noAnnotationNormalInterface1.businessMethod1() + this.noAnnotationNormalInterface2.businessMethod2();
            if (result == 3) {
                return String.format("%s ran successfully", "noAnnotationTest");
            }
            throw new TestFailedException(String.format("expected %d, but got %d", 3, result));
        }
        catch (Exception e) {
            throw new TestFailedException(e);
        }
    }

    @Override
    public String localAnnotationTest() throws TestFailedException {
        try {
            int result = this.localAnnotationNormalInterface1.businessMethod1() + this.localAnnotationNormalInterface2.businessMethod2();
            if (result == 3) {
                return String.format("%s ran successfully", "localAnnotationTest");
            }
            throw new TestFailedException(String.format("expected %d, but got %d", 3, result));
        }
        catch (Exception e) {
            throw new TestFailedException(e);
        }
    }

    private Object findEjbByJndi(String jndi) {
        try {
            Object result = this.initContext.lookup(jndi);
            return result;
        }
        catch (Exception e) {
            TLogger.printStackTrace(e);
            return null;
        }
    }

    @Override
    public String oneRemoteAnnotationOnInterfaceTest() throws TestFailedException {
        Object obj = this.findEjbByJndi("java:module/OneRemoteAnnotationOnInterfaceBean!com.sun.ts.tests.ejb32.relaxedclientview.common.NormalInterface2");
        if (obj != null) {
            try {
                NormalInterface2 ni2 = (NormalInterface2)obj;
                ni2.businessMethod2();
            }
            catch (Exception e) {
                return String.format("%s ran successfully", "oneRemoteAnnotationOnInterfaceTest");
            }
        }
        return String.format("%s ran successfully", "oneRemoteAnnotationOnInterfaceTest");
    }

    @Override
    public String oneRemoteAnnotationOnEjbTest() throws TestFailedException {
        Object obj = this.findEjbByJndi("java:module/OneRemoteAnnotationOnEjbBean!com.sun.ts.tests.ejb32.relaxedclientview.common.NormalInterface2");
        if (obj != null) {
            try {
                NormalInterface2 ni2 = (NormalInterface2)obj;
                ni2.businessMethod2();
            }
            catch (Exception e) {
                return String.format("%s ran successfully", "oneRemoteAnnotationOnEjbTest");
            }
            throw new TestFailedException(String.format("jndi %s should not be found", "java:module/OneRemoteAnnotationOnEjbBean!com.sun.ts.tests.ejb32.relaxedclientview.common.NormalInterface2"));
        }
        return String.format("%s ran successfully", "oneRemoteAnnotationOnEjbTest");
    }

    @Override
    public String noInterfaceViewTest() throws TestFailedException {
        NormalInterface1 beanIf1 = (NormalInterface1)this.findEjbByJndi("java:module/NoInterfaceViewBean");
        if (beanIf1 == null) {
            throw new TestFailedException(String.format("jndi %s not found", "java:module/NoInterfaceViewBean"));
        }
        int result = beanIf1.businessMethod1();
        if (result != 1) {
            throw new TestFailedException(String.format("expected %d, but got %d", 1, result));
        }
        Object obj = this.findEjbByJndi("java:module/NoInterfaceViewBean!com.sun.ts.tests.ejb32.relaxedclientview.common.NormalInterface2");
        if (obj != null) {
            try {
                NormalInterface2 ni2 = (NormalInterface2)obj;
                ni2.businessMethod2();
            }
            catch (Exception e) {
                return String.format("%s ran successfully", "noInterfaceViewTest");
            }
            throw new TestFailedException(String.format("jndi %s should not be found", "java:module/NoInterfaceViewBean!com.sun.ts.tests.ejb32.relaxedclientview.common.NormalInterface2"));
        }
        return String.format("%s ran successfully", "noInterfaceViewTest");
    }

    @Override
    public String localDDTest() throws TestFailedException {
        int result = this.localDDNormalInterface1.businessMethod1();
        if (result != 1) {
            throw new TestFailedException(String.format("expected %d, but got %d", 1, result));
        }
        Object obj = this.findEjbByJndi("java:module/LocalDDBean!com.sun.ts.tests.ejb32.relaxedclientview.common.NormalInterface2");
        if (obj != null) {
            try {
                NormalInterface2 ni2 = (NormalInterface2)obj;
                ni2.businessMethod2();
            }
            catch (Exception e) {
                return String.format("%s ran successfully", "localDDTest");
            }
            throw new TestFailedException(String.format("jndi %s should not be found", "java:module/LocalDDBean!com.sun.ts.tests.ejb32.relaxedclientview.common.NormalInterface2"));
        }
        return String.format("%s ran successfully", "localDDTest");
    }
}

