/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonbuilderfactorytests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;

public class BuilderFactory {
    BuilderFactory() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonBuilderFactory API methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonBuilderFactory API methods added in JSON-P 1.1.");
        this.testCreateArrayBuilderString(result);
        this.testCreateArrayBuilderInt(result);
        this.testCreateArrayBuilderBool(result);
        this.testCreateArrayBuilderObject(result);
        this.testCreateArrayBuilderNull(result);
        this.testCreateObjectBuilderString(result);
        this.testCreateObjectBuilderInt(result);
        this.testCreateObjectBuilderBool(result);
        this.testCreateObjectBuilderObject(result);
        this.testCreateObjectBuilderNull(result);
        return result;
    }

    private void testCreateArrayBuilderString(TestResult result) {
        TestUtil.logMsg((String)" - createArrayBuilder(JsonArray) for String");
        JsonArray in = SimpleValues.createStringArray2();
        JsonArray check = SimpleValues.createStringArray2();
        this.verifyCreateArrayBuilder(result, check, in);
    }

    private void testCreateArrayBuilderInt(TestResult result) {
        TestUtil.logMsg((String)" - createArrayBuilder(JsonArray) for int");
        JsonArray in = SimpleValues.createIntArray2();
        JsonArray check = SimpleValues.createIntArray2();
        this.verifyCreateArrayBuilder(result, check, in);
    }

    private void testCreateArrayBuilderBool(TestResult result) {
        TestUtil.logMsg((String)" - createArrayBuilder(JsonArray) for boolean");
        JsonArray in = SimpleValues.createBoolArray2();
        JsonArray check = SimpleValues.createBoolArray2();
        this.verifyCreateArrayBuilder(result, check, in);
    }

    private void testCreateArrayBuilderObject(TestResult result) {
        TestUtil.logMsg((String)" - createArrayBuilder(JsonArray) for JsonObject");
        JsonArray in = SimpleValues.createObjectArray2();
        JsonArray check = SimpleValues.createObjectArray2();
        this.verifyCreateArrayBuilder(result, check, in);
    }

    private void testCreateArrayBuilderNull(TestResult result) {
        TestUtil.logMsg((String)" - createArrayBuilder(JsonArray) for null");
        JsonArray in = null;
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        try {
            factory.createArrayBuilder(in);
            result.fail("createArrayBuilder(JsonArray)", "Calling method with null argument shall throw NullPointerException");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg((String)("    - Expected exception for null argument: " + e.getMessage()));
        }
        catch (Throwable t) {
            result.fail("createObjectBuilder(JsonObject)", "Calling method with with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
        }
    }

    private void testCreateObjectBuilderString(TestResult result) {
        TestUtil.logMsg((String)" - createObjectBuilder(JsonObject) for String");
        JsonObject in = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createSimpleObjectStr();
        this.verifyCreateObjectBuilder(result, check, in);
    }

    private void testCreateObjectBuilderInt(TestResult result) {
        TestUtil.logMsg((String)" - createObjectBuilder(JsonObject) for int");
        JsonObject in = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createSimpleObjectInt();
        this.verifyCreateObjectBuilder(result, check, in);
    }

    private void testCreateObjectBuilderBool(TestResult result) {
        TestUtil.logMsg((String)" - createObjectBuilder(JsonObject) for boolean");
        JsonObject in = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createSimpleObjectBool();
        this.verifyCreateObjectBuilder(result, check, in);
    }

    private void testCreateObjectBuilderObject(TestResult result) {
        TestUtil.logMsg((String)" - createObjectBuilder(JsonObject) for JsonObject");
        JsonObject in = SimpleValues.createSimpleObjectObject();
        JsonObject check = SimpleValues.createSimpleObjectObject();
        this.verifyCreateObjectBuilder(result, check, in);
    }

    private void verifyCreateArrayBuilder(TestResult result, JsonArray check, JsonArray in) {
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        JsonArrayBuilder builder = factory.createArrayBuilder(in);
        JsonArray out = builder.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("createArrayBuilder(JsonArray)", "Output builder " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void verifyCreateObjectBuilder(TestResult result, JsonObject check, JsonObject in) {
        TestUtil.logMsg((String)("    - IN: " + JsonAssert.valueToString((JsonValue)in)));
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        JsonObjectBuilder builder = factory.createObjectBuilder(in);
        JsonObject out = builder.build();
        if (this.operationFailed((JsonValue)check, (JsonValue)out)) {
            result.fail("createObjectBuilder(JsonObject)", "Output builder " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void testCreateObjectBuilderNull(TestResult result) {
        TestUtil.logMsg((String)" - createObjectBuilder(JsonObject) for null");
        JsonObject in = null;
        JsonBuilderFactory factory = Json.createBuilderFactory(null);
        try {
            factory.createObjectBuilder(in);
            result.fail("createObjectBuilder(JsonObject)", "Calling method with null argument shall throw NullPointerException");
        }
        catch (NullPointerException e) {
            TestUtil.logMsg((String)("    - Expected exception for null argument: " + e.getMessage()));
        }
        catch (Throwable t) {
            result.fail("createObjectBuilder(JsonObject)", "Calling method with with null argument shall throw NullPointerException, not " + t.getClass().getSimpleName());
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

