/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonparsertests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;

public class Parser {
    private static final JsonValue[] VALUES = new JsonValue[]{SimpleValues.toJsonValue("In a galaxy far far away"), SimpleValues.toJsonValue(42), SimpleValues.toJsonValue(9223372036854775765L), SimpleValues.toJsonValue(3.441073578556931E305), SimpleValues.toJsonValue(true), SimpleValues.toJsonValue(SimpleValues.BDC_VALUE), SimpleValues.toJsonValue(SimpleValues.BIN_VALUE), SimpleValues.createSimpleObjectStr(), SimpleValues.createSimpleObjectInt(), SimpleValues.createSimpleObjectBool(), SimpleValues.createSimpleObjectObject(), SimpleValues.createEmptyArrayWithStr(), SimpleValues.createEmptyArrayWithInt(), SimpleValues.createEmptyArrayWithBool(), SimpleValues.createEmptyArrayWithObject()};
    private static final JsonStructure[] COMPOUND_VALUES = new JsonStructure[]{SimpleValues.createSimpleObjectStr(), SimpleValues.createSimpleObjectInt(), SimpleValues.createSimpleObjectBool(), SimpleValues.createSimpleObjectObject(), SimpleValues.createEmptyArrayWithStr(), SimpleValues.createEmptyArrayWithInt(), SimpleValues.createEmptyArrayWithBool(), SimpleValues.createEmptyArrayWithObject()};
    private static final JsonStructure[] EMPTY_VALUES = new JsonStructure[]{SimpleValues.createEmptyObject(), SimpleValues.createEmptyArray()};
    private static final JsonObject[] OBJ_VALUES = new JsonObject[]{SimpleValues.createSimpleObjectStr(), SimpleValues.createSimpleObjectInt(), SimpleValues.createSimpleObjectBool(), SimpleValues.createSimpleObjectObject(), SimpleValues.createSimpleObjectWithStr()};
    private static final JsonValue[] NON_OBJ_VALUES = new JsonValue[]{SimpleValues.toJsonValue("In a galaxy far far away"), SimpleValues.toJsonValue(42), SimpleValues.toJsonValue(9223372036854775765L), SimpleValues.toJsonValue(3.441073578556931E305), SimpleValues.toJsonValue(true), SimpleValues.toJsonValue(SimpleValues.BDC_VALUE), SimpleValues.toJsonValue(SimpleValues.BIN_VALUE), SimpleValues.createEmptyArrayWithStr(), SimpleValues.createEmptyArrayWithInt(), SimpleValues.createEmptyArrayWithBool(), SimpleValues.createEmptyArrayWithObject()};
    private static final JsonArray[] ARRAY_VALUES = new JsonArray[]{SimpleValues.createEmptyArrayWithStr(), SimpleValues.createEmptyArrayWithInt(), SimpleValues.createEmptyArrayWithBool(), SimpleValues.createEmptyArrayWithObject()};
    private static final JsonValue[] NON_ARRAY_VALUES = new JsonValue[]{SimpleValues.toJsonValue("In a galaxy far far away"), SimpleValues.toJsonValue(42), SimpleValues.toJsonValue(9223372036854775765L), SimpleValues.toJsonValue(3.441073578556931E305), SimpleValues.toJsonValue(true), SimpleValues.toJsonValue(SimpleValues.BDC_VALUE), SimpleValues.toJsonValue(SimpleValues.BIN_VALUE), SimpleValues.createSimpleObjectStr(), SimpleValues.createSimpleObjectInt(), SimpleValues.createSimpleObjectBool(), SimpleValues.createSimpleObjectObject()};

    Parser() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonParser API methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonParser API methods added in JSON-P 1.1.");
        this.testGetObject(result);
        this.testGetNonObject(result);
        this.testGetArray(result);
        this.testGetNonArray(result);
        this.testGetValue(result);
        this.testGetIllegalValue(result);
        this.testGetObjectStream(result);
        this.testGetNonObjectStream(result);
        this.testGetArrayStream(result);
        this.testGetNonArrayStream(result);
        this.testGetValueStream(result);
        this.testGetCompoundValueStream(result);
        this.testSkipArray(result);
        this.testSkipNonArray(result);
        this.testSkipObject(result);
        this.testSkipNonObject(result);
        return result;
    }

    private void testGetObject(TestResult result) {
        for (JsonObject value : OBJ_VALUES) {
            String data = SimpleValues.jsonData((JsonValue)value);
            TestUtil.logMsg((String)(" - getObject() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                JsonObject out = parser.getObject();
                if (!this.operationFailed((JsonValue)value, (JsonValue)out)) continue;
                result.fail("getObject()", "Output value " + JsonAssert.valueToString((JsonValue)out) + " shall be " + JsonAssert.valueToString((JsonValue)value));
            }
            catch (JsonException ex) {
                TestUtil.logMsg((String)("Caught JsonException: " + ex.getLocalizedMessage()));
                result.fail("getObject()", "Caught JsonException: " + ex.getLocalizedMessage());
            }
        }
    }

    private void testGetNonObject(TestResult result) {
        for (JsonValue value : NON_OBJ_VALUES) {
            String data = SimpleValues.jsonData(value);
            TestUtil.logMsg((String)(" - getObject() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.getObject();
                result.fail("getObject()", "Calling method on non object value shall throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                TestUtil.logMsg((String)("      Expected exception: " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("getObject()", "Calling method on non object value shall throw IllegalStateException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testGetArray(TestResult result) {
        for (JsonArray value : ARRAY_VALUES) {
            String data = SimpleValues.jsonData((JsonValue)value);
            TestUtil.logMsg((String)(" - getArray() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                JsonArray out = parser.getArray();
                if (!this.operationFailed((JsonValue)value, (JsonValue)out)) continue;
                result.fail("getArray()", "Output value " + JsonAssert.valueToString((JsonValue)out) + " shall be " + JsonAssert.valueToString((JsonValue)value));
            }
            catch (JsonException ex) {
                TestUtil.logMsg((String)("Caught JsonException: " + ex.getLocalizedMessage()));
                result.fail("getArray()", "Caught JsonException: " + ex.getLocalizedMessage());
            }
        }
    }

    private void testGetNonArray(TestResult result) {
        for (JsonValue value : NON_ARRAY_VALUES) {
            String data = SimpleValues.jsonData(value);
            TestUtil.logMsg((String)(" - getArray() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.getArray();
                result.fail("getArray()", "Calling method on non array value shall throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                TestUtil.logMsg((String)("      Expected exception: " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("getArray()", "Calling method on non array value shall throw IllegalStateException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testGetValue(TestResult result) {
        for (JsonValue value : VALUES) {
            String data = SimpleValues.jsonData(value);
            TestUtil.logMsg((String)(" - getValue() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                JsonValue out = parser.getValue();
                if (!this.operationFailed(value, out)) continue;
                result.fail("getValue()", "Output value " + JsonAssert.valueToString(out) + " shall be " + JsonAssert.valueToString(value));
            }
            catch (JsonException ex) {
                TestUtil.logMsg((String)("Caught JsonException: " + ex.getLocalizedMessage()));
                result.fail("getValue()", "Caught JsonException: " + ex.getLocalizedMessage());
            }
        }
    }

    private void testGetIllegalValue(TestResult result) {
        for (JsonStructure value : EMPTY_VALUES) {
            String data = SimpleValues.jsonData((JsonValue)value);
            TestUtil.logMsg((String)(" - getValue() on 2nd lexical element of " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.next();
                parser.getValue();
                result.fail("getValue()", "Calling method on END_OBJECT and END_ARRAY lexical elements shall throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                TestUtil.logMsg((String)("      Expected exception: " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("getValue()", "Calling method on END_OBJECT and END_ARRAY lexical elements shall throw IllegalStateException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testGetObjectStream(TestResult result) {
        for (JsonObject value : OBJ_VALUES) {
            String data = SimpleValues.jsonData((JsonValue)value);
            TestUtil.logMsg((String)(" - getObjectStream() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                Stream out = parser.getObjectStream();
                if (!this.operationFailed(value, out)) continue;
                result.fail("getObjectStream()", "Output Stream shall contain " + JsonAssert.valueToString((JsonValue)value));
            }
            catch (JsonException ex) {
                TestUtil.logMsg((String)("Caught JsonException: " + ex.getLocalizedMessage()));
                result.fail("getObjectStream()", "Caught JsonException: " + ex.getLocalizedMessage());
            }
        }
    }

    private void testGetNonObjectStream(TestResult result) {
        for (JsonValue value : NON_OBJ_VALUES) {
            String data = SimpleValues.jsonData(value);
            TestUtil.logMsg((String)(" - getObjectStream() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.getObjectStream();
                result.fail("getObjectStream()", "Calling method on non object value shall throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                TestUtil.logMsg((String)("      Expected exception: " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("getObjectStream()", "Calling method on non object value shall throw IllegalStateException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testGetArrayStream(TestResult result) {
        for (JsonArray value : ARRAY_VALUES) {
            String data = SimpleValues.jsonData((JsonValue)value);
            TestUtil.logMsg((String)(" - getArrayStream() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                Stream out = parser.getArrayStream();
                if (!this.operationFailed(value, out)) continue;
                result.fail("getArrayStream()", "Output Stream shall contain " + JsonAssert.valueToString((JsonValue)value));
            }
            catch (JsonException ex) {
                TestUtil.logMsg((String)("Caught JsonException: " + ex.getLocalizedMessage()));
                result.fail("getArrayStream()", "Caught JsonException: " + ex.getLocalizedMessage());
            }
        }
    }

    private void testGetNonArrayStream(TestResult result) {
        for (JsonValue value : NON_ARRAY_VALUES) {
            String data = SimpleValues.jsonData(value);
            TestUtil.logMsg((String)(" - getArrayStream() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.getArrayStream();
                result.fail("getArrayStream()", "Calling method on non array value shall throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                TestUtil.logMsg((String)("      Expected exception: " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("getArrayStream()", "Calling method on non array value shall throw IllegalStateException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testGetValueStream(TestResult result) {
        for (JsonValue value : VALUES) {
            String data = SimpleValues.jsonData(value);
            TestUtil.logMsg((String)(" - getValueStream() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                Stream outStream = parser.getValueStream();
                int count = 0;
                Iterator i = outStream.iterator();
                while (i.hasNext()) {
                    JsonValue out = (JsonValue)i.next();
                    if (this.operationFailed(value, out)) {
                        result.fail("getValueStream()", "Output Stream value " + JsonAssert.valueToString(out) + " shall be " + JsonAssert.valueToString(value));
                    }
                    ++count;
                }
                if (count == true) continue;
                TestUtil.logMsg((String)("     Output Stream contains " + Integer.toString(count) + " values, not 1"));
                result.fail("getValueStream()", "Output Stream does not contain exactly 1 JSON value");
            }
        }
    }

    private void testGetCompoundValueStream(TestResult result) {
        for (JsonStructure value : COMPOUND_VALUES) {
            String data = SimpleValues.jsonData((JsonValue)value);
            TestUtil.logMsg((String)(" - getValueStream() inside " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.getValueStream();
                result.fail("getValueStream()", "Calling method on non object value shall throw IllegalStateException");
            }
            catch (IllegalStateException e) {
                TestUtil.logMsg((String)("      Expected exception: " + e.getMessage()));
            }
            catch (Throwable t) {
                result.fail("getValueStream()", "Calling method on non object value shall throw IllegalStateException, not " + t.getClass().getSimpleName());
            }
        }
    }

    private void testSkipArray(TestResult result) {
        for (JsonArray value : ARRAY_VALUES) {
            String data = SimpleValues.jsonData((JsonValue)value);
            TestUtil.logMsg((String)(" - skipArray() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.skipArray();
                if (!parser.hasNext()) continue;
                result.fail("skipArray()", "Parser did not davance to the end of the array");
            }
            catch (Throwable t) {
                TestUtil.logMsg((String)("     " + t.getClass().getSimpleName() + ": " + t.getMessage()));
                result.fail("skipArray()", t.getClass().getSimpleName() + ": " + t.getMessage());
            }
        }
    }

    private void testSkipNonArray(TestResult result) {
        for (JsonValue value : NON_ARRAY_VALUES) {
            String data = SimpleValues.jsonData(value);
            TestUtil.logMsg((String)(" - skipArray() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.skipArray();
                JsonValue out = parser.getValue();
                if (!this.operationFailed(value, out)) continue;
                result.fail("skipArray()", "Output value " + JsonAssert.valueToString(out) + " shall be " + JsonAssert.valueToString(value) + " even after skipArray()");
            }
            catch (Throwable t) {
                TestUtil.logMsg((String)("     " + t.getClass().getSimpleName() + ": " + t.getMessage()));
                result.fail("skipArray()", t.getClass().getSimpleName() + ": " + t.getMessage());
            }
        }
    }

    private void testSkipObject(TestResult result) {
        for (JsonObject value : OBJ_VALUES) {
            String data = SimpleValues.jsonData((JsonValue)value);
            TestUtil.logMsg((String)(" - skipObject() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.skipObject();
                if (!parser.hasNext()) continue;
                result.fail("skipObject()", "Parser did not davance to the end of the object");
            }
            catch (Throwable t) {
                TestUtil.logMsg((String)("     " + t.getClass().getSimpleName() + ": " + t.getMessage()));
                result.fail("skipObject()", t.getClass().getSimpleName() + ": " + t.getMessage());
            }
        }
    }

    private void testSkipNonObject(TestResult result) {
        for (JsonValue value : NON_OBJ_VALUES) {
            String data = SimpleValues.jsonData(value);
            TestUtil.logMsg((String)(" - skipObject() on " + data));
            StringReader strReader = new StringReader(data);
            try (JsonParser parser = Json.createParser((Reader)strReader);){
                parser.next();
                parser.skipObject();
                JsonValue out = parser.getValue();
                if (!this.operationFailed(value, out)) continue;
                result.fail("skipObject()", "Output value " + JsonAssert.valueToString(out) + " shall be " + JsonAssert.valueToString(value) + " even after skipObject()");
            }
            catch (Throwable t) {
                TestUtil.logMsg((String)("     " + t.getClass().getSimpleName() + ": " + t.getMessage()));
                result.fail("skipObject()", t.getClass().getSimpleName() + ": " + t.getMessage());
            }
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        TestUtil.logMsg((String)("     Checking " + JsonAssert.valueToString(out)));
        return out == null || !JsonAssert.assertEquals(check, out);
    }

    protected boolean operationFailed(JsonObject check, Stream<Map.Entry<String, JsonValue>> out) {
        if (out == null) {
            TestUtil.logMsg((String)"     Output is null");
            return true;
        }
        HashSet<String> keys = new HashSet<String>(check.size());
        for (String key : check.keySet()) {
            keys.add(key);
        }
        Iterator i = out.iterator();
        while (i.hasNext()) {
            Map.Entry item = (Map.Entry)i.next();
            JsonValue checkValue = (JsonValue)check.get(item.getKey());
            TestUtil.logMsg((String)("     Checking " + JsonAssert.valueToString((JsonValue)item.getValue())));
            if (!((JsonValue)item.getValue()).equals(checkValue)) {
                TestUtil.logMsg((String)("       check: " + JsonAssert.valueToString(checkValue) + " stream: " + JsonAssert.valueToString(checkValue)));
                return true;
            }
            keys.remove(item.getKey());
        }
        return !keys.isEmpty();
    }

    protected boolean operationFailed(JsonArray check, Stream<JsonValue> out) {
        if (out == null) {
            TestUtil.logMsg((String)"     Output is null");
            return true;
        }
        Iterator ci = check.iterator();
        Iterator oi = out.iterator();
        while (ci.hasNext() && oi.hasNext()) {
            JsonValue checkValue = (JsonValue)ci.next();
            JsonValue outValue = (JsonValue)oi.next();
            TestUtil.logMsg((String)("     Checking " + JsonAssert.valueToString(outValue)));
            if (checkValue.equals(outValue)) continue;
            TestUtil.logMsg((String)("       check: " + JsonAssert.valueToString(checkValue) + " stream: " + JsonAssert.valueToString(checkValue)));
            return true;
        }
        if (ci.hasNext()) {
            TestUtil.logMsg((String)"     Output contains less values than expected");
            return true;
        }
        if (oi.hasNext()) {
            TestUtil.logMsg((String)"     Output contains more values than expected");
            return true;
        }
        return false;
    }
}

