/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.incubator.http.AsyncConnection;
import jdk.incubator.http.AsyncSSLConnection;
import jdk.incubator.http.Exchange;
import jdk.incubator.http.Http2ClientImpl;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.PushGroup;
import jdk.incubator.http.SSLConnection;
import jdk.incubator.http.Stream;
import jdk.incubator.http.WindowController;
import jdk.incubator.http.WindowUpdateSender;
import jdk.incubator.http.internal.common.ByteBufferPool;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.HttpHeadersImpl;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.MinimalFuture;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.frame.ContinuationFrame;
import jdk.incubator.http.internal.frame.DataFrame;
import jdk.incubator.http.internal.frame.FramesDecoder;
import jdk.incubator.http.internal.frame.FramesEncoder;
import jdk.incubator.http.internal.frame.GoAwayFrame;
import jdk.incubator.http.internal.frame.HeaderFrame;
import jdk.incubator.http.internal.frame.HeadersFrame;
import jdk.incubator.http.internal.frame.Http2Frame;
import jdk.incubator.http.internal.frame.MalformedFrame;
import jdk.incubator.http.internal.frame.OutgoingHeaders;
import jdk.incubator.http.internal.frame.PingFrame;
import jdk.incubator.http.internal.frame.PushPromiseFrame;
import jdk.incubator.http.internal.frame.ResetFrame;
import jdk.incubator.http.internal.frame.SettingsFrame;
import jdk.incubator.http.internal.frame.WindowUpdateFrame;
import jdk.incubator.http.internal.hpack.Decoder;
import jdk.incubator.http.internal.hpack.DecodingCallback;
import jdk.incubator.http.internal.hpack.Encoder;

class Http2Connection {
    volatile boolean closed;
    final HttpConnection connection;
    private final HttpClientImpl client;
    private final Http2ClientImpl client2;
    private final Map<Integer, Stream<?>> streams = new ConcurrentHashMap();
    private int nextstreamid;
    private int nextPushStream = 2;
    private final Encoder hpackOut;
    private final Decoder hpackIn;
    final SettingsFrame clientSettings;
    private volatile SettingsFrame serverSettings;
    private final String key;
    private final FramesDecoder framesDecoder;
    private final FramesEncoder framesEncoder = new FramesEncoder();
    private final WindowController windowController = new WindowController();
    private final FramesController framesController = new FramesController();
    final WindowUpdateSender windowUpdater;
    static final int DEFAULT_FRAME_SIZE = 16384;
    private ByteBufferPool readBufferPool = new ByteBufferPool();
    private final Object readlock = new Object();
    private static final String CLIENT_PREFACE = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n";
    private static final byte[] PREFACE_BYTES = "PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private ByteBufferPool headerEncodingPool = new ByteBufferPool();
    private final Object sendlock = new Object();

    private Http2Connection(HttpConnection httpConnection, Http2ClientImpl http2ClientImpl, int n, String string) {
        this.connection = httpConnection;
        this.client = http2ClientImpl.client();
        this.client2 = http2ClientImpl;
        this.nextstreamid = n;
        this.key = string;
        this.clientSettings = this.client2.getClientSettings();
        this.framesDecoder = new FramesDecoder(this::processFrame, this.clientSettings.getParameter(5));
        this.serverSettings = SettingsFrame.getDefaultSettings();
        this.hpackOut = new Encoder(this.serverSettings.getParameter(1));
        this.hpackIn = new Decoder(this.clientSettings.getParameter(1));
        this.windowUpdater = new ConnectionWindowUpdateSender(this, this.client.getReceiveBufferSize());
    }

    Http2Connection(HttpConnection httpConnection, Http2ClientImpl http2ClientImpl, Exchange<?> exchange, ByteBuffer byteBuffer) throws IOException, InterruptedException {
        this(httpConnection, http2ClientImpl, 3, Http2Connection.keyFor(httpConnection));
        assert (!(httpConnection instanceof SSLConnection));
        Log.logTrace("Connection send window size {0} ", this.windowController.connectionWindowSize());
        Stream<?> stream = this.createStream(exchange);
        stream.registerStream(1);
        this.windowController.registerStream(1, this.getInitialSendWindowSize());
        stream.requestSent();
        this.sendConnectionPreface();
        AsyncConnection asyncConnection = (AsyncConnection)((Object)httpConnection);
        asyncConnection.setAsyncCallbacks(this::asyncReceive, this::shutdown, this::getReadBuffer);
        httpConnection.configureMode(HttpConnection.Mode.ASYNC);
        this.asyncReceive(ByteBufferReference.of(byteBuffer));
        asyncConnection.startReading();
    }

    static CompletableFuture<Http2Connection> createAsync(HttpConnection httpConnection, Http2ClientImpl http2ClientImpl, Exchange<?> exchange, ByteBuffer byteBuffer) {
        return MinimalFuture.supply(() -> new Http2Connection(httpConnection, http2ClientImpl, exchange, byteBuffer));
    }

    Http2Connection(HttpRequestImpl httpRequestImpl, Http2ClientImpl http2ClientImpl) throws IOException, InterruptedException {
        this(HttpConnection.getConnection(httpRequestImpl.getAddress(http2ClientImpl.client()), http2ClientImpl.client(), httpRequestImpl, true), http2ClientImpl, 1, Http2Connection.keyFor(httpRequestImpl.uri(), httpRequestImpl.proxy(http2ClientImpl.client())));
        Log.logTrace("Connection send window size {0} ", this.windowController.connectionWindowSize());
        AsyncConnection asyncConnection = (AsyncConnection)((Object)this.connection);
        asyncConnection.setAsyncCallbacks(this::asyncReceive, this::shutdown, this::getReadBuffer);
        this.connection.connect();
        this.checkSSLConfig();
        asyncConnection.enableCallback();
        this.sendConnectionPreface();
    }

    private void checkSSLConfig() throws IOException {
    }

    static String keyFor(HttpConnection httpConnection) {
        boolean bl = httpConnection.isProxied();
        boolean bl2 = httpConnection.isSecure();
        InetSocketAddress inetSocketAddress = httpConnection.address();
        return Http2Connection.keyString(bl2, bl, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
    }

    static String keyFor(URI uRI, InetSocketAddress inetSocketAddress) {
        int n;
        String string;
        boolean bl;
        boolean bl2 = uRI.getScheme().equalsIgnoreCase("https");
        boolean bl3 = bl = inetSocketAddress != null;
        if (bl) {
            string = inetSocketAddress.getHostString();
            n = inetSocketAddress.getPort();
        } else {
            string = uRI.getHost();
            n = uRI.getPort();
        }
        return Http2Connection.keyString(bl2, bl, string, n);
    }

    static String keyString(boolean bl, boolean bl2, String string, int n) {
        return (bl ? "S:" : "C:") + (bl2 ? "P:" : "H:") + string + ":" + n;
    }

    String key() {
        return this.key;
    }

    void putConnection() {
        this.client2.putConnection(this);
    }

    private static String toHexdump1(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        StringBuilder stringBuilder = new StringBuilder(512);
        Formatter formatter = new Formatter(stringBuilder);
        while (byteBuffer.hasRemaining()) {
            int n = Byte.toUnsignedInt(byteBuffer.get());
            formatter.format("%02x:", n);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        byteBuffer.reset();
        return stringBuilder.toString();
    }

    private static String toHexdump(ByteBuffer byteBuffer) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        byteBuffer.mark();
        while (byteBuffer.hasRemaining()) {
            if (n % 2 == 0) {
                arrayList.add("");
            }
            byte by = byteBuffer.get();
            String string = Integer.toHexString(256 + Byte.toUnsignedInt(by)).substring(1);
            arrayList.set(n / 2, (String)arrayList.get(n / 2) + string);
            ++n;
        }
        byteBuffer.reset();
        return arrayList.stream().collect(Collectors.joining(" "));
    }

    private void decodeHeaders(HeaderFrame headerFrame, DecodingCallback decodingCallback) {
        boolean bl = headerFrame.getFlag(4);
        ByteBufferReference[] byteBufferReferenceArray = headerFrame.getHeaderBlock();
        for (int i = 0; i < byteBufferReferenceArray.length; ++i) {
            this.hpackIn.decode(byteBufferReferenceArray[i].get(), bl && i == byteBufferReferenceArray.length - 1, decodingCallback);
        }
    }

    int getInitialSendWindowSize() {
        return this.serverSettings.getParameter(4);
    }

    void close() {
        GoAwayFrame goAwayFrame = new GoAwayFrame(0, 0, "Requested by user".getBytes());
        this.sendFrame(goAwayFrame);
    }

    public ByteBufferReference getReadBuffer() {
        return this.readBufferPool.get(this.getMaxReceiveFrameSize() + 9);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncReceive(ByteBufferReference byteBufferReference) {
        Object object = this.readlock;
        synchronized (object) {
            try {
                this.framesController.processReceivedData(this.framesDecoder, byteBufferReference);
            }
            catch (Throwable throwable) {
                String string = Utils.stackTrace(throwable);
                Log.logTrace(string, new Object[0]);
                this.shutdown(throwable);
            }
        }
    }

    void shutdown(Throwable throwable) {
        Log.logError(throwable);
        this.closed = true;
        this.client2.deleteConnection(this);
        LinkedList linkedList = new LinkedList(this.streams.values());
        for (Stream stream : linkedList) {
            stream.cancelImpl(throwable);
        }
        this.connection.close();
    }

    void processFrame(Http2Frame http2Frame) throws IOException {
        Log.logFrames(http2Frame, "IN");
        int n = http2Frame.streamid();
        if (http2Frame instanceof MalformedFrame) {
            Log.logError(((MalformedFrame)http2Frame).getMessage(), new Object[0]);
            if (n == 0) {
                this.protocolError(((MalformedFrame)http2Frame).getErrorCode());
            } else {
                this.resetStream(n, ((MalformedFrame)http2Frame).getErrorCode());
            }
            return;
        }
        if (n == 0) {
            this.handleConnectionFrame(http2Frame);
        } else {
            if (http2Frame instanceof SettingsFrame) {
                this.protocolError(1);
                return;
            }
            Stream stream = this.getStream(n);
            if (stream == null) {
                if (!(http2Frame instanceof ResetFrame)) {
                    this.resetStream(n, 1);
                }
                return;
            }
            if (http2Frame instanceof PushPromiseFrame) {
                PushPromiseFrame pushPromiseFrame = (PushPromiseFrame)http2Frame;
                this.handlePushPromise(stream, pushPromiseFrame);
            } else if (http2Frame instanceof HeaderFrame) {
                this.decodeHeaders((HeaderFrame)http2Frame, stream.rspHeadersConsumer());
                stream.incoming(http2Frame);
            } else {
                stream.incoming(http2Frame);
            }
        }
    }

    private <T> void handlePushPromise(Stream<T> stream, PushPromiseFrame pushPromiseFrame) throws IOException {
        HttpRequestImpl httpRequestImpl = stream.request;
        int n = pushPromiseFrame.getPromisedStream();
        if (n != this.nextPushStream) {
            this.resetStream(n, 1);
            return;
        }
        this.nextPushStream += 2;
        HeaderDecoder headerDecoder = new HeaderDecoder();
        this.decodeHeaders(pushPromiseFrame, headerDecoder);
        HttpHeadersImpl httpHeadersImpl = headerDecoder.headers();
        HttpRequestImpl httpRequestImpl2 = HttpRequestImpl.createPushRequest(httpRequestImpl, httpHeadersImpl);
        Exchange exchange = new Exchange(httpRequestImpl2, stream.exchange.multi);
        Stream.PushedStream<?, T> pushedStream = this.createPushStream(stream, exchange);
        exchange.exchImpl = pushedStream;
        pushedStream.registerStream(n);
        stream.incoming_pushPromise(httpRequestImpl2, pushedStream);
    }

    private void handleConnectionFrame(Http2Frame http2Frame) throws IOException {
        switch (http2Frame.type()) {
            case 4: {
                this.handleSettings((SettingsFrame)http2Frame);
                break;
            }
            case 6: {
                this.handlePing((PingFrame)http2Frame);
                break;
            }
            case 7: {
                this.handleGoAway((GoAwayFrame)http2Frame);
                break;
            }
            case 8: {
                this.handleWindowUpdate((WindowUpdateFrame)http2Frame);
                break;
            }
            default: {
                this.protocolError(1);
            }
        }
    }

    void resetStream(int n, int n2) throws IOException {
        Log.logError("Resetting stream {0,number,integer} with error code {1,number,integer}", n, n2);
        ResetFrame resetFrame = new ResetFrame(n, n2);
        this.sendFrame(resetFrame);
        this.closeStream(n);
    }

    void closeStream(int n) {
        Stream<?> stream = this.streams.remove(n);
        if (stream != null && !(stream instanceof Stream.PushedStream)) {
            this.windowController.removeStream(n);
        }
    }

    private void handleWindowUpdate(WindowUpdateFrame windowUpdateFrame) throws IOException {
        boolean bl;
        int n = windowUpdateFrame.getUpdate();
        if (n > 0 && !(bl = this.windowController.increaseConnectionWindow(n))) {
            this.protocolError(3);
        }
    }

    private void protocolError(int n) throws IOException {
        GoAwayFrame goAwayFrame = new GoAwayFrame(0, n);
        this.sendFrame(goAwayFrame);
        this.shutdown(new IOException("protocol error"));
    }

    private void handleSettings(SettingsFrame settingsFrame) throws IOException {
        assert (settingsFrame.streamid() == 0);
        if (!settingsFrame.getFlag(1)) {
            int n = this.serverSettings.getParameter(4);
            int n2 = settingsFrame.getParameter(4);
            int n3 = n2 - n;
            if (n3 != 0) {
                this.windowController.adjustActiveStreams(n3);
            }
            this.serverSettings = settingsFrame;
            this.sendFrame(new SettingsFrame(1));
        }
    }

    private void handlePing(PingFrame pingFrame) throws IOException {
        pingFrame.setFlag(1);
        this.sendUnorderedFrame(pingFrame);
    }

    private void handleGoAway(GoAwayFrame goAwayFrame) throws IOException {
        this.shutdown(new IOException(String.valueOf(this.connection.channel().getLocalAddress()) + ": GOAWAY received"));
    }

    public int getMaxSendFrameSize() {
        int n = this.serverSettings.getParameter(5);
        if (n == -1) {
            n = 16384;
        }
        return n;
    }

    public int getMaxReceiveFrameSize() {
        return this.clientSettings.getParameter(5);
    }

    public int getMaxHeadersSize() {
        return this.serverSettings.getParameter(6);
    }

    private void sendConnectionPreface() throws IOException {
        Log.logTrace("{0}: start sending connection preface to {1}", this.connection.channel().getLocalAddress(), this.connection.address());
        SettingsFrame settingsFrame = this.client2.getClientSettings();
        ByteBufferReference byteBufferReference = this.framesEncoder.encodeConnectionPreface(PREFACE_BYTES, settingsFrame);
        Log.logFrames(settingsFrame, "OUT");
        this.connection.write(byteBufferReference.get());
        this.framesController.markPrefaceSent();
        Log.logTrace("PREFACE_BYTES sent", new Object[0]);
        Log.logTrace("Settings Frame sent", new Object[0]);
        int n = this.client2.client().getReceiveBufferSize() - 65535;
        this.windowUpdater.sendWindowUpdate(n);
        Log.logTrace("finished sending connection preface", new Object[0]);
    }

    <T> Stream<T> getStream(int n) {
        return this.streams.get(n);
    }

    <T> Stream<T> createStream(Exchange<T> exchange) {
        Stream<T> stream = new Stream<T>(this.client, this, exchange, this.windowController);
        return stream;
    }

    <T> Stream.PushedStream<?, T> createPushStream(Stream<T> stream, Exchange<T> exchange) {
        PushGroup pushGroup = stream.exchange.getPushGroup();
        return new Stream.PushedStream(pushGroup, this.client, this, stream, exchange);
    }

    <T> void putStream(Stream<T> stream, int n) {
        this.streams.put(n, stream);
    }

    void deleteStream(int n) {
        this.streams.remove(n);
        this.windowController.removeStream(n);
    }

    private List<HeaderFrame> encodeHeaders(OutgoingHeaders<Stream<?>> outgoingHeaders) {
        List<ByteBufferReference> list = this.encodeHeadersImpl(this.getMaxSendFrameSize(), outgoingHeaders.getAttachment().getRequestPseudoHeaders(), outgoingHeaders.getUserHeaders(), outgoingHeaders.getSystemHeaders());
        ArrayList<HeaderFrame> arrayList = new ArrayList<HeaderFrame>(list.size());
        Iterator<ByteBufferReference> iterator = list.iterator();
        HeaderFrame headerFrame = new HeadersFrame(outgoingHeaders.streamid(), outgoingHeaders.getFlags(), iterator.next());
        arrayList.add(headerFrame);
        while (iterator.hasNext()) {
            headerFrame = new ContinuationFrame(outgoingHeaders.streamid(), iterator.next());
            arrayList.add(headerFrame);
        }
        headerFrame.setFlag(4);
        return arrayList;
    }

    private ByteBufferReference getHeaderBuffer(int n) {
        ByteBufferReference byteBufferReference = this.headerEncodingPool.get(n);
        byteBufferReference.get().limit(n);
        return byteBufferReference;
    }

    private List<ByteBufferReference> encodeHeadersImpl(int n, HttpHeaders ... httpHeadersArray) {
        ByteBufferReference byteBufferReference = this.getHeaderBuffer(n);
        ArrayList<ByteBufferReference> arrayList = new ArrayList<ByteBufferReference>();
        for (HttpHeaders httpHeaders : httpHeadersArray) {
            for (Map.Entry<String, List<String>> entry : httpHeaders.map().entrySet()) {
                String string = entry.getKey().toLowerCase();
                List<String> list = entry.getValue();
                for (String string2 : list) {
                    this.hpackOut.header(string, string2);
                    while (!this.hpackOut.encode(byteBufferReference.get())) {
                        byteBufferReference.get().flip();
                        arrayList.add(byteBufferReference);
                        byteBufferReference = this.getHeaderBuffer(n);
                    }
                }
            }
        }
        byteBufferReference.get().flip();
        arrayList.add(byteBufferReference);
        return arrayList;
    }

    private ByteBufferReference[] encodeHeaders(OutgoingHeaders<Stream<?>> outgoingHeaders, Stream<?> stream) {
        Object object;
        outgoingHeaders.streamid(stream.streamid);
        if (Log.headers()) {
            object = new StringBuilder("HEADERS FRAME (stream=");
            ((StringBuilder)object).append(stream.streamid).append(")\n");
            Log.dumpHeaders((StringBuilder)object, "    ", outgoingHeaders.getAttachment().getRequestPseudoHeaders());
            Log.dumpHeaders((StringBuilder)object, "    ", outgoingHeaders.getSystemHeaders());
            Log.dumpHeaders((StringBuilder)object, "    ", outgoingHeaders.getUserHeaders());
            Log.logHeaders(((StringBuilder)object).toString(), new Object[0]);
        }
        object = this.encodeHeaders(outgoingHeaders);
        return this.encodeFrames((List<HeaderFrame>)object);
    }

    private ByteBufferReference[] encodeFrames(List<HeaderFrame> list) {
        if (Log.frames()) {
            list.forEach(headerFrame -> Log.logFrames(headerFrame, "OUT"));
        }
        return this.framesEncoder.encodeFrames(list);
    }

    static Throwable getExceptionFrom(CompletableFuture<?> completableFuture) {
        try {
            completableFuture.get();
            return null;
        }
        catch (Throwable throwable) {
            if (throwable.getCause() != null) {
                return throwable.getCause();
            }
            return throwable;
        }
    }

    private Stream<?> registerNewStream(OutgoingHeaders<Stream<?>> outgoingHeaders) {
        Stream<?> stream = outgoingHeaders.getAttachment();
        int n = this.nextstreamid;
        this.nextstreamid += 2;
        stream.registerStream(n);
        this.windowController.registerStream(n, this.getInitialSendWindowSize());
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendFrame(Http2Frame http2Frame) {
        block7: {
            try {
                Object object = this.sendlock;
                synchronized (object) {
                    if (http2Frame instanceof OutgoingHeaders) {
                        OutgoingHeaders outgoingHeaders = (OutgoingHeaders)http2Frame;
                        Stream<?> stream = this.registerNewStream(outgoingHeaders);
                        this.connection.writeAsync(this.encodeHeaders(outgoingHeaders, stream));
                    } else {
                        this.connection.writeAsync(this.encodeFrame(http2Frame));
                    }
                }
                this.connection.flushAsync();
            }
            catch (IOException iOException) {
                if (this.closed) break block7;
                Log.logError(iOException);
                this.shutdown(iOException);
            }
        }
    }

    private ByteBufferReference[] encodeFrame(Http2Frame http2Frame) {
        Log.logFrames(http2Frame, "OUT");
        return this.framesEncoder.encodeFrame(http2Frame);
    }

    void sendDataFrame(DataFrame dataFrame) {
        block2: {
            try {
                this.connection.writeAsync(this.encodeFrame(dataFrame));
                this.connection.flushAsync();
            }
            catch (IOException iOException) {
                if (this.closed) break block2;
                Log.logError(iOException);
                this.shutdown(iOException);
            }
        }
    }

    void sendUnorderedFrame(Http2Frame http2Frame) {
        block2: {
            try {
                this.connection.writeAsyncUnordered(this.encodeFrame(http2Frame));
                this.connection.flushAsync();
            }
            catch (IOException iOException) {
                if (this.closed) break block2;
                Log.logError(iOException);
                this.shutdown(iOException);
            }
        }
    }

    static final class ALPNException
    extends IOException {
        private static final long serialVersionUID = 23138275393635783L;
        final AsyncSSLConnection connection;

        ALPNException(String string, AsyncSSLConnection asyncSSLConnection) {
            super(string);
            this.connection = asyncSSLConnection;
        }

        AsyncSSLConnection getConnection() {
            return this.connection;
        }
    }

    static final class ConnectionWindowUpdateSender
    extends WindowUpdateSender {
        public ConnectionWindowUpdateSender(Http2Connection http2Connection, int n) {
            super(http2Connection, n);
        }

        @Override
        int getStreamId() {
            return 0;
        }
    }

    static class HeaderDecoder
    implements DecodingCallback {
        HttpHeadersImpl headers = new HttpHeadersImpl();

        HeaderDecoder() {
        }

        @Override
        public void onDecoded(CharSequence charSequence, CharSequence charSequence2) {
            this.headers.addHeader(charSequence.toString(), charSequence2.toString());
        }

        HttpHeadersImpl headers() {
            return this.headers;
        }
    }

    private final class FramesController {
        volatile boolean prefaceSent;
        volatile List<ByteBufferReference> pending;

        private FramesController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processReceivedData(FramesDecoder framesDecoder, ByteBufferReference byteBufferReference) throws IOException {
            Object object;
            if (!this.prefaceSent) {
                object = this;
                synchronized (object) {
                    if (!this.prefaceSent) {
                        if (this.pending == null) {
                            this.pending = new ArrayList<ByteBufferReference>();
                        }
                        this.pending.add(byteBufferReference);
                        return false;
                    }
                }
            }
            object = this.pending;
            this.pending = null;
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ByteBufferReference byteBufferReference2 = (ByteBufferReference)iterator.next();
                    framesDecoder.decode(byteBufferReference2);
                }
            }
            framesDecoder.decode(byteBufferReference);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void markPrefaceSent() {
            assert (!this.prefaceSent);
            FramesController framesController = this;
            synchronized (framesController) {
                this.prefaceSent = true;
            }
        }
    }
}

