/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import jdk.incubator.http.AbstractPushPublisher;
import jdk.incubator.http.BlockingPushPublisher;
import jdk.incubator.http.Http1Exchange;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.Response;
import jdk.incubator.http.ResponseContent;
import jdk.incubator.http.ResponseHeaders;
import jdk.incubator.http.internal.common.Log;

class Http1Response<T> {
    private volatile ResponseContent content;
    private final HttpRequestImpl request;
    private Response response;
    private final HttpConnection connection;
    private ResponseHeaders headers;
    private int responseCode;
    private ByteBuffer buffer;
    private final Http1Exchange<T> exchange;
    private final boolean redirecting;
    private boolean return2Cache;
    private boolean finished;
    static final char CR = '\r';
    static final char LF = '\n';

    Http1Response(HttpConnection httpConnection, Http1Exchange<T> http1Exchange) {
        this.request = http1Exchange.request();
        this.exchange = http1Exchange;
        this.connection = httpConnection;
        this.redirecting = false;
        this.buffer = http1Exchange.getBuffer();
    }

    public void readHeaders() throws IOException {
        String string = this.readStatusLine();
        if (string == null) {
            if (Log.errors()) {
                Log.logError("Connection closed. Retry", new Object[0]);
            }
            this.connection.close();
            throw new IOException("Connection closed");
        }
        if (!string.startsWith("HTTP/1.")) {
            throw new IOException("Invalid status line: " + string);
        }
        if (Log.trace()) {
            Log.logTrace("Statusline: {0}", string);
        }
        char c = string.charAt(7);
        this.responseCode = Integer.parseInt(string.substring(9, 12));
        this.headers = new ResponseHeaders(this.connection, this.buffer);
        if (Log.headers()) {
            this.logHeaders(this.headers);
        }
        this.response = new Response(this.request, this.exchange.getExchange(), this.headers, this.responseCode, HttpClient.Version.HTTP_1_1);
    }

    synchronized void completed() {
        this.finished = true;
    }

    synchronized boolean finished() {
        return this.finished;
    }

    ByteBuffer getBuffer() {
        return this.buffer;
    }

    int fixupContentLen(int n) {
        if (this.request.method().equalsIgnoreCase("HEAD")) {
            return 0;
        }
        if (n == -1) {
            if (this.headers.firstValue("Transfer-encoding").orElse("").equalsIgnoreCase("chunked")) {
                return -1;
            }
            return 0;
        }
        return n;
    }

    public CompletableFuture<T> readBody(HttpResponse.BodyProcessor<T> bodyProcessor, boolean bl, Executor executor) {
        BlockingPushPublisher<ByteBuffer> blockingPushPublisher = new BlockingPushPublisher<ByteBuffer>();
        return this.readBody(bodyProcessor, bl, blockingPushPublisher, executor);
    }

    private CompletableFuture<T> readBody(HttpResponse.BodyProcessor<T> bodyProcessor, boolean bl, AbstractPushPublisher<ByteBuffer> abstractPushPublisher, Executor executor) {
        int n;
        this.return2Cache = bl;
        HttpResponse.BodyProcessor<T> bodyProcessor2 = bodyProcessor;
        CompletableFuture<T> completableFuture = bodyProcessor.getBody().toCompletableFuture();
        try {
            n = this.headers.getContentLength();
        }
        catch (IOException iOException) {
            completableFuture.completeExceptionally(iOException);
            return completableFuture;
        }
        int n2 = this.fixupContentLen(n);
        executor.execute(() -> {
            try {
                this.content = new ResponseContent(this.connection, n2, this.headers, bodyProcessor2, abstractPushPublisher.asDataConsumer(), iOException -> {
                    abstractPushPublisher.acceptError((Throwable)iOException);
                    this.connection.close();
                    completableFuture.completeExceptionally((Throwable)iOException);
                }, () -> this.onFinished());
                abstractPushPublisher.subscribe(bodyProcessor);
                if (completableFuture.isCompletedExceptionally()) {
                    this.connection.close();
                    return;
                }
                this.content.pushBody(this.buffer);
            }
            catch (Throwable throwable) {
                completableFuture.completeExceptionally(throwable);
            }
        });
        return completableFuture;
    }

    private void onFinished() {
        if (this.return2Cache) {
            Log.logTrace("Returning connection to the pool: {0}", this.connection);
            this.connection.returnToCache(this.headers);
        }
    }

    private void logHeaders(ResponseHeaders responseHeaders) {
        StringBuilder stringBuilder = new StringBuilder("RESPONSE HEADERS:\n");
        Log.dumpHeaders(stringBuilder, "    ", responseHeaders);
        Log.logHeaders(stringBuilder.toString(), new Object[0]);
    }

    Response response() {
        return this.response;
    }

    boolean redirecting() {
        return this.redirecting;
    }

    HttpHeaders responseHeaders() {
        return this.headers;
    }

    int responseCode() {
        return this.responseCode;
    }

    private int obtainBuffer() throws IOException {
        int n = this.buffer.remaining();
        if (n == 0) {
            this.buffer = this.connection.read();
            if (this.buffer == null) {
                return -1;
            }
            n = this.buffer.remaining();
        }
        return n;
    }

    String readStatusLine() throws IOException {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(128);
        while (this.obtainBuffer() != -1) {
            byte[] byArray = this.buffer.array();
            int n = this.buffer.position();
            int n2 = this.buffer.limit() - n;
            for (int i = 0; i < n2; ++i) {
                char c = (char)byArray[i + n];
                if (bl) {
                    if (c == '\n') {
                        this.buffer.position(i + 1 + n);
                        return stringBuilder.toString();
                    }
                    throw new IOException("invalid status line");
                }
                if (c == '\r') {
                    bl = true;
                    continue;
                }
                stringBuilder.append(c);
            }
            this.buffer.position(this.buffer.limit());
        }
        return null;
    }
}

